/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.internal.commands.HotSpotJavaDumperImpl;
import com.ibm.ws.kernel.boot.internal.commands.IBMJavaDumperImpl;
import com.ibm.ws.kernel.boot.internal.commands.IBMLegacyJavaDumperImpl;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class JavaDumper {
    private static JavaDumper instance = JavaDumper.createInstance();

    private static JavaDumper createInstance() {
        try {
            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
            try {
                Class[] paramTypes = new Class[]{String.class};
                Method javaDumpToFileMethod = dumpClass.getMethod("javaDumpToFile", paramTypes);
                Method heapDumpToFileMethod = dumpClass.getMethod("heapDumpToFile", paramTypes);
                Method triggerDumpMethod = dumpClass.getMethod("triggerDump", paramTypes);
                return new IBMJavaDumperImpl(javaDumpToFileMethod, heapDumpToFileMethod, triggerDumpMethod);
            }
            catch (NoSuchMethodException e) {
                return new IBMLegacyJavaDumperImpl(dumpClass);
            }
        }
        catch (ClassNotFoundException ex) {
            ObjectName diagCommandName;
            ObjectName diagName;
            try {
                diagName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
                diagCommandName = new ObjectName("com.sun.management:type=DiagnosticCommand");
            }
            catch (MalformedObjectNameException ex2) {
                throw new IllegalStateException(ex2);
            }
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            if (!mbeanServer.isRegistered(diagName)) {
                diagName = null;
            }
            if (!mbeanServer.isRegistered(diagCommandName)) {
                diagCommandName = null;
            }
            return new HotSpotJavaDumperImpl(mbeanServer, diagName, diagCommandName);
        }
    }

    public static JavaDumper getInstance() {
        return instance;
    }

    public abstract File dump(JavaDumpAction var1, File var2);
}

