/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.wsbnd.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NestingUtils {
    private static final int PREFIX_GROUP = 1;
    private static final int DIGITS_GROUP = 2;
    private static final int SUFFIX_GROUP = 3;
    static final long serialVersionUID = 7210411303879012775L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static Pattern getPrefixPattern(String ... prefixes) {
        String escapedPrefixes;
        if (prefixes.length == 0) {
            escapedPrefixes = Pattern.quote(prefixes[0]);
        } else {
            StringBuilder escapedPrefixesBuilder = new StringBuilder();
            for (String prefix : prefixes) {
                if (escapedPrefixesBuilder.length() != 0) {
                    escapedPrefixesBuilder.append('|');
                }
                escapedPrefixesBuilder.append(Pattern.quote(prefix));
            }
            escapedPrefixes = escapedPrefixesBuilder.toString();
        }
        return Pattern.compile("^(" + escapedPrefixes + ")\\.([0-9]*)\\.(.*)");
    }

    private static void storeMatch(String matchingKey, Matcher prefixMatcher, List<Map<String, Object>> prefixBucket, Object matchingValue) {
        Map<String, Object> subMap;
        String matchIndexText = prefixMatcher.group(2);
        int matchIndex = Integer.parseInt(matchIndexText);
        if (prefixBucket.size() < matchIndex + 1) {
            for (int bucketNo = prefixBucket.size(); bucketNo < matchIndex + 1; ++bucketNo) {
                prefixBucket.add(null);
            }
        }
        if ((subMap = prefixBucket.get(matchIndex)) == null) {
            subMap = new Hashtable<String, Object>();
            prefixBucket.set(matchIndex, subMap);
        }
        String subKey = prefixMatcher.group(3);
        subMap.put(subKey, matchingValue);
    }

    public static List<Map<String, Object>> nest(String prefix, Map<String, Object> map) {
        Pattern prefixPattern = NestingUtils.getPrefixPattern(prefix);
        ArrayList<Map<String, Object>> collectedMatches = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Matcher prefixMatcher = prefixPattern.matcher(key);
            if (!prefixMatcher.matches()) continue;
            NestingUtils.storeMatch(key, prefixMatcher, collectedMatches, entry.getValue());
        }
        return collectedMatches;
    }

    public static List<Map<String, Object>> nest(String prefix, Dictionary<String, Object> dict) {
        Pattern prefixPattern = NestingUtils.getPrefixPattern(prefix);
        ArrayList<Map<String, Object>> collectedMatches = new ArrayList<Map<String, Object>>();
        Enumeration<String> keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Matcher prefixMatcher = prefixPattern.matcher(key);
            if (!prefixMatcher.matches()) continue;
            NestingUtils.storeMatch(key, prefixMatcher, collectedMatches, dict.get(key));
        }
        return collectedMatches;
    }

    public static Map<String, List<Map<String, Object>>> nest(Map<String, Object> map, String ... prefixes) {
        HashMap<String, List<Map<String, Object>>> collectedMatches = new HashMap<String, List<Map<String, Object>>>(prefixes.length);
        for (String prefix : prefixes) {
            collectedMatches.put(prefix, new ArrayList());
        }
        Pattern prefixPattern = NestingUtils.getPrefixPattern(prefixes);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Matcher prefixMatcher = prefixPattern.matcher(key);
            if (!prefixMatcher.matches()) continue;
            String matchingPrefix = prefixMatcher.group(1);
            List prefixBucket = (List)collectedMatches.get(matchingPrefix);
            NestingUtils.storeMatch(key, prefixMatcher, prefixBucket, entry.getValue());
        }
        return collectedMatches;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.wsbnd.internal.NestingUtils", NestingUtils.class, null, null);
    }
}

