/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

class JsonTokenUtil {
    public static final String DELIMITER = ".";

    public static String toBase64(JsonObject json) {
        return JsonTokenUtil.convertToBase64(JsonTokenUtil.toJson(json));
    }

    public static String toJson(JsonObject json) {
        return new Gson().toJson((JsonElement)json);
    }

    public static String convertToBase64(String source) {
        return Base64.encodeBase64URLSafeString((byte[])StringUtils.getBytesUtf8((String)source));
    }

    public static String decodeFromBase64String(String encoded) {
        return new String(Base64.decodeBase64((String)encoded));
    }

    public static String fromBase64ToJsonString(String source) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)source));
    }

    public static String toDotFormat(String ... parts) {
        return Joiner.on((char)'.').useForNull("").join((Object[])parts);
    }

    private JsonTokenUtil() {
    }
}

