/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.CXFAuthenticator;
import org.apache.cxf.transport.http.ChunkedUtil;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class URLConnectionHTTPConduit
extends HTTPConduit {
    public static final String HTTPURL_CONNECTION_METHOD_REFLECTION = "use.httpurlconnection.method.reflection";
    public static final String SET_REASON_PHRASE_NOT_NULL = "set.reason.phrase.not.null";
    private static final boolean DEFAULT_USE_REFLECTION;
    private static final boolean SET_REASON_PHRASE;
    protected HttpsURLConnectionFactory connectionFactory = new HttpsURLConnectionFactory();
    static final long serialVersionUID = -1437009929139406416L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public URLConnectionHTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        super(b, ei);
        CXFAuthenticator.addAuthenticator();
    }

    public URLConnectionHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(b, ei, t);
        CXFAuthenticator.addAuthenticator();
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void close() {
        super.close();
        if (this.defaultAddress != null) {
            try {
                URLConnection connect = this.defaultAddress.getURL().openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private HttpURLConnection createConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        URL url = address.getURL();
        URI uri = address.getURI();
        Proxy proxy = this.proxyFactory.createProxy(csPolicy, uri);
        message.put((Object)"http.scheme", (Object)uri.getScheme());
        TLSClientParameters clientParameters = (TLSClientParameters)message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        return this.connectionFactory.createConnection(clientParameters, proxy != null ? proxy : address.getDefaultProxy(), url);
    }

    /*
     * WARNING - void declaration
     */
    public void setAddress(String address) throws IOException {
        try {
            this.defaultAddress = new Address(address);
        }
        catch (URISyntaxException uRISyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"org.apache.cxf.transport.http.URLConnectionHTTPConduit", (String)"134", (Object)this, (Object[])new Object[]{address});
            throw new IOException((Throwable)e);
        }
    }

    @Override
    @FFDCIgnore(value={ProtocolException.class, Throwable.class, Throwable.class})
    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        HttpURLConnection connection = this.createConnection(message, address, csPolicy);
        connection.setDoOutput(true);
        int ctimeout = URLConnectionHTTPConduit.determineConnectionTimeout(message, csPolicy);
        connection.setConnectTimeout(ctimeout);
        int rtimeout = URLConnectionHTTPConduit.determineReceiveTimeout(message, csPolicy);
        connection.setReadTimeout(rtimeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put((Object)"org.apache.cxf.request.method", (Object)"POST");
        }
        try {
            connection.setRequestMethod(httpRequestMethod);
        }
        catch (ProtocolException ex) {
            boolean b = MessageUtils.getContextualBoolean((Message)message, (String)HTTPURL_CONNECTION_METHOD_REFLECTION, (boolean)DEFAULT_USE_REFLECTION);
            if (b) {
                try {
                    Field f = ReflectionUtil.getDeclaredField(HttpURLConnection.class, (String)"method");
                    if (connection instanceof HttpsURLConnection) {
                        try {
                            Field f2 = ReflectionUtil.getDeclaredField(connection.getClass(), (String)"delegate");
                            if (f2 == null) {
                                for (Field field : ReflectionUtil.getDeclaredFields(connection.getClass())) {
                                    if (!HttpURLConnection.class.isAssignableFrom(field.getType())) continue;
                                    f2 = field;
                                    break;
                                }
                            }
                            Object c = null;
                            if (f2 != null && (c = ((Field)ReflectionUtil.setAccessible((AccessibleObject)f2)).get(connection)) instanceof HttpURLConnection) {
                                ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(c, httpRequestMethod);
                            }
                            if (c != null) {
                                f2 = ReflectionUtil.getDeclaredField(c.getClass(), (String)"httpsURLConnection");
                            }
                            if (f2 != null && c != null) {
                                HttpsURLConnection c2 = (HttpsURLConnection)((Field)ReflectionUtil.setAccessible((AccessibleObject)f2)).get(c);
                                ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(c2, httpRequestMethod);
                            }
                        }
                        catch (Throwable t) {
                            this.logStackTrace(t);
                        }
                    }
                    ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(connection, httpRequestMethod);
                    message.put((Object)HTTPURL_CONNECTION_METHOD_REFLECTION, (Object)true);
                }
                catch (Throwable t) {
                    this.logStackTrace(t);
                    throw ex;
                }
            }
            throw ex;
        }
        message.put((Object)"http.connection", (Object)connection);
        message.put((Object)"http.connection.address", (Object)address);
    }

    @Override
    @FFDCIgnore(value={URISyntaxException.class})
    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get((Object)"http.connection");
        if (isChunking && chunkThreshold <= 0) {
            chunkThreshold = 0;
            connection.setChunkedStreamingMode(-1);
        }
        try {
            return new URLConnectionWrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static URI computeURI(Message message, HttpURLConnection connection) throws URISyntaxException {
        Address address = (Address)message.get((Object)"http.connection.address");
        return address != null ? address.getURI() : connection.getURL().toURI();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.URLConnectionHTTPConduit", URLConnectionHTTPConduit.class, null, null);
        DEFAULT_USE_REFLECTION = Boolean.valueOf(SystemPropertyAction.getProperty((String)HTTPURL_CONNECTION_METHOD_REFLECTION, (String)"false"));
        SET_REASON_PHRASE = Boolean.valueOf(SystemPropertyAction.getProperty((String)SET_REASON_PHRASE_NOT_NULL, (String)"false"));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class URLConnectionWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        HttpURLConnection connection;
        static final long serialVersionUID = -1544639760791661222L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        URLConnectionWrappedOutputStream(Message message, HttpURLConnection connection, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName) throws URISyntaxException {
            super(message, needToCacheRequest, isChunking, chunkThreshold, conduitName, URLConnectionHTTPConduit.computeURI(message, connection));
            this.connection = connection;
        }

        protected URLConnectionWrappedOutputStream(URLConnectionWrappedOutputStream wos) {
            super(wos);
            this.connection = wos.connection;
        }

        @FFDCIgnore(value={Throwable.class})
        private OutputStream connectAndGetOutputStream(Boolean b) throws IOException {
            OutputStream cout = null;
            if (b != null && b.booleanValue()) {
                String method = this.connection.getRequestMethod();
                this.connection.connect();
                try {
                    Field f = ReflectionUtil.getDeclaredField(HttpURLConnection.class, (String)"method");
                    ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(this.connection, "POST");
                    cout = this.connection.getOutputStream();
                    ((Field)ReflectionUtil.setAccessible((AccessibleObject)f)).set(this.connection, method);
                }
                catch (Throwable t) {
                    URLConnectionHTTPConduit.this.logStackTrace(t);
                }
            } else {
                cout = this.connection.getOutputStream();
            }
            return cout;
        }

        @Override
        @FFDCIgnore(value={PrivilegedActionException.class, ProtocolException.class, SocketException.class})
        protected void setupWrappedStream() throws IOException {
            OutputStream cout;
            block10: {
                cout = null;
                try {
                    try {
                        if (System.getSecurityManager() != null) {
                            try {
                                cout = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){
                                    static final long serialVersionUID = 3304251432506897901L;
                                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                                    @Override
                                    public OutputStream run() throws IOException {
                                        return URLConnectionWrappedOutputStream.this.connection.getOutputStream();
                                    }

                                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                                    static {
                                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.URLConnectionHTTPConduit$URLConnectionWrappedOutputStream$1", 1.class, null, null);
                                    }
                                });
                                break block10;
                            }
                            catch (PrivilegedActionException e) {
                                throw (IOException)e.getException();
                            }
                        }
                        cout = this.connection.getOutputStream();
                    }
                    catch (ProtocolException pe) {
                        Boolean b = (Boolean)this.outMessage.get((Object)URLConnectionHTTPConduit.HTTPURL_CONNECTION_METHOD_REFLECTION);
                        cout = this.connectAndGetOutputStream(b);
                    }
                }
                catch (SocketException e) {
                    if ("Socket Closed".equals(e.getMessage()) || "HostnameVerifier, socket reset for TTL".equals(e.getMessage())) {
                        this.connection.connect();
                        cout = this.connectAndGetOutputStream((Boolean)this.outMessage.get((Object)URLConnectionHTTPConduit.HTTPURL_CONNECTION_METHOD_REFLECTION));
                    }
                    throw e;
                }
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(cout);
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = cout;
            }
        }

        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(URLConnectionHTTPConduit.this.getClient().getChunkLength());
            }
        }

        @Override
        protected void onFirstWrite() throws IOException {
            super.onFirstWrite();
            if (HTTPConduit.LOG.isLoggable(Level.FINE)) {
                HTTPConduit.LOG.fine("Sending " + this.connection.getRequestMethod() + " Message with Headers to " + this.url + " Conduit :" + this.conduitName + "\n");
            }
        }

        @Override
        protected void setProtocolHeaders() throws IOException {
            new Headers(this.outMessage).setProtocolHeadersInConnection(this.connection);
        }

        @Override
        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            this.connection.connect();
            return new HttpsURLConnectionInfo(this.connection);
        }

        @Override
        protected void updateResponseHeaders(Message inMessage) {
            Headers h = new Headers(inMessage);
            h.readFromConnection(this.connection);
            inMessage.put((Object)"Content-Type", (Object)this.connection.getContentType());
            URLConnectionHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected void handleResponseAsync() throws IOException {
            this.handleResponseOnWorkqueue(true, false);
        }

        @Override
        protected void updateCookiesBeforeRetransmit() {
            Headers h = new Headers();
            h.readFromConnection(this.connection);
            URLConnectionHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        @FFDCIgnore(value={IOException.class})
        protected InputStream getInputStream() throws IOException {
            InputStream in = null;
            if (this.getResponseCode() >= 400) {
                in = this.connection.getErrorStream();
                if (in == null) {
                    try {
                        in = this.connection.getInputStream();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                in = this.connection.getInputStream();
            }
            return in;
        }

        @Override
        protected void closeInputStream() throws IOException {
            InputStream ins = this.connection.getErrorStream();
            if (ins == null) {
                ins = this.connection.getInputStream();
            }
            if (ins != null) {
                IOUtils.consume((InputStream)ins);
                ins.close();
            }
        }

        @Override
        @FFDCIgnore(value={PrivilegedActionException.class})
        protected int getResponseCode() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){
                    static final long serialVersionUID = 3329430769124638175L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Integer run() throws IOException {
                        return URLConnectionWrappedOutputStream.this.connection.getResponseCode();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.URLConnectionHTTPConduit$URLConnectionWrappedOutputStream$2", 2.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        @Override
        protected String getResponseMessage() throws IOException {
            boolean b = MessageUtils.getContextualBoolean((Message)this.outMessage, (String)URLConnectionHTTPConduit.SET_REASON_PHRASE_NOT_NULL, (boolean)SET_REASON_PHRASE);
            if (this.connection.getResponseMessage() == null && b) {
                return "no reason phrase in the response";
            }
            return this.connection.getResponseMessage();
        }

        @Override
        protected InputStream getPartialResponse() throws IOException {
            return ChunkedUtil.getPartialResponse(this.connection, this.connection.getResponseCode());
        }

        @Override
        protected boolean usingProxy() {
            return this.connection.usingProxy();
        }

        @Override
        protected void setFixedLengthStreamingMode(int i) {
        }

        @Override
        @FFDCIgnore(value={PrivilegedActionException.class})
        protected void handleNoOutput() throws IOException {
            if ("POST".equals(this.getMethod())) {
                try {
                    AccessController.doPrivileged(() -> {
                        this.connection.getOutputStream().close();
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        }

        @Override
        @FFDCIgnore(value={URISyntaxException.class})
        protected void setupNewConnection(String newURL) throws IOException {
            Address address;
            HTTPClientPolicy cp = URLConnectionHTTPConduit.this.getClient(this.outMessage);
            try {
                address = URLConnectionHTTPConduit.this.defaultAddress.getString().equals(newURL) ? URLConnectionHTTPConduit.this.defaultAddress : new Address(newURL);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            URLConnectionHTTPConduit.this.setupConnection(this.outMessage, address, cp);
            this.url = address.getURI();
            this.connection = (HttpURLConnection)this.outMessage.get((Object)"http.connection");
        }

        @Override
        protected void retransmitStream() throws IOException {
            Boolean b = (Boolean)this.outMessage.get((Object)URLConnectionHTTPConduit.HTTPURL_CONNECTION_METHOD_REFLECTION);
            OutputStream out = this.connectAndGetOutputStream(b);
            this.cachedStream.writeCacheTo(out);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.transport.http.URLConnectionHTTPConduit$URLConnectionWrappedOutputStream", URLConnectionWrappedOutputStream.class, null, null);
        }
    }
}

