/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.statistics;

import com.ibm.oauth.core.api.statistics.OAuthStatistic;
import com.ibm.oauth.core.api.statistics.OAuthStatistics;
import com.ibm.oauth.core.internal.statistics.OAuthStatHelper;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticImpl;
import java.util.HashMap;
import java.util.Map;

public class OAuthStatisticsImpl
implements OAuthStatistics {
    Map<String, OAuthStatisticImpl> _stats = new HashMap<String, OAuthStatisticImpl>();

    @Override
    public synchronized OAuthStatistic getCounter(String statName) {
        OAuthStatisticImpl result = null;
        OAuthStatisticImpl currentStat = this._stats.get(statName);
        if (currentStat != null) {
            result = new OAuthStatisticImpl(currentStat);
            result.setToNow();
        }
        return result;
    }

    @Override
    public double getAverageTurnaroundTimeMilliseconds(OAuthStatistic t1, OAuthStatistic t2) {
        long totalElapsedTime;
        long totalTxnCount;
        OAuthStatistic start = t1;
        OAuthStatistic end = t2;
        double result = 0.0;
        if (t1.getTimestamp().after(t2.getTimestamp())) {
            start = t2;
            end = t1;
        }
        if ((totalTxnCount = end.getCount() - start.getCount()) > 0L && (totalElapsedTime = end.getElapsedTime().subtract(start.getElapsedTime()).longValue()) > 0L) {
            result = (double)totalElapsedTime / (double)totalTxnCount;
        }
        return result;
    }

    @Override
    public double getTransactionsPerSecond(OAuthStatistic t1, OAuthStatistic t2) {
        long elapsedTimeMilliseconds;
        long totalTxnCount;
        OAuthStatistic start = t1;
        OAuthStatistic end = t2;
        double result = 0.0;
        if (t1.getTimestamp().after(t2.getTimestamp())) {
            start = t2;
            end = t1;
        }
        if ((totalTxnCount = end.getCount() - start.getCount()) > 0L && (elapsedTimeMilliseconds = end.getTimestamp().getTime() - start.getTimestamp().getTime()) > 0L) {
            result = (double)totalTxnCount * 1000.0 / (double)elapsedTimeMilliseconds;
        }
        return result;
    }

    public synchronized void addMeasurement(OAuthStatHelper statHelper) {
        String statName = statHelper.getName();
        OAuthStatisticImpl statImpl = this._stats.get(statName);
        if (statImpl == null) {
            statImpl = new OAuthStatisticImpl(statName);
            this._stats.put(statName, statImpl);
        }
        statImpl.addMeasurement(statHelper.getElapsedTime());
    }
}

