/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.springboot.utility.tasks;

import com.ibm.ws.springboot.utility.SpringBootUtilityTask;
import com.ibm.ws.springboot.utility.utils.CommandUtils;
import com.ibm.ws.springboot.utility.utils.ConsoleWrapper;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.TreeSet;

public abstract class BaseCommandTask
implements SpringBootUtilityTask {
    public static final String NL = System.getProperty("line.separator");
    protected final String scriptName;

    public BaseCommandTask(String scriptName) {
        this.scriptName = scriptName;
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, boolean forceFormat, Object ... args) {
        return CommandUtils.getOption(key, forceFormat, args);
    }

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String getTaskHelp(String desc, String usage, String requiredKeyPrefix, String requiredDescPrefix, String optionKeyPrefix, String optionDescPrefix, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.usage", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.description", false, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, false, new Object[0]));
        scriptHelp.append(NL);
        String requireds = this.buildScriptOptions(requiredKeyPrefix, requiredDescPrefix);
        if (!requireds.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.required", false, new Object[0]));
            scriptHelp.append(requireds);
        }
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", false, new Object[0]));
            scriptHelp.append(options);
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    protected String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length <= 1) {
            return null;
        }
        return split[1];
    }

    protected String getArgumentValue(String arg, String[] args, ConsoleWrapper stdin, PrintStream stdout) {
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0];
            if (!key.equals(arg)) continue;
            return this.getValue(args[i]);
        }
        return null;
    }

    abstract boolean isKnownArgument(String var1);

    abstract void checkRequiredArguments(String[] var1) throws IllegalArgumentException;

    protected void validateArgumentList(String[] args) {
        this.checkRequiredArguments(args);
        for (int i = 1; i < args.length; ++i) {
            String argPair = args[i];
            String arg = null;
            String value = null;
            if (argPair.contains("=")) {
                arg = argPair.split("=")[0];
                value = this.getValue(argPair);
            } else {
                arg = argPair;
            }
            if (!this.isKnownArgument(arg)) {
                throw new IllegalArgumentException(this.getMessage("invalidArg", arg));
            }
            if (value != null) continue;
            throw new IllegalArgumentException(this.getMessage("missingValue", arg));
        }
    }
}

