/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import com.ibm.ws.transport.iiop.asn1.OIDTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DERObjectIdentifier
extends DERObject {
    String identifier;
    static final long serialVersionUID = -9131022090821004178L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static DERObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERObjectIdentifier(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERObjectIdentifier.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERObjectIdentifier.getInstance(obj.getObject());
    }

    DERObjectIdentifier(byte[] bytes) {
        StringBuilder objId = new StringBuilder();
        long value = 0L;
        boolean first = true;
        for (int i = 0; i != bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            value = value * 128L + (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            if (first) {
                switch ((int)value / 40) {
                    case 0: {
                        objId.append('0');
                        break;
                    }
                    case 1: {
                        objId.append('1');
                        value -= 40L;
                        break;
                    }
                    default: {
                        objId.append('2');
                        value -= 80L;
                    }
                }
                first = false;
            }
            objId.append('.');
            objId.append(Long.toString(value));
            value = 0L;
        }
        this.identifier = objId.toString();
    }

    public DERObjectIdentifier(String identifier) {
        for (int i = identifier.length() - 1; i >= 0; --i) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9' || ch == '.') continue;
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream out, long fieldValue) throws IOException {
        if (fieldValue >= 128L) {
            if (fieldValue >= 16384L) {
                if (fieldValue >= 0x200000L) {
                    if (fieldValue >= 0x10000000L) {
                        if (fieldValue >= 8L) {
                            if (fieldValue >= 1024L) {
                                if (fieldValue >= 131072L) {
                                    if (fieldValue >= 0x1000000L) {
                                        out.write((int)(fieldValue >> 56) | 0x80);
                                    }
                                    out.write((int)(fieldValue >> 49) | 0x80);
                                }
                                out.write((int)(fieldValue >> 42) | 0x80);
                            }
                            out.write((int)(fieldValue >> 35) | 0x80);
                        }
                        out.write((int)(fieldValue >> 28) | 0x80);
                    }
                    out.write((int)(fieldValue >> 21) | 0x80);
                }
                out.write((int)(fieldValue >> 14) | 0x80);
            }
            out.write((int)(fieldValue >> 7) | 0x80);
        }
        out.write((int)fieldValue & 0x7F);
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        this.writeField(bOut, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            this.writeField(bOut, Long.parseLong(tok.nextToken()));
        }
        dOut.close();
        byte[] bytes = bOut.toByteArray();
        out.writeEncoded(6, bytes);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)o).identifier);
    }

    public String toString() {
        return this.identifier;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.DERObjectIdentifier", DERObjectIdentifier.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

