/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transport.chfw.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.sip.SipOutboundConnLink;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.util.HashMap;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class SipOutboundChannel
implements OutboundChannel {
    protected static final TraceComponent tc = Tr.register(SipOutboundChannel.class);
    private ChannelData m_config = null;

    public SipOutboundChannel(ChannelData config) {
        this.m_config = config;
    }

    public void start() throws ChannelException {
    }

    public void stop(long millisec) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Stop channel: " + this + " time=" + millisec), (Object[])new Object[0]);
        }
        this.signalNoConnections();
    }

    private void signalNoConnections() {
        EventAdmin engine = GenericEndpointImpl.getEventAdmin();
        HashMap<String, String> eventProps = new HashMap<String, String>(1);
        eventProps.put("ChannelName", this.m_config.getExternalName());
        if (engine != null) {
            Event event = new Event(ChannelFramework.EVENT_STOPCHAIN.toString(), eventProps);
            engine.postEvent(event);
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public void update(ChannelData cc) {
    }

    public Class getApplicationInterface() {
        return null;
    }

    public Class[] getApplicationAddress() {
        return null;
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        return SipOutboundConnLink.getPendingConnection();
    }

    public String getName() {
        return this.m_config.getName();
    }
}

