/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sip.container.appqueue.NativeMessageDispatchingHandler;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.ContextBasedQueue;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;

class SignalingEndOfTask
implements Runnable {
    private static final LogMgr c_logger = Log.get(SignalingEndOfTask.class);
    ContextBasedQueue m_parent;
    protected Queueable m_msg;

    public SignalingEndOfTask(ContextBasedQueue parent, Queueable msg) {
        this.m_parent = parent;
        this.m_msg = msg;
    }

    @Override
    public void run() {
        boolean hangedDetected = false;
        try {
            ThreadLocalStorage.setQueueId(this.m_msg.getQueueIndex() % NativeMessageDispatchingHandler.s_dispatchers);
            this.setLogExtOnThread();
            this.m_parent.reportToFailoverServiceStart();
            this.m_parent.recordThreadID();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "run", "going to run queueable: " + this.m_msg);
            }
            this.m_msg.run();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "run", "finished to run queueable: " + this.m_msg);
            }
            if (this.m_parent.getRecordedThreadID() == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "run", "this thread was marked as hung.");
                }
                hangedDetected = true;
            }
            this.m_parent.unrecordThreadID();
        }
        catch (IllegalStateException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sip.container.was.SignalingEndOfTask.run", (String)"1");
        }
        catch (Throwable th) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error(th.getLocalizedMessage(), "Report", null, th);
            }
        }
        finally {
            this.removeLogExtFromThread();
            if (!hangedDetected) {
                this.m_parent.finishedToExecuteTask(this.m_msg);
            }
            this.m_msg = null;
            ThreadLocalStorage.setQueueId(null);
        }
    }

    public Queueable getTask() {
        return this.m_msg;
    }

    private void setLogExtOnThread() {
        if (PropertiesStore.getInstance().getProperties().getBoolean("enableHpelSipLogExtension")) {
            if (this.m_msg.getApplicationSession() != null) {
                ThreadLocalStorage.setApplicationSession(this.m_msg.getApplicationSession());
            } else {
                ThreadLocalStorage.setTuWrapper(this.m_msg.getTuWrapper());
            }
        }
    }

    private void removeLogExtFromThread() {
        if (PropertiesStore.getInstance().getProperties().getBoolean("enableHpelSipLogExtension")) {
            ThreadLocalStorage.setApplicationSession(null);
            ThreadLocalStorage.setTuWrapper(null);
        }
    }
}

