/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.failover.ReplicatableImpl;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.timer.SipTimerTask;
import com.ibm.ws.sip.container.util.Queueable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public abstract class BaseTimer
extends ReplicatableImpl
implements Runnable,
Queueable,
Comparable {
    static final long serialVersionUID = 3413470086880970783L;
    private static final LogMgr c_logger = Log.get(BaseTimer.class);
    protected boolean m_isPersistent;
    protected boolean m_isFixedDelay;
    protected boolean m_isCancelled;
    protected long m_startTime;
    protected long m_delay;
    protected long m_period;
    protected long m_scheduledExecution;
    protected transient long m_nextExecution;
    protected int m_timerId = -1;
    protected int m_queueIndex = 0;
    private transient SipTimerTask m_timerTask = null;
    private TaskDurationMeasurer _sipContainerQueueDuration = null;
    private TaskDurationMeasurer _sipContainerApplicationCodeDuration = null;

    public void setQueueIndex(int queueIndex) {
        this.m_queueIndex = queueIndex;
    }

    protected abstract int extractQueueIndex();

    @Override
    public int getQueueIndex() {
        return this.m_queueIndex;
    }

    public void setTimerId(int timerId) {
        this.m_timerId = timerId;
    }

    public int getTimerId() {
        return this.m_timerId;
    }

    public boolean isPersistent() {
        return this.m_isPersistent;
    }

    public long scheduledExecutionTime() {
        return this.m_scheduledExecution;
    }

    public boolean isFixedDelay() {
        return this.m_isFixedDelay;
    }

    public void cancel() {
        this.m_isCancelled = true;
        if (this.m_timerTask != null) {
            this.m_timerTask.cancel();
        }
    }

    public int compareTo(Object o) {
        BaseTimer otherTimer = (BaseTimer)o;
        int rc = o == this ? 0 : (otherTimer.m_nextExecution < this.m_nextExecution ? 1 : (otherTimer.m_nextExecution > this.m_nextExecution ? -1 : (o.hashCode() < this.hashCode() ? 1 : -1)));
        return rc;
    }

    public void initTimer(boolean isPersistent, long delay) {
        this.initTimer(isPersistent, delay, 0L, false);
    }

    public void initTimer(boolean isPersistent, long delay, long period, boolean fixedDelay) {
        this.m_isPersistent = isPersistent;
        this.m_startTime = System.currentTimeMillis();
        this.m_delay = delay;
        this.m_period = period;
        this.m_isFixedDelay = fixedDelay;
        this.m_nextExecution = this.m_startTime + delay;
        this.m_scheduledExecution = -1L;
        this.createTimerTask();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "schedule", "Timer to be invoked in " + Long.toString(delay) + " ms");
        }
    }

    protected final void createTimerTask() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "createTimerTask", (Object)this.m_timerTask);
        }
        if (this.m_timerTask != null) {
            this.m_timerTask.cancel();
        }
        this.m_timerTask = new SipTimerTask(this);
    }

    public boolean isCancelled() {
        return this.m_isCancelled;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(96);
        buffer.append("Timer ,Delay:");
        buffer.append(this.m_delay);
        buffer.append(" ,Period:");
        buffer.append(this.m_period);
        buffer.append(" ,Fixed Delay:");
        buffer.append(this.m_isFixedDelay);
        buffer.append(" ,Cancelled:");
        buffer.append(this.m_isCancelled);
        return buffer.toString();
    }

    final void fire() {
        this.m_scheduledExecution = this.m_nextExecution;
        if (this.m_period > 0L) {
            long baseTime = this.isFixedDelay() ? this.m_nextExecution : System.currentTimeMillis();
            this.m_nextExecution = baseTime + this.m_period;
        }
        this.invoke();
    }

    protected void invoke() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "invoke");
        }
        if (!SipContainer.getTasksInvoker().invokeTask(this)) {
            throw new IllegalArgumentException("Failed to dispatch task to SipContainer queue");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "invoke");
        }
    }

    public long getDelay() {
        return this.m_delay;
    }

    public long getPeriod() {
        return this.m_period;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public SipTimerTask getTimerTask() {
        return this.m_timerTask;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "writeObject");
        }
        out.writeBoolean(this.m_isPersistent);
        out.writeBoolean(this.m_isFixedDelay);
        out.writeBoolean(this.m_isCancelled);
        out.writeLong(this.m_startTime);
        out.writeLong(this.m_delay);
        out.writeLong(this.m_period);
        out.writeLong(this.m_scheduledExecution);
        out.writeInt(this.m_timerId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "readObject");
        }
        this.m_isPersistent = in.readBoolean();
        this.m_isFixedDelay = in.readBoolean();
        this.m_isCancelled = in.readBoolean();
        this.m_startTime = in.readLong();
        this.m_delay = in.readLong();
        this.m_period = in.readLong();
        this.m_scheduledExecution = in.readLong();
        this.m_timerId = in.readInt();
        if (!this.m_isCancelled) {
            this.createTimerTask();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "writeExternal");
        }
        out.writeBoolean(this.m_isPersistent);
        out.writeBoolean(this.m_isFixedDelay);
        out.writeBoolean(this.m_isCancelled);
        out.writeLong(this.m_startTime);
        out.writeLong(this.m_delay);
        out.writeLong(this.m_period);
        out.writeLong(this.m_scheduledExecution);
        out.writeInt(this.m_timerId);
    }

    @Override
    public int priority() {
        return 100;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "readExternal");
        }
        this.m_isPersistent = in.readBoolean();
        this.m_isFixedDelay = in.readBoolean();
        this.m_isCancelled = in.readBoolean();
        this.m_startTime = in.readLong();
        this.m_delay = in.readLong();
        this.m_period = in.readLong();
        this.m_scheduledExecution = in.readLong();
        this.m_timerId = in.readInt();
        if (!this.m_isCancelled) {
            this.createTimerTask();
        }
    }

    @Override
    public TaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    @Override
    public TaskDurationMeasurer getApplicationCodeDuration() {
        return this._sipContainerApplicationCodeDuration;
    }

    @Override
    public void setSipContainerQueueDuration(TaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }

    @Override
    public void setApplicationCodeDuration(TaskDurationMeasurer tm) {
        this._sipContainerApplicationCodeDuration = tm;
    }

    @Override
    public Object getServiceSynchronizer() {
        return null;
    }

    @Override
    public void store() {
    }

    @Override
    public void removeFromStorage() {
    }
}

