/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.protocol;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

class FlowTokenSecurity {
    private static final LogMgr s_logger = Log.get(FlowTokenSecurity.class);
    private static final FlowTokenSecurity s_instance = new FlowTokenSecurity();
    private final boolean m_standalone;
    private volatile ArrayList<Secret> m_secretSet;
    private static final String HMACSHA1 = "HmacSHA1";
    private static final ThreadLocal<byte[]> s_workByteArray = new ThreadLocal();

    public static FlowTokenSecurity instance() {
        return s_instance;
    }

    private FlowTokenSecurity() {
        this.m_standalone = true;
        ArrayList<Secret> secretSet = this.initializeSecretSet();
        this.m_secretSet = secretSet;
        this.logSecretKeyInitResult();
    }

    private final ArrayList<Secret> initializeSecretSet() {
        ArrayList<Secret> secretSet;
        if (this.m_standalone) {
            Key key = this.generateKey();
            if (key == null) {
                secretSet = null;
            } else {
                Mac mac = this.initializeMac(key);
                if (mac == null) {
                    secretSet = null;
                } else {
                    Secret secret = new Secret(key, mac);
                    secretSet = new ArrayList<Secret>(1);
                    secretSet.add(secret);
                }
            }
        } else {
            if (s_logger.isWarnEnabled()) {
                s_logger.warn("warn.sip.outbound.no.key.set", null);
            }
            secretSet = null;
        }
        return secretSet;
    }

    private final Key generateKey() {
        SecretKey key;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(HMACSHA1);
            keyGenerator.init(160);
            key = keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e2) {
            if (s_logger.isErrorEnabled()) {
                s_logger.error("error.exception", null, null, (Throwable)e2);
            }
            key = null;
        }
        return key;
    }

    private final Mac initializeMac(Key key) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMACSHA1);
            mac.init(key);
        }
        catch (GeneralSecurityException e2) {
            if (s_logger.isErrorEnabled()) {
                s_logger.error("error.exception", null, null, (Throwable)e2);
            }
            mac = null;
        }
        return mac;
    }

    Secret getLatestSecret() {
        ArrayList<Secret> secretSet = this.m_secretSet;
        if (secretSet == null) {
            return null;
        }
        Secret latestSecret = secretSet.get(0);
        return latestSecret;
    }

    private final void logSecretKeyInitResult() {
        ArrayList<Secret> secretSet = this.m_secretSet;
        if (secretSet == null) {
            if (s_logger.isErrorEnabled()) {
                s_logger.error("error.sip.outbound.failure", null, null);
            }
        } else {
            if (s_logger.isInfoEnabled()) {
                s_logger.info("info.sip.outbound.initialized", null);
            }
            if (s_logger.isTraceDebugEnabled()) {
                StringBuilder b = new StringBuilder(1024);
                int size = secretSet.size();
                b.append("Flow token security initialized with [" + size + "] key(s):\r\n");
                for (int i = 0; i < size; ++i) {
                    Secret secret = secretSet.get(i);
                    b.append(i).append(": ").append(secret.toString()).append("\r\n");
                }
                s_logger.traceDebug(this, "logSecretKeyInitResult", b.toString());
            }
        }
    }

    boolean authenticateMac(ArrayList<Secret> secrets, byte[] byteArray, int offset, int macOffset, int macLength) {
        int nSecrets = secrets.size();
        for (int iSecret = 0; iSecret < nSecrets; ++iSecret) {
            Secret secret = secrets.get(iSecret);
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "authenticateMac", "authenticating MAC by: " + secret);
            }
            Mac mac = secret.m_mac;
            byte[] expectedMac = this.calculateMac(byteArray, offset, macOffset, mac, macLength);
            boolean match = true;
            for (int i = 0; i < macLength; ++i) {
                byte givenByte = byteArray[macOffset + i];
                byte expectedByte = expectedMac[i];
                if (givenByte == expectedByte) continue;
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "authenticateMac", "no match: " + secret);
                }
                match = false;
                break;
            }
            if (!match) continue;
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug(this, "authenticateMac", "match: " + secret);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] calculateMac(byte[] array, int offset, int length, Mac mac, int neededSize) {
        int macSize = mac.getMacLength();
        byte[] macArray = s_workByteArray.get();
        if (macArray == null || macArray.length < macSize) {
            macArray = new byte[macSize];
            s_workByteArray.set(macArray);
        }
        Mac mac2 = mac;
        synchronized (mac2) {
            mac.update(array, offset, length);
            try {
                mac.doFinal(macArray, 0);
            }
            catch (ShortBufferException e2) {
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "calculateMac", "failed writing MAC of [" + macSize + "] to byte array of size [" + macArray.length + ']', e2);
                }
                throw new RuntimeException(e2);
            }
        }
        while (macSize < neededSize) {
            macArray[macSize++] = 0;
        }
        return macArray;
    }

    ArrayList<Secret> getSecretSet() {
        return this.m_secretSet;
    }

    static class Secret {
        Key m_key;
        Mac m_mac;

        Secret(Key key, Mac mac) {
            this.m_key = key;
            this.m_mac = mac;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(256);
            b.append("format [").append(this.m_key.getFormat());
            b.append("] algorithm [").append(this.m_mac.getAlgorithm());
            b.append("] size [").append(this.m_mac.getMacLength()).append(']');
            return b.toString();
        }
    }
}

