/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.parser.SecurityConstraint;
import com.ibm.ws.sip.container.parser.SecurityResourceCollection;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.rules.And;
import com.ibm.ws.sip.container.rules.Condition;
import com.ibm.ws.sip.container.rules.Contains;
import com.ibm.ws.sip.container.rules.Equal;
import com.ibm.ws.sip.container.rules.Exists;
import com.ibm.ws.sip.container.rules.Not;
import com.ibm.ws.sip.container.rules.Or;
import com.ibm.ws.sip.container.rules.SubDomainOf;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SipXMLParser
implements EntityResolver {
    private static final LogMgr c_logger = Log.get(SipXMLParser.class);
    private DocumentBuilder m_documentBuilder;
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String EQUAL = "equal";
    private static final String EXISTS = "exists";
    private static final String CONTAINS = "contains";
    private static final String SUBDOMAIN_OF = "subdomain-of";
    private static final String[] ALL_CONDITIONS = new String[]{"and", "or", "not", "equal", "exists", "contains", "subdomain-of"};
    private static final String DTD_DOC = "sip-app_1_0.dtd";
    private static final String DTD_LOCATION = "/javax/servlet/sip/";
    private static final String VAR = "var";
    private static final String VALUE = "value";
    private static final String IGNORE_CASE = "ignore-case";
    private static final String PATTERN = "pattern";
    private static final String SERVLET_SELECTION = "servlet-selection";
    private static final String MAIN_SERVLET = "main-servlet";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_LOAD_ON_STARTUP = "load-on-startup";
    private static final String SERVLET_INIT_PARAM = "init-param";
    private static final String SERVLET = "servlet";
    private static final String DISPLAY_NAME = "display-name";
    private static final String APP_NAME = "app-name";
    private static final String SIP_APP = "sip-app";
    private static final String LISTENER = "listener";
    private static final String LISTENER_CLASS = "listener-class";
    private static final String SESSION_CONFIG = "session-config";
    private static final String SESSION_TIMEOUT = "session-timeout";
    private static final String CONTEXT_PARAM = "context-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String PROXY_CONFIG = "proxy-config";
    private static final String SEQUENTIAL_SEARCH_TIMEOUT = "sequential-search-timeout";
    private static final String PROXY_TIMEOUT = "proxy-timeout";
    private static final String SECURITY_CONSTRAINT = "security-constraint";
    private static final String RESOURCE_COLLECTION = "resource-collection";
    private static final String RESOURCE_NAME = "resource-name";
    private static final String PROXY_AUTHENTICATION = "proxy-authentication";
    private static final String SIP_METHOD = "sip-method";
    private static final String LOGIN_CONFIG = "login-config";
    private static final String REALM_NAME = "realm-name";

    public SipXMLParser() throws ParserConfigurationException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipXMLParser");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.m_documentBuilder = factory.newDocumentBuilder();
        this.m_documentBuilder.setEntityResolver(this);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipXMLParser");
        }
    }

    public SipAppDesc parse(InputStream in) throws SAXException, IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "parse");
        }
        SipAppDesc app = null;
        Document doc = this.m_documentBuilder.parse(in);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "parse", "Sip Document parsing completed");
        }
        if (null != (app = this.getSipApp(doc))) {
            this.getServletsFromXML(app, doc);
            this.getServletPatternsFromXML(app, doc);
            this.parseMainServlet(app, doc);
            this.getSecurityConstraintsFromXML(app, doc);
            this.getLoginConigFromXML(app, doc);
            this.getListenersFromXML(app, doc);
            this.getAppSessionTTL(app, doc);
            this.getContextParamFromXML(app, doc);
            this.getSequetialSearchTimeout(app, doc);
        }
        return app;
    }

    private void getSequetialSearchTimeout(SipAppDesc app, Document doc) {
        block6: {
            NodeList list = doc.getElementsByTagName(PROXY_CONFIG);
            if (list.getLength() == 1) {
                String txt;
                Node timeoutNode = this.getChildNode(PROXY_TIMEOUT, list.item(0));
                if (timeoutNode == null) {
                    timeoutNode = this.getChildNode(SEQUENTIAL_SEARCH_TIMEOUT, list.item(0));
                }
                if (null != timeoutNode && null != (txt = this.getTextNode(timeoutNode)) && txt.length() > 0) {
                    try {
                        int timeout = Integer.parseInt(txt);
                        app.setProxyTimeout(timeout);
                        if (c_logger.isTraceDebugEnabled()) {
                            StringBuffer b = new StringBuffer(64);
                            b.append("Setting sequential search timeout: ");
                            b.append(timeout);
                            b.append(" Seconds, For App: ");
                            b.append(app.getApplicationName());
                            c_logger.traceDebug(this, "getSequetialSearchTimeout", b.toString());
                        }
                    }
                    catch (NumberFormatException e2) {
                        if (!c_logger.isErrorEnabled()) break block6;
                        Object[] args = new Object[]{app};
                        c_logger.error("error.parsing.proxy.timeout", "Create", args, (Throwable)e2);
                    }
                }
            }
        }
    }

    private void getAppSessionTTL(SipAppDesc app, Document doc) {
        block4: {
            String txt;
            Node timeoutNode;
            NodeList list = doc.getElementsByTagName(SESSION_CONFIG);
            if (list.getLength() == 1 && null != (timeoutNode = this.getChildNode(SESSION_TIMEOUT, list.item(0))) && null != (txt = this.getTextNode(timeoutNode)) && txt.length() > 0) {
                try {
                    int ttl = Integer.parseInt(txt);
                    app.setAppSessionTTL(ttl);
                    if (c_logger.isTraceDebugEnabled()) {
                        StringBuffer b = new StringBuffer(64);
                        b.append("Setting Expiration time: ");
                        b.append(ttl);
                        b.append(" Minutes, For App: ");
                        b.append(app.getApplicationName());
                        c_logger.traceDebug(this, "getAppSessionTTL", b.toString());
                    }
                }
                catch (NumberFormatException e2) {
                    if (!c_logger.isErrorEnabled()) break block4;
                    Object[] args = new Object[]{app};
                    c_logger.error("error.parsing.session.ttl", "Create", args, (Throwable)e2);
                }
            }
        }
    }

    private void getListenersFromXML(SipAppDesc app, Document doc) {
        NodeList list = doc.getElementsByTagName(LISTENER);
        for (int i = 0; i < list.getLength(); ++i) {
            Node listenerClass = this.getChildNode(LISTENER_CLASS, list.item(i));
            if (listenerClass != null) {
                String className = this.getTextNode(listenerClass);
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer b = new StringBuffer(64);
                    b.append("Setting listener class: ");
                    b.append(className);
                    b.append(" For App: ");
                    b.append(app.getApplicationName());
                    c_logger.traceDebug(this, "getListenersFromXML", b.toString());
                }
                app.setSipListeners(Collections.singletonList(className));
                continue;
            }
            if (!c_logger.isWarnEnabled()) continue;
            Object[] args = new Object[]{app};
            c_logger.warn("warn.getting.listeners.failed", "Create", args);
        }
    }

    private void getServletPatternsFromXML(SipAppDesc app, Document doc) {
        List<Object> nodeList;
        NodeList servlet_mapping = doc.getElementsByTagName(SERVLET_SELECTION);
        if (servlet_mapping.getLength() > 0) {
            nodeList = this.getAllChildNodes(new String[]{SERVLET_MAPPING}, servlet_mapping.item(0));
        } else {
            servlet_mapping = doc.getElementsByTagName(SERVLET_MAPPING);
            nodeList = new ArrayList(servlet_mapping.getLength());
            for (int i = 0; i < servlet_mapping.getLength(); ++i) {
                nodeList.add(servlet_mapping.item(i));
            }
        }
        HashMap<String, Condition> servletsPatterns = new HashMap<String, Condition>();
        for (Node node : nodeList) {
            Node servletNameNode = this.getChildNode(SERVLET_NAME, node);
            String servletName = this.getTextNode(servletNameNode);
            Node pattern = this.getChildNode(PATTERN, node);
            if (null == servletName || null == pattern) continue;
            Node baseCondition = this.getChildNode(ALL_CONDITIONS, pattern);
            Condition condition = this.getCondition(baseCondition);
            servletsPatterns.put(servletName, condition);
            if (!c_logger.isTraceDebugEnabled()) continue;
            StringBuffer b = new StringBuffer(64);
            b.append("Siplet name: ");
            b.append(servletName);
            b.append(" Condition: ");
            b.append(condition);
            c_logger.traceDebug(this, "getServletPatternsFromXML", b.toString());
        }
        app.setServletsPatterns(servletsPatterns);
    }

    private void getContextParamFromXML(SipAppDesc app, Document doc) {
        NodeList params = doc.getElementsByTagName(CONTEXT_PARAM);
        for (int i = 0; i < params.getLength(); ++i) {
            NodeList childs = params.item(i).getChildNodes();
            String paramName = null;
            String paramValue = null;
            for (int j = 0; j < childs.getLength() && (paramName == null || paramValue == null); ++j) {
                Node node = childs.item(j);
                if (PARAM_NAME.equalsIgnoreCase(this.getLocalNodeName(node))) {
                    paramName = this.getTextNode(node);
                    continue;
                }
                if (!PARAM_VALUE.equalsIgnoreCase(this.getLocalNodeName(node))) continue;
                paramValue = this.getTextNode(node);
            }
            if (null == paramName || null == paramValue) continue;
            app.addContextParam(paramName, paramValue);
            if (!c_logger.isTraceDebugEnabled()) continue;
            StringBuffer b = new StringBuffer(64);
            b.append("name: ");
            b.append(paramName);
            b.append(" ,Value:");
            b.append(paramValue);
            c_logger.traceDebug(this, "getContextParamFromXML", b.toString());
        }
    }

    private Condition getCondition(Node base) {
        Condition condition = null;
        String type = this.getLocalNodeName(base);
        if (AND.equalsIgnoreCase(type)) {
            List<Condition> subConditions = this.getSubConditions(base);
            condition = new And(subConditions);
        } else if (OR.equalsIgnoreCase(type)) {
            List<Condition> subConditions = this.getSubConditions(base);
            condition = new Or(subConditions);
        } else if (NOT.equalsIgnoreCase(type)) {
            List<Condition> subConditions = this.getSubConditions(base);
            condition = new Not(subConditions.get(0));
        } else if (EQUAL.equalsIgnoreCase(type)) {
            condition = this.getEqualCondition(base);
        } else if (EXISTS.equalsIgnoreCase(type)) {
            condition = this.getExistsCondition(base);
        } else if (CONTAINS.equalsIgnoreCase(type)) {
            condition = this.getContainsCondition(base);
        } else if (SUBDOMAIN_OF.equalsIgnoreCase(type)) {
            condition = this.getSubdomainOfCondtion(base);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{type};
            c_logger.error("error.invalid.condition.type", "Create", args);
        }
        return condition;
    }

    private Condition getSubdomainOfCondtion(Node base) {
        SubDomainOf condition = null;
        String var = this.getTextNode(this.getChildNode(VAR, base));
        String value = this.getTextNode(this.getChildNode(VALUE, base));
        boolean ignoreCase = this.getAttribute(base, IGNORE_CASE, false);
        if (null != var && null != value) {
            var = var.trim();
            value = value.trim();
            condition = new SubDomainOf(var, value, ignoreCase);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{"SUBDOMAIN-OF", var, value};
            c_logger.error("error.parsing.condition", "Create", args);
        }
        return condition;
    }

    private Condition getContainsCondition(Node base) {
        Contains condition = null;
        String var = this.getTextNode(this.getChildNode(VAR, base));
        String value = this.getTextNode(this.getChildNode(VALUE, base));
        boolean ignoreCase = this.getAttribute(base, IGNORE_CASE, false);
        if (null != var && null != value) {
            var = var.trim();
            value = value.trim();
            condition = new Contains(var, value, ignoreCase);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{"CONTAINS", var, value};
            c_logger.error("error.parsing.condition", "Create", args);
        }
        return condition;
    }

    private Condition getExistsCondition(Node base) {
        Exists condition = null;
        String var = this.getTextNode(this.getChildNode(VAR, base));
        if (null != var) {
            var = var.trim();
            condition = new Exists(var);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{"EXISTS", var, ""};
            c_logger.error("error.parsing.condition", "Create", args);
        }
        return condition;
    }

    private Condition getEqualCondition(Node base) {
        Equal condition = null;
        String var = this.getTextNode(this.getChildNode(VAR, base));
        String value = this.getTextNode(this.getChildNode(VALUE, base));
        boolean ignoreCase = this.getAttribute(base, IGNORE_CASE, false);
        if (null != var && null != value) {
            var = var.trim();
            value = value.trim();
            condition = new Equal(var, value, ignoreCase);
        } else if (c_logger.isErrorEnabled()) {
            Object[] args = new Object[]{"EQUAL", var, value};
            c_logger.error("error.parsing.condition", "Create", args);
        }
        return condition;
    }

    private boolean getAttribute(Node node, String attributeName, boolean defaultValue) {
        Node attr;
        boolean rc = defaultValue;
        NamedNodeMap map = node.getAttributes();
        if (map != null && null != (attr = map.getNamedItem(attributeName))) {
            String value = attr.getNodeValue();
            rc = value.equalsIgnoreCase("true");
        }
        return rc;
    }

    public List<Condition> getSubConditions(Node base) {
        LinkedList<Condition> conditionsList = new LinkedList<Condition>();
        List<Node> nodes = this.getAllChildNodes(ALL_CONDITIONS, base);
        if (nodes.size() > 0) {
            for (Node subElement : nodes) {
                Condition subCondtion = this.getCondition(subElement);
                if (null == subCondtion) continue;
                conditionsList.add(subCondtion);
            }
        } else if (c_logger.isErrorEnabled()) {
            c_logger.error("error.parsing.and.condition", "Create", null);
        }
        return conditionsList;
    }

    private SipAppDesc getSipApp(Document doc) {
        SipAppDesc app = null;
        NodeList list = doc.getElementsByTagName(SIP_APP);
        if (list.getLength() == 1) {
            Node displayNameNode = this.getChildNode(DISPLAY_NAME, list.item(0));
            Node appNameNode = this.getChildNode(APP_NAME, list.item(0));
            String display_name = null;
            String app_name = null;
            if (appNameNode != null) {
                app_name = this.getTextNode(appNameNode);
            }
            if (displayNameNode != null) {
                display_name = this.getTextNode(displayNameNode);
            }
            app = new SipAppDesc(display_name, app_name);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSipApp", "New Sip Application: " + app.getApplicationName());
            }
        } else if (c_logger.isErrorEnabled()) {
            c_logger.error("error.parsing.sip.app", "Create", null);
        }
        return app;
    }

    private Node getChildNode(String name, Node parent) {
        Node node = null;
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!name.equalsIgnoreCase(this.getLocalNodeName(list.item(i)))) continue;
            node = list.item(i);
            break;
        }
        return node;
    }

    private Node getChildNode(String[] names, Node parent) {
        Node node = null;
        NodeList list = parent.getChildNodes();
        block0: for (int i = 0; i < list.getLength() && node == null; ++i) {
            String nodeName = this.getLocalNodeName(list.item(i));
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equalsIgnoreCase(nodeName)) continue;
                node = list.item(i);
                continue block0;
            }
        }
        return node;
    }

    private List<Node> getAllChildNodes(String[] names, Node parent) {
        LinkedList<Node> matchingList = new LinkedList<Node>();
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String nodeName = this.getLocalNodeName(list.item(i));
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equalsIgnoreCase(nodeName)) continue;
                matchingList.add(list.item(i));
            }
        }
        return matchingList;
    }

    private void getServletsFromXML(SipAppDesc app, Document doc) {
        LinkedList<SipServletDesc> servletDescriptors = new LinkedList<SipServletDesc>();
        NodeList servlets = doc.getElementsByTagName(SERVLET);
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        for (int i = 0; i < servlets.getLength(); ++i) {
            NodeList childs = servlets.item(i).getChildNodes();
            String servletName = null;
            String servletClass = null;
            int servletLoadOnStartup = -1;
            boolean hasLoadOnStartupTag = false;
            initParams.clear();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node node = childs.item(j);
                String string = this.getLocalNodeName(node);
                if (SERVLET_NAME.equalsIgnoreCase(string)) {
                    servletName = this.getTextNode(node);
                    continue;
                }
                if (SERVLET_CLASS.equalsIgnoreCase(string)) {
                    servletClass = this.getTextNode(node);
                    continue;
                }
                if (SERVLET_LOAD_ON_STARTUP.equalsIgnoreCase(string)) {
                    try {
                        servletLoadOnStartup = Integer.parseInt(this.getTextNode(node));
                    }
                    catch (NumberFormatException e2) {
                        servletLoadOnStartup = 0;
                    }
                    hasLoadOnStartupTag = true;
                    continue;
                }
                if (!SERVLET_INIT_PARAM.equalsIgnoreCase(string)) continue;
                this.getServletInitParamsFromXML(node, initParams);
            }
            if (null == servletName || null == servletClass) continue;
            SipServletDesc desc = new SipServletDesc(app, servletName, servletClass, servletLoadOnStartup, hasLoadOnStartupTag);
            for (Map.Entry entry : initParams.entrySet()) {
                desc.setInitParam((String)entry.getKey(), (String)entry.getValue());
            }
            servletDescriptors.add(desc);
            if (!c_logger.isTraceDebugEnabled()) continue;
            StringBuffer b = new StringBuffer(64);
            b.append("New Servlet: ").append(servletName).append(" ,Class:").append(servletClass).append(" , load-on-startup: ").append(servletLoadOnStartup);
            c_logger.traceDebug(this, "getServletsFromXML", b.toString());
        }
        app.addSipServlets(servletDescriptors);
    }

    private void getServletInitParamsFromXML(Node initParamNode, Map<String, String> initParams) {
        String paramName = null;
        String paramValue = null;
        NodeList params = initParamNode.getChildNodes();
        for (int i = 0; i < params.getLength(); ++i) {
            Node node = params.item(i);
            if (PARAM_NAME.equalsIgnoreCase(this.getLocalNodeName(node))) {
                paramName = this.getTextNode(node);
            } else if (PARAM_VALUE.equalsIgnoreCase(this.getLocalNodeName(node))) {
                paramValue = this.getTextNode(node);
            }
            if (null == paramName || null == paramValue) continue;
            initParams.put(paramName, paramValue);
            if (!c_logger.isTraceDebugEnabled()) break;
            StringBuffer b = new StringBuffer(64);
            b.append("name: ");
            b.append(paramName);
            b.append(" ,Value:");
            b.append(paramValue);
            c_logger.traceDebug(this, "getServletInitParamsFromXML", b.toString());
            break;
        }
    }

    private void parseMainServlet(SipAppDesc app, Document doc) {
        NodeList servlet_selection = doc.getElementsByTagName(SERVLET_SELECTION);
        String value = null;
        for (int i = 0; i < servlet_selection.getLength(); ++i) {
            Node child = this.getChildNode(MAIN_SERVLET, servlet_selection.item(i));
            if (child == null) continue;
            value = child.getTextContent().trim();
            break;
        }
        boolean setValue = true;
        if (value != null && !value.isEmpty()) {
            if (app.hasMainServlet()) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("Application has already defined main-servlet", "Create", app);
                }
                setValue = false;
            }
            if (setValue) {
                app.setMainSipletName(value);
            }
        }
    }

    private void getSecurityConstraintsFromXML(SipAppDesc app, Document doc) {
        NodeList constraints = doc.getElementsByTagName(SECURITY_CONSTRAINT);
        for (int i = 0; i < constraints.getLength(); ++i) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "found new security constraint");
            }
            SecurityConstraint secCon = new SecurityConstraint();
            app.addSecurityConstraint(secCon);
            NodeList childs = constraints.item(i).getChildNodes();
            String displayName = null;
            SecurityResourceCollection rc = null;
            for (int j = 0; j < childs.getLength(); ++j) {
                Node node = childs.item(j);
                String nodeName = this.getLocalNodeName(node);
                if (DISPLAY_NAME.equalsIgnoreCase(nodeName)) {
                    displayName = this.getTextNode(node);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "display-name[" + displayName + "]");
                    }
                    secCon.setDisplayName(displayName);
                    continue;
                }
                if (PROXY_AUTHENTICATION.equalsIgnoreCase(nodeName)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "proxy-authenticate enable");
                    }
                    secCon.setProxyAuthenticate(true);
                    continue;
                }
                if (!RESOURCE_COLLECTION.equalsIgnoreCase(nodeName)) continue;
                NodeList resourceCollection = node.getChildNodes();
                rc = new SecurityResourceCollection(secCon);
                SipServletDesc siplet = null;
                String rname = null;
                String sipletName = null;
                String method = null;
                for (int j1 = 0; j1 < resourceCollection.getLength(); ++j1) {
                    Node rnodeChild = resourceCollection.item(j1);
                    String rnodeName = this.getLocalNodeName(rnodeChild);
                    if (RESOURCE_NAME.equalsIgnoreCase(rnodeName)) {
                        rname = this.getTextNode(rnodeChild);
                        if (!c_logger.isTraceDebugEnabled()) continue;
                        c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "resource-name[" + rname + "]");
                        continue;
                    }
                    if (SERVLET_NAME.equalsIgnoreCase(rnodeName)) {
                        sipletName = this.getTextNode(rnodeChild);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "servlet-name[" + sipletName + "]");
                        }
                        siplet = app.getSipServlet(sipletName);
                        siplet.addSecurityResourceCollection(rc);
                        rc.addSiplet(siplet);
                        continue;
                    }
                    if (!SIP_METHOD.equalsIgnoreCase(rnodeName)) continue;
                    method = this.getTextNode(rnodeChild);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "getSecurityConstraintsFromXML", "sip-method[" + method + "]");
                    }
                    rc.addMethod(method);
                }
            }
        }
    }

    private void getLoginConigFromXML(SipAppDesc app, Document doc) {
        NodeList constraints = doc.getElementsByTagName(LOGIN_CONFIG);
        for (int i = 0; i < constraints.getLength(); ++i) {
            NodeList childs = constraints.item(i).getChildNodes();
            String realm = null;
            for (int j = 0; j < childs.getLength(); ++j) {
                Node node = childs.item(j);
                if (!REALM_NAME.equalsIgnoreCase(this.getLocalNodeName(node))) continue;
                realm = this.getTextNode(node);
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer b = new StringBuffer(64);
                    b.append("Login-config realm: ");
                    b.append(realm);
                    c_logger.traceDebug(this, "getLoginConfigFromXML", b.toString());
                }
                app.setRealm(realm);
            }
        }
    }

    private String getTextNode(Node node) {
        String rValue = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 3) continue;
            rValue = child.getNodeValue();
            break;
        }
        if (null != rValue) {
            rValue = rValue.trim();
        }
        return rValue;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource = null;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "resolveEntity", publicId + " " + systemId);
        }
        if (systemId.indexOf(DTD_DOC) > 0) {
            InputStream in = this.getClass().getResourceAsStream("/javax/servlet/sip/sip-app_1_0.dtd");
            if (null != in) {
                inputSource = new InputSource(in);
            } else if (c_logger.isErrorEnabled()) {
                c_logger.error("error.local.sip.dtd.not.found", "Create", null);
            }
        }
        return inputSource;
    }

    private String getLocalNodeName(Node n) {
        String name = null;
        if (n != null && (name = n.getNodeName()) != null && name.indexOf(58) > 0) {
            name = name.substring(name.indexOf(58) + 1);
        }
        return name;
    }
}

