/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.batchloader.SourceBatchLoaderHelper;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import org.dataloader.DataLoader;

public class BatchDataFetcher<T>
implements DataFetcher<T> {
    private final Operation operation;
    private final EventEmitter eventEmitter;
    private final ArgumentHelper argumentHelper;
    private final String batchLoaderName;

    public BatchDataFetcher(Operation operation, Config config) {
        this.operation = operation;
        this.eventEmitter = new EventEmitter(config);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.batchLoaderName = SourceBatchLoaderHelper.getName(operation);
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext.setDataFromFetcher(dfe, this.operation);
        this.eventEmitter.fireBeforeDataFetch();
        Object[] transformedArguments = this.argumentHelper.getArguments(dfe, true);
        Object source = dfe.getSource();
        DataLoader dataLoader = dfe.getDataLoader(this.batchLoaderName);
        return (T)dataLoader.load(source, (Object)transformedArguments);
    }
}

