/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.AssertionValidator;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import java.util.Date;
import java.util.List;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RsAssertionValidator
extends AssertionValidator {
    private static TraceComponent tc = Tr.register(RsAssertionValidator.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    protected SsoSamlService ssoSamlService = null;
    static final long serialVersionUID = -5162286195364471646L;

    public RsAssertionValidator(BasicMessageContext<?, ?, ?> context, Assertion assertion) {
        super(context, assertion);
        this.ssoSamlService = context.getSsoService();
    }

    @Override
    public void validateAssertion() throws SamlException {
        this.validateIssuer(true);
        this.validateSignature();
        this.verifySubject();
        this.verifyConditions();
        this.verifyAuthnStatement();
    }

    @Override
    protected void verifySubject() throws SamlException {
        Subject subject = this.assertion.getSubject();
        String method = null;
        for (SubjectConfirmation confirmation : subject.getSubjectConfirmations()) {
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(confirmation.getMethod())) {
                SubjectConfirmationData data;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject Confirmation:", (Object[])new Object[]{confirmation.getMethod()});
                }
                if ((data = confirmation.getSubjectConfirmationData()) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is no SubjectConfirmationData", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"SubjectConfirmationData"});
                }
                if (data.getNotBefore() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is a NotBefore", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_SUBJECT_NOTBEFORE_ERR", null, new Object[0]);
                }
                if (data.getNotOnOrAfter() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"NotOnOrAfter attribute is required inside SubjectConfirmationData element.", (Object[])new Object[0]);
                    }
                    throw new SamlException("SAML20_ELEMENT_ATTR_ERR", null, new Object[]{"NotOnOrAfter", "SubjectConfirmationData"});
                }
                if (data.getNotOnOrAfter().plus(this.clockSkewAllowed).isBeforeNow()) {
                    throw new SamlException("SAML20_SUBJECT_NOTONAFTER_ERR", null, new Object[]{data.getNotOnOrAfter(), new Date(), this.clockSkewAllowed / 1000L});
                }
                this.context.setSubjectNameIdentifier((SAMLObject)subject.getNameID());
                return;
            }
            method = confirmation.getMethod();
        }
        throw new SamlException("SAML20_NO_BEARER_FOUND", null, new Object[]{method});
    }

    @Override
    protected void verifyAudience(List<AudienceRestriction> audienceRestrictions) throws SamlException {
        boolean bAudienceOk = false;
        String[] audiences = this.ssoSamlService.getConfig().getAudiences();
        if (audiences == null || audiences.length == 0) {
            bAudienceOk = true;
        } else {
            for (String audience : audiences) {
                if (!audience.equals("ANY")) continue;
                bAudienceOk = true;
                break;
            }
        }
        if (bAudienceOk) {
            return;
        }
        SamlException lastException = null;
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            for (Audience aud : audienceRestriction.getAudiences()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Audience=" + aud.getAudienceURI()), (Object[])new Object[0]);
                }
                for (String audience : audiences) {
                    if (!audience.equals(aud.getAudienceURI())) continue;
                    return;
                }
                lastException = new SamlException("SAML20_AUDIENCE_UNKNOWN_ERR", null, new Object[]{aud.getAudienceURI(), audiences[0]});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Invalid audience", (Object[])new Object[0]);
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new SamlException("SAML20_ELEMENT_ATTR_ERR", null, new Object[]{"Audience", "Conditions"});
    }
}

