/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.CORBA;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Context;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.CodeConverterBase;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.TypeCodeFactory;
import org.apache.yoko.orb.OB.ValueWriter;
import org.apache.yoko.orb.OCI.AlignmentBoundary;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ReadBuffer;
import org.apache.yoko.orb.OCI.SimplyCloseable;
import org.apache.yoko.orb.OCI.WriteBuffer;
import org.apache.yoko.util.Timeout;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.ValueBaseHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public final class OutputStream
extends org.omg.CORBA_2_3.portable.OutputStream
implements ValueOutputStream {
    private static final Logger LOGGER = Logger.getLogger(OutputStream.class.getName());
    private ORBInstance orbInstance_;
    private final WriteBuffer writeBuffer;
    private GiopVersion giopVersion_ = GiopVersion.GIOP1_0;
    private final CodeConverters codeConverters_;
    private boolean charWriterRequired_;
    private boolean charConversionRequired_;
    private boolean wCharWriterRequired_;
    private boolean wCharConversionRequired_;
    private ValueWriter valueWriter_;
    private boolean atEndOfGiop_1_2_Header = false;
    private java.lang.Object invocationContext_;
    private java.lang.Object delegateContext_;
    private Timeout timeout = Timeout.NEVER;

    private SimplyCloseable recordLength() {
        this.addCapacity(4, AlignmentBoundary.FOUR_BYTE_BOUNDARY);
        return this.writeBuffer.recordLength(LOGGER);
    }

    private void writeTypeCodeImpl(org.omg.CORBA.TypeCode tc, Map<org.omg.CORBA.TypeCode, Integer> history) {
        TypeCode obTC = null;
        try {
            obTC = (TypeCode)tc;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (obTC != null && obTC.recId_ != null) {
            if (obTC.recType_ == null) {
                throw new BAD_TYPECODE(MinorCodes.describeBadTypecode(1330446337), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            this.writeTypeCodeImpl(obTC.recType_, history);
            return;
        }
        LOGGER.finest("Writing a type code of type " + tc.kind().value());
        switch (tc.kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.write_ulong(tc.kind().value());
                return;
            }
        }
        Integer indirectionPos = history.get(tc);
        if (indirectionPos != null) {
            this.write_long(-1);
            int offs = indirectionPos - this.writeBuffer.getPosition();
            LOGGER.finest("Writing an indirect type code for offset " + offs);
            this.write_long(offs);
        } else {
            this.write_ulong(tc.kind().value());
            Integer oldPos = this.writeBuffer.getPosition() - 4;
            try {
                switch (tc.kind().value()) {
                    case 28: {
                        history.put(tc, oldPos);
                        this.write_ushort(tc.fixed_digits());
                        this.write_short(tc.fixed_scale());
                        break;
                    }
                    case 14: 
                    case 31: 
                    case 32: 
                    case 33: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            break;
                        }
                    }
                    case 15: 
                    case 22: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            this.write_ulong(tc.member_count());
                            for (int i = 0; i < tc.member_count(); ++i) {
                                this.write_string(tc.member_name(i));
                                this.writeTypeCodeImpl(tc.member_type(i), history);
                            }
                            break;
                        }
                    }
                    case 16: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            org.omg.CORBA.TypeCode discType = tc.discriminator_type();
                            this.writeTypeCodeImpl(discType, history);
                            int defaultIndex = tc.default_index();
                            this.write_long(defaultIndex);
                            this.write_ulong(tc.member_count());
                            for (int i = 0; i < tc.member_count(); ++i) {
                                if (i == defaultIndex) {
                                    org.omg.CORBA.TypeCode origDiscType = TypeCode._OB_getOrigType(discType);
                                    switch (origDiscType.kind().value()) {
                                        case 2: {
                                            this.write_short((short)0);
                                            break;
                                        }
                                        case 4: {
                                            this.write_ushort((short)0);
                                            break;
                                        }
                                        case 3: {
                                            this.write_long(0);
                                            break;
                                        }
                                        case 5: 
                                        case 17: {
                                            this.write_ulong(0);
                                            break;
                                        }
                                        case 23: {
                                            this.write_longlong(0L);
                                            break;
                                        }
                                        case 24: {
                                            this.write_ulonglong(0L);
                                            break;
                                        }
                                        case 8: {
                                            this.write_boolean(false);
                                            break;
                                        }
                                        case 9: {
                                            this.write_char('\u0000');
                                            break;
                                        }
                                        default: {
                                            throw Assert.fail("Invalid sub-type in tk_union");
                                        }
                                    }
                                } else {
                                    tc.member_label(i).write_value((org.omg.CORBA.portable.OutputStream)this);
                                }
                                this.write_string(tc.member_name(i));
                                this.writeTypeCodeImpl(tc.member_type(i), history);
                            }
                            break;
                        }
                    }
                    case 17: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            this.write_ulong(tc.member_count());
                            for (int i = 0; i < tc.member_count(); ++i) {
                                this.write_string(tc.member_name(i));
                            }
                            break;
                        }
                    }
                    case 18: 
                    case 27: {
                        this.write_ulong(tc.length());
                        break;
                    }
                    case 19: 
                    case 20: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.writeTypeCodeImpl(tc.content_type(), history);
                            this.write_ulong(tc.length());
                            break;
                        }
                    }
                    case 21: 
                    case 30: {
                        history.put(tc, oldPos);
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            this.writeTypeCodeImpl(tc.content_type(), history);
                            break;
                        }
                    }
                    case 29: {
                        history.put(tc, oldPos);
                        org.omg.CORBA.TypeCode concreteBase = tc.concrete_base_type();
                        if (concreteBase == null) {
                            concreteBase = TypeCodeFactory.createPrimitiveTC(TCKind.tk_null);
                        }
                        try (SimplyCloseable sc = this.recordLength();){
                            this._OB_writeEndian();
                            this.write_string(tc.id());
                            this.write_string(tc.name());
                            this.write_short(tc.type_modifier());
                            this.writeTypeCodeImpl(concreteBase, history);
                            this.write_ulong(tc.member_count());
                            for (int i = 0; i < tc.member_count(); ++i) {
                                this.write_string(tc.member_name(i));
                                this.writeTypeCodeImpl(tc.member_type(i), history);
                                this.write_short(tc.member_visibility(i));
                            }
                            break;
                        }
                    }
                    default: {
                        throw Assert.fail("Invalid typecode");
                    }
                }
            }
            catch (BadKind | Bounds ex) {
                throw Assert.fail(ex);
            }
        }
    }

    private void checkBeginChunk() {
        Assert.ensure(this.valueWriter_ != null);
        this.valueWriter_.checkBeginChunk();
    }

    private ValueWriter valueWriter() {
        if (this.valueWriter_ == null) {
            this.valueWriter_ = new ValueWriter(this, this.writeBuffer);
        }
        return this.valueWriter_;
    }

    private void addCapacity(int size) {
        if (this.atEndOfGiop_1_2_Header) {
            this.atEndOfGiop_1_2_Header = false;
            this.addCapacity(size, AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        } else {
            boolean resized;
            if (this.writeBuffer.isComplete() && this.valueWriter_ != null) {
                this.checkBeginChunk();
            }
            if (resized = this.writeBuffer.ensureAvailable(size)) {
                this.checkTimeout();
            }
        }
    }

    private void checkTimeout() {
        if (this.timeout.isExpired()) {
            this.timeout = Timeout.NEVER;
            throw new TIMEOUT("Reply timed out on server", 1330446346, CompletionStatus.COMPLETED_YES);
        }
    }

    private void addCapacity(int size, AlignmentBoundary boundary) {
        boolean resized;
        Assert.ensure(boundary != AlignmentBoundary.NO_BOUNDARY);
        if (this.writeBuffer.isComplete() && this.valueWriter_ != null) {
            this.checkBeginChunk();
        }
        if (this.atEndOfGiop_1_2_Header) {
            boundary = AlignmentBoundary.EIGHT_BYTE_BOUNDARY;
            this.atEndOfGiop_1_2_Header = false;
        }
        if (resized = this.writeBuffer.ensureAvailable(size, boundary)) {
            this.checkTimeout();
        }
    }

    public void write(int b) {
        this.write_long(b);
    }

    public ORB orb() {
        return this.orbInstance_ == null ? null : this.orbInstance_.getORB();
    }

    public InputStream create_input_stream() {
        InputStream in = new InputStream(this.getBufferReader(), false, this.codeConverters_, this.giopVersion_);
        in._OB_ORBInstance(this.orbInstance_);
        return in;
    }

    public void write_boolean(boolean value) {
        this.addCapacity(1);
        this.writeBuffer.writeByte(value ? 1 : 0);
    }

    public void write_char(char value) {
        if (value > '\u00ff') {
            throw new DATA_CONVERSION("char value exceeds 255: " + value);
        }
        this.addCapacity(1);
        CodeConverterBase converter = this.codeConverters_.outputCharConverter;
        if (this.charConversionRequired_) {
            value = converter.convert(value);
        }
        if (this.charWriterRequired_) {
            converter.write_char(this.writeBuffer, value);
        } else {
            this.writeBuffer.writeByte(value);
        }
    }

    public void write_wchar(char value) {
        this.write_wchar(value, false);
    }

    private void write_wchar(char value, boolean partOfString) {
        CodeConverterBase converter = this.codeConverters_.outputWcharConverter;
        if (this.wCharConversionRequired_) {
            value = converter.convert(value);
        }
        if (this.wCharWriterRequired_) {
            if (!partOfString) {
                converter.set_writer_flags(22);
            }
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    throw Assert.fail();
                }
                case GIOP1_1: {
                    int len = converter.write_count_wchar(value);
                    Assert.ensure(len == 2);
                    this.addCapacity(2, AlignmentBoundary.TWO_BYTE_BOUNDARY);
                    converter.write_wchar(this.writeBuffer, value);
                    break;
                }
                default: {
                    int len = converter.write_count_wchar(value);
                    this.write_octet((byte)len);
                    this.addCapacity(len);
                    converter.write_wchar(this.writeBuffer, value);
                    break;
                }
            }
        } else {
            switch (this.giopVersion_) {
                case GIOP1_0: {
                    this.addCapacity(2, AlignmentBoundary.TWO_BYTE_BOUNDARY);
                    this.writeBuffer.writeChar(value);
                    break;
                }
                case GIOP1_1: {
                    this.write_ushort((short)value);
                    break;
                }
                default: {
                    this.addCapacity(3);
                    this.writeBuffer.writeByte(2);
                    this.writeBuffer.writeChar(value);
                }
            }
        }
    }

    public void write_octet(byte value) {
        this.addCapacity(1);
        this.writeBuffer.writeByte(value);
    }

    public void write_short(short value) {
        this.addCapacity(2, AlignmentBoundary.TWO_BYTE_BOUNDARY);
        this.writeBuffer.writeShort(value);
    }

    public void write_ushort(short value) {
        this.write_short(value);
    }

    public void write_long(int value) {
        this.addCapacity(4, AlignmentBoundary.FOUR_BYTE_BOUNDARY);
        this.writeBuffer.writeInt(value);
    }

    public void write_ulong(int value) {
        this.write_long(value);
    }

    public void write_longlong(long value) {
        this.addCapacity(8, AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
        this.writeBuffer.writeLong(value);
    }

    public void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public void write_string(String value) {
        LOGGER.finest("Writing string value " + value);
        char[] arr = value.toCharArray();
        CodeConverterBase converter = this.codeConverters_.outputCharConverter;
        if (!this.charWriterRequired_) {
            int len = arr.length;
            int capacity = len + 1;
            this.write_ulong(capacity);
            this.addCapacity(capacity);
            if (this.charConversionRequired_) {
                for (char c : arr) {
                    this.writeBuffer.writeByte(converter.convert(OutputStream.checkChar(c)));
                }
            } else {
                for (char c : arr) {
                    this.writeBuffer.writeByte(OutputStream.checkChar(c));
                }
            }
            this.writeBuffer.writeByte(0);
        } else {
            WriteBuffer tmpWriter = Buffer.createWriteBuffer(4 + value.length() * 4 + 1);
            if (this.charConversionRequired_) {
                for (char c : arr) {
                    converter.write_char(tmpWriter, converter.convert(OutputStream.checkChar(c)));
                }
            } else {
                for (char c : arr) {
                    converter.write_char(tmpWriter, OutputStream.checkChar(c));
                }
            }
            tmpWriter.writeByte(0);
            tmpWriter.trim();
            this.write_ulong(tmpWriter.length());
            this.addCapacity(tmpWriter.length());
            tmpWriter.readFromStart().readBytes(this.writeBuffer);
        }
    }

    private static char checkChar(char c) {
        if (c > '\u00ff') {
            throw new DATA_CONVERSION(String.format("illegal char value for string: 0x%04x", c));
        }
        return c;
    }

    public void write_wstring(String value) {
        char[] arr = value.toCharArray();
        int len = arr.length;
        LOGGER.finest("Writing wstring value " + value);
        CodeConverterBase converter = this.codeConverters_.outputWcharConverter;
        if (this.wCharWriterRequired_) {
            converter.set_writer_flags(22);
        }
        switch (this.giopVersion_) {
            case GIOP1_0: 
            case GIOP1_1: {
                this.write_ulong(len + 1);
                for (char anArr : arr) {
                    this.write_wchar(anArr, true);
                }
                this.write_wchar('\u0000', true);
                return;
            }
        }
        try (SimplyCloseable sc = this.recordLength();){
            if (this.wCharWriterRequired_) {
                char[] cArray = arr;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char anArr;
                    char v = anArr = cArray[i];
                    if (this.wCharConversionRequired_) {
                        v = converter.convert(v);
                    }
                    this.addCapacity(converter.write_count_wchar(v));
                    converter.write_wchar(this.writeBuffer, v);
                }
            } else {
                this.addCapacity(len << 1);
                char[] cArray = arr;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char anArr;
                    char v = anArr = cArray[i];
                    if (this.wCharConversionRequired_) {
                        v = converter.convert(v);
                    }
                    this.writeBuffer.writeChar(v);
                }
            }
        }
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length);
            for (int i = offset; i < offset + length; ++i) {
                this.writeBuffer.writeByte(value[i] ? 1 : 0);
            }
        }
    }

    public void write_char_array(char[] value, int offset, int length) {
        block8: {
            if (length <= 0) break block8;
            this.addCapacity(length);
            if (!this.charWriterRequired_ && !this.charConversionRequired_) {
                for (int i = offset; i < offset + length; ++i) {
                    if (value[i] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + value[i]);
                    }
                    this.writeBuffer.writeByte(value[i]);
                }
            } else {
                CodeConverterBase converter = this.codeConverters_.outputCharConverter;
                boolean bothRequired = this.charWriterRequired_ && this.charConversionRequired_;
                for (int i = offset; i < offset + length; ++i) {
                    if (value[i] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + value[i]);
                    }
                    if (bothRequired) {
                        converter.write_char(this.writeBuffer, converter.convert(value[i]));
                        continue;
                    }
                    if (this.charWriterRequired_) {
                        converter.write_char(this.writeBuffer, value[i]);
                        continue;
                    }
                    this.writeBuffer.writeByte(converter.convert(value[i]));
                }
            }
        }
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.write_wchar(value[i], false);
        }
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        if (length <= 0) {
            return;
        }
        this.addCapacity(length);
        this.writeBuffer.writeBytes(value, offset, length);
    }

    public void write_short_array(short[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 2, AlignmentBoundary.TWO_BYTE_BOUNDARY);
            for (int i = offset; i < offset + length; ++i) {
                this.writeBuffer.writeShort(value[i]);
            }
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    public void write_long_array(int[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 4, AlignmentBoundary.FOUR_BYTE_BOUNDARY);
            for (int i = offset; i < offset + length; ++i) {
                this.writeBuffer.writeInt(value[i]);
            }
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 8, AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
            for (int i = offset; i < offset + length; ++i) {
                this.writeBuffer.writeLong(value[i]);
            }
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    public void write_float_array(float[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 4, AlignmentBoundary.FOUR_BYTE_BOUNDARY);
            for (int i = offset; i < offset + length; ++i) {
                int v = Float.floatToIntBits(value[i]);
                this.writeBuffer.writeInt(v);
            }
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        if (length > 0) {
            this.addCapacity(length * 8, AlignmentBoundary.EIGHT_BYTE_BOUNDARY);
            for (int i = offset; i < offset + length; ++i) {
                long v = Double.doubleToLongBits(value[i]);
                this.writeBuffer.writeLong(v);
            }
        }
    }

    public void write_Object(Object value) {
        if (value == null) {
            LOGGER.finest("Writing a null CORBA object value");
            IOR ior = new IOR();
            ior.type_id = "";
            ior.profiles = new TaggedProfile[0];
            IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)ior);
        } else {
            if (value instanceof LocalObject) {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
            }
            Delegate p = (Delegate)((ObjectImpl)value)._get_delegate();
            p._OB_marshalOrigIOR((org.omg.CORBA.portable.OutputStream)this);
        }
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode t) {
        if (t == null) {
            throw new BAD_TYPECODE("TypeCode is nil");
        }
        this.writeTypeCodeImpl(t, new HashMap<org.omg.CORBA.TypeCode, Integer>());
    }

    public void write_any(Any value) {
        LOGGER.finest("Writing an ANY value of type " + value.type().kind());
        this.write_TypeCode(value.type());
        value.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_Context(org.omg.CORBA.Context ctx, ContextList contexts) {
        int count = contexts.count();
        Vector v = new Vector();
        Context ctxImpl = (Context)ctx;
        for (int i = 0; i < count; ++i) {
            try {
                String pattern = contexts.item(i);
                ctxImpl._OB_getValues("", 0, pattern, v);
                continue;
            }
            catch (org.omg.CORBA.Bounds ex) {
                throw Assert.fail(ex);
            }
        }
        this.write_ulong(v.size());
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.write_string((String)e.nextElement());
        }
    }

    public void write_Principal(Principal value) {
        throw new NO_IMPLEMENT();
    }

    public void write_fixed(BigDecimal value) {
        String v = value.abs().toString();
        if (((v = v + OutputStream.getSignChar(value)).length() & 1) != 0) {
            v = "0" + v;
        }
        for (int i = 0; i < v.length(); i += 2) {
            char c1 = v.charAt(i);
            char c2 = v.charAt(i + 1);
            this.write_octet((byte)(c1 - 48 << 4 | c2 - 48));
        }
    }

    private static int getSignChar(BigDecimal value) {
        return 48 + (char)(value.signum() == -1 ? 13 : 12);
    }

    public void write_value(Serializable value) {
        this.checkTimeout();
        this.valueWriter().writeValue(value, null);
        this.checkTimeout();
    }

    public void write_value(Serializable value, String rep_id) {
        this.checkTimeout();
        this.valueWriter().writeValue(value, rep_id);
        this.checkTimeout();
    }

    public void write_value(Serializable value, Class clz) {
        this.checkTimeout();
        this.valueWriter().writeValue(value, null);
        this.checkTimeout();
    }

    public void write_value(Serializable value, BoxedValueHelper helper) {
        this.checkTimeout();
        this.valueWriter().writeValueBox(value, null, helper);
        this.checkTimeout();
    }

    public void write_abstract_interface(java.lang.Object obj) {
        this.checkTimeout();
        this.valueWriter().writeAbstractInterface(obj);
        this.checkTimeout();
    }

    public void write_value(Serializable value, org.omg.CORBA.TypeCode tc, BoxedValueHelper helper) {
        this.checkTimeout();
        this.valueWriter().writeValueBox(value, tc, helper);
        this.checkTimeout();
    }

    public void write_InputStream(org.omg.CORBA.portable.InputStream in, org.omg.CORBA.TypeCode tc) {
        try {
            LOGGER.fine("writing a value of type " + tc.kind().value());
            switch (tc.kind().value()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    this.write_short(in.read_short());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 17: {
                    this.write_long(in.read_long());
                    break;
                }
                case 7: 
                case 23: 
                case 24: {
                    this.write_longlong(in.read_longlong());
                    break;
                }
                case 8: 
                case 10: {
                    this.write_octet(in.read_octet());
                    break;
                }
                case 9: {
                    this.write_char(in.read_char());
                    break;
                }
                case 26: {
                    this.write_wchar(in.read_wchar());
                    break;
                }
                case 28: {
                    this.write_fixed(in.read_fixed());
                    break;
                }
                case 11: {
                    this.copyAnyFrom(in);
                    break;
                }
                case 12: {
                    this.copyTypeCodeFrom(in);
                    break;
                }
                case 13: {
                    this.write_Principal(in.read_Principal());
                    break;
                }
                case 14: {
                    this.copyObjRefFrom(in);
                    break;
                }
                case 15: {
                    for (int i = 0; i < tc.member_count(); ++i) {
                        this.write_InputStream(in, tc.member_type(i));
                    }
                    break;
                }
                case 22: {
                    this.write_string(in.read_string());
                    for (int i = 0; i < tc.member_count(); ++i) {
                        this.write_InputStream(in, tc.member_type(i));
                    }
                    break;
                }
                case 16: {
                    this.copyUnionFrom(in, tc);
                    break;
                }
                case 18: {
                    this.write_string(in.read_string());
                    break;
                }
                case 27: {
                    this.write_wstring(in.read_wstring());
                    break;
                }
                case 19: 
                case 20: {
                    this.copyArrayFrom(in, tc);
                    break;
                }
                case 21: {
                    this.write_InputStream(in, tc.content_type());
                    break;
                }
                case 29: 
                case 30: {
                    this.copyValueFrom((org.omg.CORBA_2_3.portable.InputStream)in, tc);
                    break;
                }
                case 32: {
                    this.copyAbstractInterfaceFrom(in);
                    break;
                }
                default: {
                    throw Assert.fail("unsupported types");
                }
            }
        }
        catch (BadKind | Bounds ex) {
            throw Assert.fail(ex);
        }
    }

    private void copyObjRefFrom(org.omg.CORBA.portable.InputStream in) {
        IOR ior = IORHelper.read((org.omg.CORBA.portable.InputStream)in);
        IORHelper.write((org.omg.CORBA.portable.OutputStream)this, (IOR)ior);
    }

    private void copyAnyFrom(org.omg.CORBA.portable.InputStream in) {
        org.omg.CORBA.TypeCode p = in.read_TypeCode();
        this.write_TypeCode(p);
        this.write_InputStream(in, p);
    }

    private void copyValueFrom(org.omg.CORBA_2_3.portable.InputStream in, org.omg.CORBA.TypeCode tc) {
        if (in instanceof InputStream) {
            ((InputStream)in)._OB_remarshalValue(tc, this);
        } else {
            this.write_value(in.read_value());
        }
    }

    private void copyAbstractInterfaceFrom(org.omg.CORBA.portable.InputStream in) {
        boolean b = in.read_boolean();
        this.write_boolean(b);
        if (b) {
            this.write_Object(in.read_Object());
        } else if (in instanceof InputStream) {
            ((InputStream)in)._OB_remarshalValue(ValueBaseHelper.type(), this);
        } else {
            this.write_value(((org.omg.CORBA_2_3.portable.InputStream)in).read_value());
        }
    }

    private void copyArrayFrom(org.omg.CORBA.portable.InputStream in, org.omg.CORBA.TypeCode tc) throws BadKind {
        int len;
        boolean swapInput;
        boolean bl = swapInput = in instanceof InputStream && ((InputStream)in).swap_;
        if (tc.kind().value() == 19) {
            len = in.read_ulong();
            this.write_ulong(len);
        } else {
            len = tc.length();
        }
        if (len <= 0) {
            return;
        }
        org.omg.CORBA.TypeCode origContentType = TypeCode._OB_getOrigType(tc.content_type());
        switch (origContentType.kind().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                this.copyShortArrayFrom(in, len, swapInput);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                this.copyIntArrayFrom(in, len, swapInput);
                break;
            }
            case 7: 
            case 23: 
            case 24: {
                this.copyLongArrayFrom(in, len, swapInput);
                break;
            }
            case 8: 
            case 10: {
                this.readFrom(in, len);
                break;
            }
            case 9: {
                if (this.charWriterRequired_ || this.charConversionRequired_) {
                    char[] ch = new char[len];
                    in.read_char_array(ch, 0, len);
                    this.write_char_array(ch, 0, len);
                    break;
                }
                this.readFrom(in, len);
                break;
            }
            case 26: {
                char[] wch = new char[len];
                in.read_wchar_array(wch, 0, len);
                this.write_wchar_array(wch, 0, len);
                break;
            }
            case 21: {
                throw Assert.fail("tk_alias not supported in tk_array or tk_sequence");
            }
            default: {
                for (int i = 0; i < len; ++i) {
                    this.write_InputStream(in, tc.content_type());
                }
            }
        }
    }

    private void copyLongArrayFrom(org.omg.CORBA.portable.InputStream in, int num, boolean swapInput) {
        if (swapInput) {
            long[] l = new long[num];
            in.read_longlong_array(l, 0, num);
            this.write_longlong_array(l, 0, num);
        } else {
            this.write_longlong(in.read_longlong());
            int n = 8 * (num - 1);
            if (n > 0) {
                this.readFrom(in, n);
            }
        }
    }

    private void copyIntArrayFrom(org.omg.CORBA.portable.InputStream in, int num, boolean swapInput) {
        if (swapInput) {
            int[] i = new int[num];
            in.read_long_array(i, 0, num);
            this.write_long_array(i, 0, num);
        } else {
            this.write_long(in.read_long());
            int n = 4 * (num - 1);
            if (n > 0) {
                this.readFrom(in, n);
            }
        }
    }

    private void copyShortArrayFrom(org.omg.CORBA.portable.InputStream in, int num, boolean swapInput) {
        if (swapInput) {
            short[] s = new short[num];
            in.read_short_array(s, 0, num);
            this.write_short_array(s, 0, num);
        } else {
            this.write_short(in.read_short());
            int n = 2 * (num - 1);
            if (n > 0) {
                this.readFrom(in, n);
            }
        }
    }

    private void copyUnionFrom(org.omg.CORBA.portable.InputStream in, org.omg.CORBA.TypeCode tc) throws BadKind, Bounds {
        int defaultIndex = tc.default_index();
        int memberIndex = -1;
        org.omg.CORBA.TypeCode origDiscType = TypeCode._OB_getOrigType(tc.discriminator_type());
        block0 : switch (origDiscType.kind().value()) {
            case 2: {
                short val = in.read_short();
                this.write_short(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_short()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 4: {
                short val = in.read_ushort();
                this.write_ushort(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_ushort()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 3: {
                int val = in.read_long();
                this.write_long(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_long()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 5: {
                int val = in.read_ulong();
                this.write_ulong(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_ulong()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 23: {
                long val = in.read_longlong();
                this.write_longlong(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_longlong()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 24: {
                long val = in.read_ulonglong();
                this.write_ulonglong(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_ulonglong()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 9: {
                char val = in.read_char();
                this.write_char(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_char()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 8: {
                boolean val = in.read_boolean();
                this.write_boolean(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).extract_boolean()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            case 17: {
                int val = in.read_long();
                this.write_long(val);
                for (int i = 0; i < tc.member_count(); ++i) {
                    if (i == defaultIndex || val != tc.member_label(i).create_input_stream().read_long()) continue;
                    memberIndex = i;
                    break block0;
                }
                break;
            }
            default: {
                throw Assert.fail("Invalid typecode in tk_union");
            }
        }
        if (memberIndex >= 0) {
            this.write_InputStream(in, tc.member_type(memberIndex));
        } else if (defaultIndex >= 0) {
            this.write_InputStream(in, tc.member_type(defaultIndex));
        }
    }

    private void copyTypeCodeFrom(org.omg.CORBA.portable.InputStream in) {
        int kind = in.read_ulong();
        if (kind == -1) {
            throw new MARSHAL(MinorCodes.describeMarshal(1095974950), 1095974950, CompletionStatus.COMPLETED_NO);
        }
        this.write_ulong(kind);
        switch (kind) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 28: {
                this.write_ushort(in.read_ushort());
                this.write_short(in.read_short());
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                int len = in.read_ulong();
                this.write_ulong(len);
                this.readFrom(in, len);
                break;
            }
            case 18: 
            case 27: {
                int bound = in.read_ulong();
                this.write_ulong(bound);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private void readFrom(org.omg.CORBA.portable.InputStream in, int length) {
        this.addCapacity(length);
        this.writeBuffer.readFrom(in);
    }

    public OutputStream() {
        this(Buffer.createWriteBuffer(), null, null);
    }

    public OutputStream(int initialBufferSize) {
        this(Buffer.createWriteBuffer(initialBufferSize), null, null);
    }

    public OutputStream(CodeConverters converters, GiopVersion giopVersion) {
        this(Buffer.createWriteBuffer(), converters, giopVersion);
    }

    public OutputStream(int initialBufferSize, CodeConverters converters, GiopVersion giopVersion) {
        this(Buffer.createWriteBuffer(initialBufferSize), converters, giopVersion);
    }

    public OutputStream(WriteBuffer writeBuffer) {
        this(writeBuffer, null, null);
    }

    public OutputStream(WriteBuffer writeBuffer, CodeConverters converters, GiopVersion giopVersion) {
        this.writeBuffer = writeBuffer;
        if (giopVersion != null) {
            this.giopVersion_ = giopVersion;
        }
        this.charWriterRequired_ = false;
        this.charConversionRequired_ = false;
        this.wCharWriterRequired_ = false;
        this.wCharConversionRequired_ = false;
        this.codeConverters_ = CodeConverters.createCopy(converters);
        if (converters != null) {
            if (this.codeConverters_.outputCharConverter != null) {
                this.charWriterRequired_ = this.codeConverters_.outputCharConverter.writerRequired();
                this.charConversionRequired_ = this.codeConverters_.outputCharConverter.conversionRequired();
            }
            if (this.codeConverters_.outputWcharConverter != null) {
                this.wCharWriterRequired_ = this.codeConverters_.outputWcharConverter.writerRequired();
                this.wCharConversionRequired_ = this.codeConverters_.outputWcharConverter.conversionRequired();
            }
        }
    }

    public void close() {
    }

    boolean writtenBytesEqual(OutputStream that) {
        return this.writeBuffer.dataEquals(this.writeBuffer);
    }

    public byte[] copyWrittenBytes() {
        return this.writeBuffer.trim().readFromStart().copyRemainingBytes();
    }

    public String writtenBytesToAscii() {
        return this.writeBuffer.trim().readFromStart().remainingBytesToAscii();
    }

    public ReadBuffer getBufferReader() {
        return this.writeBuffer.readFromStart();
    }

    public int getPosition() {
        return this.writeBuffer.getPosition();
    }

    public void setPosition(int pos) {
        this.writeBuffer.setPosition(pos);
    }

    public void markGiop_1_2_HeaderComplete() {
        this.atEndOfGiop_1_2_Header = true;
    }

    public void _OB_writeEndian() {
        this.write_boolean(false);
    }

    public void _OB_beginValue(int tag, String[] ids, boolean chunked) {
        this.valueWriter().beginValue(tag, ids, null, chunked);
    }

    public void _OB_endValue() {
        this.valueWriter().endValue();
    }

    public void _OB_ORBInstance(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
    }

    public void _OB_invocationContext(java.lang.Object invocationContext) {
        this.invocationContext_ = invocationContext;
    }

    public java.lang.Object _OB_invocationContext() {
        return this.invocationContext_;
    }

    void _OB_delegateContext(java.lang.Object delegateContext) {
        this.delegateContext_ = delegateContext;
    }

    java.lang.Object _OB_delegateContext() {
        return this.delegateContext_;
    }

    public void end_value() {
        this._OB_endValue();
    }

    public void start_value(String rep_id) {
        int tag = 2147483394;
        String[] ids = new String[]{rep_id};
        this._OB_beginValue(2147483394, ids, true);
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }
}

