/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import io.openliberty.microprofile.openapi20.ConfigProcessor;
import io.openliberty.microprofile.openapi20.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.StaticFileProcessor;
import io.openliberty.microprofile.openapi20.WebModuleOpenAPIProvider;
import io.openliberty.microprofile.openapi20.cache.CacheEntry;
import io.openliberty.microprofile.openapi20.utils.IndexUtils;
import io.openliberty.microprofile.openapi20.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.utils.ModuleUtils;
import io.openliberty.microprofile.openapi20.utils.OpenAPIUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationProcessor {
    private static final TraceComponent tc = Tr.register(ApplicationProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -8976340782906232111L;

    @FFDCIgnore(value={UnableToAdaptException.class})
    public static OpenAPIProvider processApplication(ApplicationInfo appInfo) {
        OpenAPIProvider openAPIProvider;
        block14: {
            openAPIProvider = null;
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application started: appInfo=" + appInfo), (Object[])new Object[0]);
            }
            if (appInfo != null) {
                Container appContainer = appInfo.getContainer();
                if (appContainer != null) {
                    try {
                        NonPersistentCache cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
                        ApplicationClassesContainerInfo applicationClassesContainerInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
                        if (applicationClassesContainerInfo != null) {
                            for (ModuleClassesContainerInfo moduleClassesContainerInfo : applicationClassesContainerInfo.getModuleClassesContainerInfo()) {
                                WebModuleInfo webModuleInfo;
                                ContainerInfo containerInfo = (ContainerInfo)moduleClassesContainerInfo;
                                if (containerInfo.getType() != ContainerInfo.Type.WEB_MODULE || (webModuleInfo = ModuleUtils.getWebModuleInfo(containerInfo.getContainer())) == null || (openAPIProvider = ApplicationProcessor.processWebModule(containerInfo.getContainer(), webModuleInfo, moduleClassesContainerInfo)) == null) continue;
                                Tr.info((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSED", (Object[])new Object[]{webModuleInfo.getApplicationInfo().getDeploymentName()});
                                break;
                            }
                            if (LoggingUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo), (Object[])new Object[0]);
                            }
                        } else if (LoggingUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo + ", applicationClassesContainerInfo=null"), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                    catch (UnableToAdaptException e) {
                        if (LoggingUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)("Failed to adapt NonPersistentCache: container=" + appContainer + " : \n" + e.getMessage()), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                }
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo + ", appContainer=null"), (Object[])new Object[0]);
                }
            } else if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Application Processor: Processing application ended: appInfo=null", (Object[])new Object[0]);
            }
        }
        return openAPIProvider;
    }

    /*
     * WARNING - void declaration
     */
    private static OpenAPIProvider processWebModule(Container appContainer, WebModuleInfo moduleInfo, ModuleClassesContainerInfo moduleClassesContainerInfo) {
        WebModuleOpenAPIProvider openAPIProvider = null;
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("WebModule: Processing started : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
        }
        ClassLoader appClassloader = moduleInfo.getClassLoader();
        OpenAPI openAPIModel = null;
        try {
            ConfigProcessor configProcessor = new ConfigProcessor(appClassloader);
            try {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Retrieved configuration values : " + configProcessor), (Object[])new Object[0]);
                }
                CacheEntry newCacheEntry = null;
                OpenApiConfig config = configProcessor.getOpenAPIConfig();
                String modulePathString = appContainer.getPhysicalPath();
                Path modulePath = modulePathString == null ? null : Paths.get(modulePathString, new String[0]);
                Path cacheDir = ApplicationProcessor.getCacheDir();
                if (modulePath != null && ApplicationProcessor.isWar(modulePath) && cacheDir != null) {
                    newCacheEntry = CacheEntry.createNew(moduleInfo.getApplicationInfo().getDeploymentName(), cacheDir);
                    newCacheEntry.setConfig(config);
                    newCacheEntry.addDependentFile(modulePath);
                    CacheEntry loadedCacheEntry = CacheEntry.read(moduleInfo.getApplicationInfo().getDeploymentName(), cacheDir);
                    if (loadedCacheEntry != null && loadedCacheEntry.isUpToDateWith(newCacheEntry)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using OpenAPI model loaded from cache", (Object[])new Object[0]);
                        }
                        openAPIModel = loadedCacheEntry.getModel();
                    }
                }
                if (openAPIModel == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Generating OpenAPI model", (Object[])new Object[0]);
                    }
                    if ((openAPIModel = ApplicationProcessor.generateModel(config, appContainer, moduleInfo, moduleClassesContainerInfo, appClassloader)) != null && newCacheEntry != null) {
                        newCacheEntry.setModel(openAPIModel);
                        newCacheEntry.write();
                    }
                }
                if (openAPIModel != null) {
                    if (openAPIModel.getInfo() == null) {
                        openAPIModel.setInfo(new InfoImpl().title("Generated API").version("1.0"));
                    }
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Generated document: " + OpenAPIUtils.getOpenAPIDocument(openAPIModel, Format.JSON)), (Object[])new Object[0]);
                    }
                    openAPIProvider = new WebModuleOpenAPIProvider(moduleInfo, openAPIModel, OpenAPIUtils.containsServersDefinition(openAPIModel));
                    if (configProcessor.isValidating()) {
                        try {
                            if (LoggingUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Validate document", (Object[])new Object[0]);
                            }
                            OpenAPIUtils.validateDocument(openAPIModel);
                        }
                        catch (Throwable loadedCacheEntry) {
                            FFDCFilter.processException((Throwable)loadedCacheEntry, (String)"io.openliberty.microprofile.openapi20.ApplicationProcessor", (String)"215", null, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                            if (LoggingUtils.isEventEnabled(tc)) {
                                void e;
                                Tr.event((TraceComponent)tc, (String)("Failed to call OASValidator: " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    }
                } else if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : Not an OAS application : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
                }
                configProcessor.close();
            }
            catch (Throwable newCacheEntry) {
                FFDCFilter.processException((Throwable)newCacheEntry, (String)"io.openliberty.microprofile.openapi20.ApplicationProcessor", (String)"157", null, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                try {
                    configProcessor.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.ApplicationProcessor", (String)"157", null, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                    newCacheEntry.addSuppressed(throwable);
                }
                throw newCacheEntry;
            }
        }
        catch (Exception configProcessor) {
            void e;
            FFDCFilter.processException((Throwable)configProcessor, (String)"io.openliberty.microprofile.openapi20.ApplicationProcessor", (String)"227", null, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
            if (LoggingUtils.isEventEnabled(tc)) {
                String message = String.format("Failed to process application %s: %s", moduleInfo.getApplicationInfo().getDeploymentName(), e.getMessage());
                Tr.event((TraceComponent)tc, (String)("Failed to process application: " + message), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSING_ERROR", (Object[])new Object[]{moduleInfo.getApplicationInfo().getDeploymentName(), e.toString()});
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
        }
        return openAPIProvider;
    }

    private static OpenAPI generateModel(OpenApiConfig config, Container appContainer, WebModuleInfo moduleInfo, ModuleClassesContainerInfo moduleClassesContainerInfo, ClassLoader appClassloader) {
        OpenApiDocument.INSTANCE.reset();
        OpenApiDocument.INSTANCE.config(config);
        OpenApiStaticFile staticFile = StaticFileProcessor.getOpenAPIFile(appContainer);
        OpenApiDocument.INSTANCE.modelFromStaticFile(OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
        OpenApiDocument.INSTANCE.modelFromAnnotations(OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (IndexView)IndexUtils.getIndexView(moduleInfo, moduleClassesContainerInfo, config)));
        OpenApiDocument.INSTANCE.modelFromReader(OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)appClassloader));
        OpenApiDocument.INSTANCE.filter(OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)appClassloader));
        OpenApiDocument.INSTANCE.initialize();
        OpenAPI openAPIModel = OpenApiDocument.INSTANCE.get();
        if (staticFile == null && OpenAPIUtils.isDefaultOpenApiModel(openAPIModel)) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Default Open API document generated", (Object[])new Object[0]);
            }
            openAPIModel = null;
        }
        return openAPIModel;
    }

    private static boolean isWar(Path path) {
        return path.getFileName().toString().endsWith(".war") && Files.isRegularFile(path, new LinkOption[0]);
    }

    private static Path getCacheDir() {
        Bundle bundle = FrameworkUtil.getBundle(ApplicationProcessor.class);
        if (bundle == null) {
            return null;
        }
        File cacheFile = bundle.getDataFile("");
        if (cacheFile == null) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"No support from OSGi for caching", (Object[])new Object[0]);
            }
            return null;
        }
        return cacheFile.toPath();
    }
}

