/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.metadata.MatchResponse;
import com.ibm.ws.webcontainer.security.metadata.MatchingStrategy;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityConstraintCollectionImpl
implements SecurityConstraintCollection {
    private final List<SecurityConstraint> securityConstraints;
    private static final Set<String> STANDARD_METHODS;
    static final long serialVersionUID = -7339226304441917541L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SecurityConstraintCollectionImpl(List<SecurityConstraint> securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    @Override
    public MatchResponse getMatchResponse(String resourceName, String method) {
        if (this.securityConstraints == null || this.securityConstraints.isEmpty()) {
            return MatchResponse.NO_MATCH_RESPONSE;
        }
        return MatchingStrategy.match(this, resourceName, method);
    }

    @Override
    public List<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    @Override
    public void addSecurityConstraints(List<SecurityConstraint> securityConstraints) {
        this.securityConstraints.addAll(securityConstraints);
    }

    @Override
    public List<MatchResponse> getMatchResponses(String resourceName, String ... methods) {
        ArrayList<MatchResponse> matchResponses = new ArrayList<MatchResponse>();
        HashSet<String> methodList = new HashSet<String>();
        if (this.securityConstraints == null || this.securityConstraints.isEmpty()) {
            return null;
        }
        if (methods == null || methods.length == 0 || methods.length == 1 && methods[0].isEmpty()) {
            methodList.addAll(STANDARD_METHODS);
            for (SecurityConstraint securityConstraint : this.securityConstraints) {
                List<WebResourceCollection> webCollections = securityConstraint.getWebResourceCollections();
                for (WebResourceCollection webResource : webCollections) {
                    if (webResource.performUrlMatch(resourceName) == null) continue;
                    List<String> httpMethodsOnResouce = webResource.getHttpMethods();
                    methodList.addAll(httpMethodsOnResouce);
                }
            }
        } else {
            methodList.addAll(new HashSet<String>(Arrays.asList(methods)));
        }
        for (String method : methodList) {
            MatchResponse match = this.getMatchResponse(resourceName, method);
            matchResponses.add(match);
        }
        return matchResponses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollectionImpl", SecurityConstraintCollectionImpl.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
        STANDARD_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"));
    }
}

