/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.KeyInfo;
import org.w3c.dom.Attr;

public class KeyDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)((Object)parentSAMLObject);
        if (childSAMLObject instanceof KeyInfo) {
            keyDescriptor.setKeyInfo((KeyInfo)childSAMLObject);
        } else if (childSAMLObject instanceof EncryptionMethod) {
            keyDescriptor.getEncryptionMethods().add((EncryptionMethod)((Object)childSAMLObject));
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)((Object)samlObject);
        if (attribute.getName().equals("use")) {
            try {
                UsageType usageType = (UsageType)UsageType.valueOf(UsageType.class, (String)attribute.getValue().toUpperCase());
                if (usageType != UsageType.SIGNING && usageType != UsageType.ENCRYPTION) {
                    throw new UnmarshallingException("Invalid key usage type: " + attribute.getValue());
                }
                keyDescriptor.setUse(usageType);
            }
            catch (IllegalArgumentException e) {
                throw new UnmarshallingException("Invalid key usage type: " + attribute.getValue());
            }
        }
        super.processAttribute(samlObject, attribute);
    }
}

