/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.util.Factory;

public enum VerboseLogging {

    public static final Logger CONN_LOG = Logger.getLogger("yoko.verbose.connection");
    public static final Logger CONN_IN_LOG = Logger.getLogger("yoko.verbose.connection.in");
    public static final Logger CONN_OUT_LOG = Logger.getLogger("yoko.verbose.connection.out");
    public static final Logger RETRY_LOG = Logger.getLogger("yoko.verbose.retry");
    public static final Logger REQ_IN_LOG = Logger.getLogger("yoko.verbose.request.in");
    public static final Logger REQ_OUT_LOG = Logger.getLogger("yoko.verbose.request.out");
    public static final Logger MARSHAL_LOG = Logger.getLogger("yoko.verbose.marshal");

    public static <L extends Throwable> L logged(Logger logger, L loggable, String reason) {
        loggable.addSuppressed(new StackTraceRecord(reason));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, reason, loggable);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(reason + ": " + loggable);
        }
        return loggable;
    }

    public static <W extends Throwable> W wrapped(Logger logger, Exception cause, String reason, Factory<W> wrapperFactory) {
        return (W)VerboseLogging.logged(logger, ((Throwable)wrapperFactory.create()).initCause(cause), reason);
    }

    public static <L extends Throwable> L warned(Logger logger, L loggable, String reason) {
        logger.log(Level.WARNING, reason, loggable);
        return loggable;
    }

    private static class StackTraceRecord
    extends Exception {
        StackTraceRecord(String reason) {
            super(reason);
        }
    }
}

