/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCaException;
import com.ibm.ws.security.acme.AcmeCertificate;
import com.ibm.ws.security.acme.internal.AcmeConfig;
import com.ibm.ws.security.acme.internal.exceptions.IllegalRevocationReasonException;
import com.ibm.ws.security.acme.internal.util.AcmeConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.KeyPair;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.ldap.Rdn;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.AccountBuilder;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.OrderBuilder;
import org.shredzone.acme4j.RevocationReason;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.shredzone.acme4j.exception.AcmeServerException;
import org.shredzone.acme4j.exception.AcmeUserActionRequiredException;
import org.shredzone.acme4j.util.CSRBuilder;
import org.shredzone.acme4j.util.KeyPairUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcmeClient {
    private static final TraceComponent tc = Tr.register(AcmeClient.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private final AcmeConfig acmeConfig;
    private final Map<String, String> httpTokenToAuthzMap = new HashMap<String, String>();
    private static final ReadWriteLock accountKeyPairFileRWLock = new ReentrantReadWriteLock();
    private final long POLL_SLEEP = 500L;
    static final long serialVersionUID = -7336843268505669930L;

    public AcmeClient(AcmeConfig acmeConfig) throws AcmeCaException {
        this.acmeConfig = acmeConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={AcmeException.class, AcmeRetryAfterException.class})
    private void authorize(Authorization authorization) throws AcmeCaException {
        if (authorization.getStatus() == Status.VALID) {
            return;
        }
        Challenge challenge = this.prepareHttpChallenge(authorization);
        try {
            if (challenge.getStatus() == Status.VALID) {
                return;
            }
            try {
                challenge.trigger();
            }
            catch (AcmeException e) {
                throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2009E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), e.getMessage()}));
            }
            Long pollTimeoutMs = this.acmeConfig.getChallengePollTimeoutMs();
            long pollUntil = pollTimeoutMs <= 0L ? 0L : System.currentTimeMillis() + pollTimeoutMs;
            boolean retryAfterRequested = false;
            while (retryAfterRequested || pollUntil == 0L || pollUntil >= System.currentTimeMillis()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Challenge status poll loop: " + (Object)((Object)challenge.getStatus()) + ", " + retryAfterRequested + ", " + pollUntil + ", " + System.currentTimeMillis()), (Object[])new Object[0]);
                }
                if (challenge.getStatus() == Status.INVALID || challenge.getStatus() == Status.VALID) break;
                if (!retryAfterRequested) {
                    AcmeClient.sleep(500L, pollUntil);
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Challenge status poll loop: updating challenge status.", (Object[])new Object[0]);
                    }
                    retryAfterRequested = false;
                    challenge.update();
                }
                catch (AcmeRetryAfterException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Challenge status poll loop: server requested us to retry again later at " + e.getRetryAfter()), (Object[])new Object[0]);
                    }
                    long current = System.currentTimeMillis();
                    if (pollUntil != 0L && current >= pollUntil) break;
                    retryAfterRequested = true;
                    AcmeClient.sleep(e.getRetryAfter().toEpochMilli() - current, pollUntil);
                }
                catch (AcmeException e) {
                    throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2010E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), AcmeClient.getRootCauseMessage(e)}));
                }
            }
            if (challenge.getStatus() == Status.INVALID) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2001E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), authorization.getIdentifier().getDomain(), challenge.getStatus().toString(), challenge.getError().toString()});
                throw new AcmeCaException(msg);
            }
            if (challenge.getStatus() != Status.VALID) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2002E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), authorization.getIdentifier().getDomain(), challenge.getStatus().toString(), pollTimeoutMs + "ms"});
                throw new AcmeCaException(msg);
            }
        }
        finally {
            if (challenge instanceof Http01Challenge) {
                this.httpTokenToAuthzMap.remove(((Http01Challenge)challenge).getToken());
            }
        }
    }

    @FFDCIgnore(value={IOException.class, AcmeException.class, AcmeRetryAfterException.class})
    public AcmeCertificate fetchCertificate(boolean dryRun) throws AcmeCaException {
        Order order;
        long beginTimeMs = System.currentTimeMillis();
        KeyPair accountKeyPair = this.getAccountKeyPair(false);
        Session session = this.getNewSession();
        Account acct = this.findOrRegisterAccount(session, accountKeyPair, dryRun);
        KeyPair domainKeyPair = this.getDomainKeyPair();
        if (dryRun) {
            return null;
        }
        OrderBuilder orderBuilder = acct.newOrder();
        orderBuilder.domains(this.acmeConfig.getDomains());
        if (this.acmeConfig.getValidForMs() != null && this.acmeConfig.getValidForMs() > 0L) {
            orderBuilder.notAfter(Instant.now().plusMillis(this.acmeConfig.getValidForMs()));
        }
        try {
            order = orderBuilder.create();
        }
        catch (AcmeException e) {
            throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2011E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), e.getMessage()}));
        }
        for (Authorization authorization : order.getAuthorizations()) {
            this.authorize(authorization);
        }
        CSRBuilder csrb = new CSRBuilder();
        csrb.addDomains(this.acmeConfig.getDomains());
        for (Rdn rdn : this.acmeConfig.getSubjectDN()) {
            switch (rdn.getType().toLowerCase()) {
                case "o": {
                    csrb.setOrganization((String)rdn.getValue());
                    break;
                }
                case "ou": {
                    csrb.setOrganizationalUnit((String)rdn.getValue());
                    break;
                }
                case "c": {
                    csrb.setCountry((String)rdn.getValue());
                    break;
                }
                case "st": {
                    csrb.setState((String)rdn.getValue());
                    break;
                }
                case "l": {
                    csrb.setLocality((String)rdn.getValue());
                }
            }
        }
        try {
            csrb.sign(domainKeyPair);
        }
        catch (IOException iOException) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2012E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), iOException.getMessage()}), iOException);
        }
        Tr.debug((TraceComponent)tc, (String)("Certificate Signing Request: " + csrb.toString()), (Object[])new Object[0]);
        try {
            order.execute(csrb.getEncoded());
        }
        catch (AcmeException acmeException) {
            throw this.handleAcmeException(acmeException, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2013E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), acmeException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2014E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), iOException.getMessage()}), iOException);
        }
        Long l = this.acmeConfig.getOrderPollTimeoutMs();
        long pollUntil = l <= 0L ? 0L : System.currentTimeMillis() + l;
        boolean retryAfterRequested = false;
        while (retryAfterRequested || pollUntil == 0L || pollUntil >= System.currentTimeMillis()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Order status poll loop: " + (Object)((Object)order.getStatus()) + ", " + retryAfterRequested + ", " + pollUntil + ", " + System.currentTimeMillis()), (Object[])new Object[0]);
            }
            if (order.getStatus() == Status.INVALID || order.getStatus() == Status.VALID) break;
            if (!retryAfterRequested) {
                AcmeClient.sleep(500L, pollUntil);
            }
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Order status poll loop: updating challenge status.", (Object[])new Object[0]);
                }
                retryAfterRequested = false;
                order.update();
            }
            catch (AcmeRetryAfterException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Order status poll loop: server requested us to retry again later at " + e.getRetryAfter()), (Object[])new Object[0]);
                }
                long current = System.currentTimeMillis();
                if (pollUntil != 0L && current >= pollUntil) break;
                retryAfterRequested = true;
                AcmeClient.sleep(e.getRetryAfter().toEpochMilli() - current, pollUntil);
            }
            catch (AcmeException e) {
                throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2015E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), e.getMessage()}));
            }
        }
        if (order.getStatus() == Status.INVALID) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2001E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), this.acmeConfig.getDomains(), order.getStatus().toString(), order.getError().toString()});
            throw new AcmeCaException(msg);
        }
        if (order.getStatus() != Status.VALID) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2004E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), this.acmeConfig.getDomains(), order.getStatus().toString(), l + "ms"});
            throw new AcmeCaException(msg);
        }
        Certificate certificate = order.getCertificate();
        X509Certificate x509Cert = certificate.getCertificate();
        if (x509Cert.getNotBefore().after(Calendar.getInstance().getTime())) {
            Tr.warning((TraceComponent)tc, (String)"CWPKI2045W", (Object[])new Object[]{x509Cert.getSerialNumber().toString(16), this.acmeConfig.getDirectoryURI(), x509Cert.getNotBefore().toInstant().toString()});
        }
        this.checkRenewTimeAgainstCertValidityPeriod(certificate.getCertificate().getNotBefore(), certificate.getCertificate().getNotAfter(), certificate.getCertificate().getSerialNumber().toString(16));
        if (TraceComponent.isAnyTracingEnabled() && tc.isAuditEnabled()) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2064I", (Object[])new Object[]{x509Cert.getSerialNumber().toString(16), this.acmeConfig.getDirectoryURI(), (double)(System.currentTimeMillis() - beginTimeMs) / 1000.0});
            Tr.audit((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
        return new AcmeCertificate(domainKeyPair, x509Cert, certificate.getCertificateChain());
    }

    public AcmeAccount getAccount() throws AcmeCaException {
        return new AcmeAccount(this.getAccount(null));
    }

    private Account getAccount(Session session) throws AcmeCaException {
        KeyPair accountKeyPair = this.loadAccountKeyPair();
        if (accountKeyPair == null) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2025W", (Object[])new Object[]{this.acmeConfig.getDirectoryURI()}));
        }
        if (session == null) {
            session = this.getNewSession();
        }
        return this.getExistingAccount(session, accountKeyPair);
    }

    @FFDCIgnore(value={AcmeServerException.class})
    private Account getExistingAccount(Session session, KeyPair accountKey) throws AcmeCaException {
        try {
            return new AccountBuilder().useKeyPair(accountKey).onlyExisting().create(session);
        }
        catch (AcmeServerException e) {
            return null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"567", (Object)this, (Object[])new Object[]{session, accountKey});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected", (Object[])new Object[]{e});
            }
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2016E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), AcmeClient.getRootCauseMessage(e)}), e);
        }
    }

    @FFDCIgnore(value={AcmeException.class})
    private Account findOrRegisterAccount(Session session, KeyPair accountKey, boolean dryRun) throws AcmeCaException {
        Account account = this.getExistingAccount(session, accountKey);
        if (account == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An existing account was not found, requesting terms of service.", (Object[])new Object[0]);
            }
            URI tosURI = null;
            try {
                tosURI = session.getMetadata().getTermsOfService();
            }
            catch (AcmeException e) {
                throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2017E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), e.getMessage()}));
            }
            if (tosURI == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No terms of service provided", (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)"CWPKI2006I", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), tosURI});
            }
            AccountBuilder accountBuilder = new AccountBuilder().agreeToTermsOfService().useKeyPair(accountKey);
            if (this.acmeConfig.getAccountContacts() != null && !this.acmeConfig.getAccountContacts().isEmpty()) {
                for (String contact : this.acmeConfig.getAccountContacts()) {
                    accountBuilder.addContact(contact);
                }
            }
            try {
                account = accountBuilder.create(session);
            }
            catch (AcmeException e) {
                throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2018E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), AcmeClient.getRootCauseMessage(e)}));
            }
        }
        if (!dryRun) {
            Tr.audit((TraceComponent)tc, (String)"CWPKI2019I", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), account.getLocation()});
        }
        return account;
    }

    public String getHttp01Authorization(String token) {
        return this.httpTokenToAuthzMap.get(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private KeyPair loadAccountKeyPair() throws AcmeCaException {
        accountKeyPairFileRWLock.readLock().lock();
        try {
            File accountKeyFile = null;
            if (this.acmeConfig.getAccountKeyFile() != null) {
                accountKeyFile = new File(this.acmeConfig.getAccountKeyFile());
            }
            if (accountKeyFile != null && accountKeyFile.exists()) {
                KeyPair keyPair;
                FileReader fr = new FileReader(accountKeyFile);
                try {
                    keyPair = KeyPairUtils.readKeyPair(fr);
                }
                catch (Throwable throwable) {
                    try {
                        fr.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2021E", (Object[])new Object[]{accountKeyFile, e.getMessage()}), e);
                    }
                }
                fr.close();
                return keyPair;
            }
            KeyPair keyPair = null;
            return keyPair;
        }
        finally {
            accountKeyPairFileRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private KeyPair loadDomainKeyPair() throws AcmeCaException {
        File domainKeyFile = null;
        if (this.acmeConfig.getDomainKeyFile() != null) {
            domainKeyFile = new File(this.acmeConfig.getDomainKeyFile());
        }
        if (domainKeyFile != null && domainKeyFile.exists()) {
            KeyPair keyPair;
            FileReader fr = new FileReader(domainKeyFile);
            try {
                keyPair = KeyPairUtils.readKeyPair(fr);
            }
            catch (Throwable throwable) {
                try {
                    fr.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2020E", (Object[])new Object[]{domainKeyFile, e.getMessage()}), e);
                }
            }
            fr.close();
            return keyPair;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private KeyPair getAccountKeyPair(boolean force) throws AcmeCaException {
        KeyPair accountKeyPair;
        block11: {
            accountKeyPair = null;
            if (!force) {
                accountKeyPair = this.loadAccountKeyPair();
            }
            if (accountKeyPair == null) {
                accountKeyPairFileRWLock.writeLock().lock();
                try {
                    accountKeyPair = KeyPairUtils.createKeyPair(2048);
                    File accountKeyFile = null;
                    if (this.acmeConfig.getAccountKeyFile() != null && (accountKeyFile = new File(this.acmeConfig.getAccountKeyFile())).getParentFile() != null) {
                        accountKeyFile.getParentFile().mkdirs();
                    }
                    if (accountKeyFile == null) break block11;
                    try (FileWriter fw = new FileWriter(accountKeyFile);){
                        KeyPairUtils.writeKeyPair(accountKeyPair, fw);
                    }
                    catch (IOException e) {
                        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2023E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), accountKeyFile, e.getMessage()}), e);
                    }
                }
                finally {
                    accountKeyPairFileRWLock.writeLock().unlock();
                }
            }
        }
        return accountKeyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private KeyPair getDomainKeyPair() throws AcmeCaException {
        KeyPair domainKeyPair = this.loadDomainKeyPair();
        if (domainKeyPair == null) {
            domainKeyPair = KeyPairUtils.createKeyPair(2048);
            File domainKeyFile = null;
            if (this.acmeConfig.getDomainKeyFile() != null && (domainKeyFile = new File(this.acmeConfig.getDomainKeyFile())).getParentFile() != null) {
                domainKeyFile.getParentFile().mkdirs();
            }
            if (domainKeyFile != null) {
                try (FileWriter fw = new FileWriter(domainKeyFile);){
                    KeyPairUtils.writeKeyPair(domainKeyPair, fw);
                }
                catch (IOException e) {
                    throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2022E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), domainKeyFile, e.getMessage()}), e);
                }
            }
        }
        return domainKeyPair;
    }

    private Challenge prepareHttpChallenge(Authorization auth) throws AcmeCaException {
        Http01Challenge challenge = (Http01Challenge)auth.findChallenge("http-01");
        if (challenge == null) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2005E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), "http-01"}));
        }
        this.httpTokenToAuthzMap.put(challenge.getToken(), challenge.getAuthorization());
        Tr.debug((TraceComponent)tc, (String)("Prepared the HTTP-01 challenge with token '" + challenge.getToken() + "' and authorization '" + challenge.getAuthorization() + "'."), (Object[])new Object[0]);
        return challenge;
    }

    public void revoke(X509Certificate certificate, String reason) throws AcmeCaException {
        this.revoke(certificate, reason, this.acmeConfig.getDirectoryURI());
    }

    @FFDCIgnore(value={AcmeException.class, IllegalArgumentException.class})
    public void revoke(X509Certificate certificate, String reason, String directoryURI) throws AcmeCaException {
        if (certificate == null) {
            return;
        }
        KeyPair accountKeyPair = this.loadAccountKeyPair();
        if (accountKeyPair == null) {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2025W", (Object[])new Object[]{directoryURI}));
        }
        Session session = this.getNewSession(directoryURI);
        Account acct = this.getExistingAccount(session, accountKeyPair);
        if (acct != null) {
            RevocationReason revocationReason = RevocationReason.UNSPECIFIED;
            if (reason != null) {
                try {
                    revocationReason = RevocationReason.valueOf(reason.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalRevocationReasonException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2046E", (Object[])new Object[]{e.getMessage()}), e);
                }
            }
            Login login = new Login(acct.getLocation(), accountKeyPair, session);
            try {
                Certificate.revoke(login, certificate, revocationReason);
                Tr.info((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2038I", (Object[])new Object[]{certificate.getSerialNumber().toString(16)}), (Object[])new Object[0]);
            }
            catch (AcmeException e) {
                throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2024E", (Object[])new Object[]{directoryURI, certificate.getSerialNumber().toString(16), e.getMessage()}));
            }
        }
        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2026W", (Object[])new Object[]{directoryURI}));
    }

    @FFDCIgnore(value={InterruptedException.class})
    private static void sleep(long sleepMs, long orUntil) {
        long current = System.currentTimeMillis();
        long terminate = orUntil != 0L ? Math.min(current + sleepMs, orUntil) : current + sleepMs;
        Tr.debug((TraceComponent)tc, (String)("sleep: " + terminate), (Object[])new Object[0]);
        while ((current = System.currentTimeMillis()) < terminate) {
            try {
                Thread.sleep(terminate - current);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Session getNewSession() throws AcmeCaException {
        return this.getNewSession(this.acmeConfig.getDirectoryURI());
    }

    @FFDCIgnore(value={Exception.class})
    private Session getNewSession(final String directoryURI) throws AcmeCaException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Session>(){
                static final long serialVersionUID = 3751076422935335259L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Session run() throws Exception {
                    ClassLoader origLoader = null;
                    try {
                        origLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        Session session = new Session(directoryURI);
                        return session;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(origLoader);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.acme.internal.AcmeClient$1", 1.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
                }
            });
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Getting a new session failed for " + directoryURI + ", full stack trace is"), (Object[])new Object[]{e});
            }
            Exception cause = e instanceof PrivilegedActionException ? ((PrivilegedActionException)e).getException() : e;
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2028E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), cause.getMessage()}), cause);
        }
    }

    @Trivial
    private static String getRootCauseMessage(Throwable t) {
        String origMessage;
        String rootMessage = origMessage = AcmeClient.addExceptionClass(t);
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            String msg = cause.getMessage();
            if (msg != null && !msg.trim().isEmpty()) {
                rootMessage = AcmeClient.addExceptionClass(cause);
                continue;
            }
            if (!(cause instanceof IOException)) continue;
            rootMessage = origMessage + "  Caused by:  " + AcmeClient.addExceptionClass(cause);
        }
        return rootMessage;
    }

    @Trivial
    private static String addExceptionClass(Throwable t) {
        if (t != null) {
            return t.getClass().getName() + (t.getMessage() == null ? "" : ": " + t.getMessage());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void renewAccountKeyPair() throws AcmeCaException {
        block12: {
            accountKeyPairFileRWLock.writeLock().lock();
            try {
                Account acct = this.getAccount(null);
                if (acct != null) {
                    File backupFile = null;
                    try {
                        String datestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                        File existingFile = new File(this.acmeConfig.getAccountKeyFile());
                        String backupFilename = existingFile.getParent() + File.separatorChar + datestamp + "-" + existingFile.getName();
                        AcmeClient.copyFile(this.acmeConfig.getAccountKeyFile(), backupFilename);
                        backupFile = new File(backupFilename);
                    }
                    catch (IOException datestamp) {
                        void e;
                        FFDCFilter.processException((Throwable)datestamp, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"1209", (Object)this, (Object[])new Object[0]);
                        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2050E", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                    KeyPair keyPair = null;
                    try {
                        keyPair = this.getAccountKeyPair(true);
                    }
                    catch (AcmeCaException existingFile) {
                        void e;
                        FFDCFilter.processException((Throwable)existingFile, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"1220", (Object)this, (Object[])new Object[0]);
                        AcmeClient.deleteFile(backupFile);
                        throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2047E", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                    try {
                        acct.changeKey(keyPair);
                    }
                    catch (AcmeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"1233", (Object)this, (Object[])new Object[0]);
                        try {
                            AcmeClient.copyFile(backupFile.getAbsolutePath(), this.acmeConfig.getAccountKeyFile());
                            AcmeClient.deleteFile(backupFile);
                        }
                        catch (IOException backupFilename) {
                            FFDCFilter.processException((Throwable)backupFilename, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"1241", (Object)this, (Object[])new Object[0]);
                            Tr.error((TraceComponent)tc, (String)"CWPKI2049E", (Object[])new Object[]{this.acmeConfig.getAccountKeyFile(), backupFile.getAbsolutePath()});
                        }
                        throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2047E", (Object[])new Object[]{e.getMessage()}));
                    }
                    Tr.info((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2048I", (Object[])new Object[]{backupFile.getAbsolutePath()}), (Object[])new Object[0]);
                    break block12;
                }
                throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2026W", (Object[])new Object[]{this.acmeConfig.getDirectoryURI()}));
            }
            finally {
                accountKeyPairFileRWLock.writeLock().unlock();
            }
        }
    }

    private static void deleteFile(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 2166459245181565789L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                file.delete();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.acme.internal.AcmeClient$2", 2.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void copyFile(final String source, final String destination) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = 7600054732771506581L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    try (FileOutputStream out = new FileOutputStream(new File(destination));){
                        Files.copy(new File(source).toPath(), out);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.acme.internal.AcmeClient$3", 3.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.acme.internal.AcmeClient", (String)"1311", null, (Object[])new Object[]{source, destination});
            throw (IOException)e.getException();
        }
    }

    @FFDCIgnore(value={AcmeException.class})
    public void updateAccount() throws AcmeCaException {
        Account acct = this.getAccount(null);
        if (acct != null) {
            boolean requiresUpdate;
            List<Object> acctContacts;
            List<String> configContacts = this.acmeConfig.getAccountContacts() == null ? Collections.emptyList() : this.acmeConfig.getAccountContacts();
            List<Object> list = acctContacts = acct.getContacts() == null ? Collections.emptyList() : acct.getContacts();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Existing account contacts: " + acctContacts), (Object[])new Object[0]);
            }
            boolean bl = requiresUpdate = acctContacts.size() != configContacts.size();
            if (!requiresUpdate) {
                for (String contact : configContacts) {
                    if (acctContacts.contains(URI.create(contact))) continue;
                    requiresUpdate = true;
                    break;
                }
            }
            if (requiresUpdate) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Account requires updating.", (Object[])new Object[0]);
                }
                try {
                    Account.EditableAccount editableAcct = acct.modify();
                    List<URI> editableContacts = editableAcct.getContacts();
                    if (editableContacts != null) {
                        editableContacts.clear();
                    }
                    if (configContacts != null) {
                        for (String contact : configContacts) {
                            editableAcct.addContact(URI.create(contact));
                        }
                    }
                    editableAcct.commit();
                }
                catch (AcmeException e) {
                    throw this.handleAcmeException(e, Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2033E", (Object[])new Object[]{acct.getLocation(), this.acmeConfig.getDirectoryURI(), e.getMessage()}));
                }
            }
        } else {
            throw new AcmeCaException(Tr.formatMessage((TraceComponent)tc, (String)"CWPKI2026W", (Object[])new Object[]{this.acmeConfig.getDirectoryURI()}));
        }
    }

    protected void checkRenewTimeAgainstCertValidityPeriod(Date notBefore, Date notAfter, String serialNumber) {
        long notBeforems = notBefore.getTime();
        long notAfterms = notAfter.getTime();
        long renewCertMin = this.acmeConfig.getRenewCertMin();
        long validityPeriod = notAfterms - notBeforems;
        long renewBeforeExpirationMs = this.acmeConfig.getRenewBeforeExpirationMs();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validity versus renew check", (Object[])new Object[]{notBeforems, notAfterms, validityPeriod, renewBeforeExpirationMs});
        }
        if (validityPeriod <= renewBeforeExpirationMs) {
            if (validityPeriod <= renewCertMin) {
                Tr.warning((TraceComponent)tc, (String)"CWPKI2056W", (Object[])new Object[]{serialNumber, renewCertMin + "ms", validityPeriod, renewCertMin + "ms"});
                this.acmeConfig.setRenewBeforeExpirationMs(renewCertMin, false);
            } else if (validityPeriod <= AcmeConstants.RENEW_DEFAULT_MS) {
                long resetRenew = Math.round((double)validityPeriod * 0.5);
                long priorRenew = renewBeforeExpirationMs;
                this.acmeConfig.setRenewBeforeExpirationMs(resetRenew <= renewCertMin ? renewCertMin : resetRenew, false);
                Tr.warning((TraceComponent)tc, (String)"CWPKI2054W", (Object[])new Object[]{priorRenew + "ms", serialNumber, validityPeriod, renewBeforeExpirationMs + "ms"});
            } else {
                Tr.warning((TraceComponent)tc, (String)"CWPKI2054W", (Object[])new Object[]{renewBeforeExpirationMs + "ms", serialNumber, validityPeriod + "ms", AcmeConstants.RENEW_DEFAULT_MS + "ms"});
                this.acmeConfig.setRenewBeforeExpirationMs(AcmeConstants.RENEW_DEFAULT_MS, false);
            }
        }
    }

    @Trivial
    private AcmeCaException handleAcmeException(AcmeException acmeException, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Caught AcmeException", (Object[])new Object[]{acmeException, message});
        }
        if (acmeException instanceof AcmeUserActionRequiredException) {
            AcmeUserActionRequiredException uae = (AcmeUserActionRequiredException)acmeException;
            Tr.error((TraceComponent)tc, (String)"CWPKI2063E", (Object[])new Object[]{this.acmeConfig.getDirectoryURI(), uae.getTermsOfServiceUri()});
        }
        return new AcmeCaException(message, acmeException);
    }

    @Trivial
    public class AcmeAccount {
        private final Account account;

        private AcmeAccount(Account account) {
            this.account = account;
        }

        public List<URI> getContacts() {
            return this.account.getContacts();
        }

        public URL getLocation() {
            return this.account.getLocation();
        }

        @FFDCIgnore(value={AcmeProtocolException.class})
        public List<String> getOrders() {
            Iterator<Order> orders;
            try {
                orders = this.account.getOrders();
                if (orders == null) {
                    return Collections.emptyList();
                }
            }
            catch (AcmeProtocolException e) {
                return Collections.emptyList();
            }
            ArrayList<String> ordersList = new ArrayList<String>();
            while (orders.hasNext()) {
                Order order = orders.next();
                ordersList.add(order.getJSON().toString());
            }
            return ordersList;
        }

        public String getStatus() {
            return this.account.getStatus().toString();
        }

        public Boolean getTermsOfServiceAgreed() {
            return this.account.getTermsOfServiceAgreed();
        }

        public String toString() {
            return super.toString() + "{" + this.account.getLocation() + "}";
        }
    }
}

