/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;

public abstract class MemoryLimitedCacheLoader
implements BootstrapCacheLoader,
Cloneable {
    protected boolean isInMemoryLimitReached(Ehcache cache, int loadedElements) {
        long maxElementsInMem;
        long maxBytesInMem;
        boolean overflowToOffHeap = cache.getCacheConfiguration().isOverflowToOffHeap();
        if (overflowToOffHeap) {
            maxBytesInMem = cache.getCacheConfiguration().getMaxBytesLocalHeap();
            maxElementsInMem = cache.getCacheConfiguration().getMaxEntriesLocalHeap() == 0L ? Integer.MAX_VALUE : cache.getCacheConfiguration().getMaxEntriesLocalHeap();
        } else {
            maxBytesInMem = cache.getCacheConfiguration().getMaxBytesLocalOffHeap();
            long l = maxElementsInMem = cache.getCacheConfiguration().getMaxEntriesLocalHeap() == 0L ? Integer.MAX_VALUE : cache.getCacheConfiguration().getMaxEntriesLocalHeap();
        }
        if (maxBytesInMem != 0L) {
            long inMemorySizeInBytes = overflowToOffHeap ? cache.calculateOffHeapSize() : cache.calculateInMemorySize();
            long avgSize = inMemorySizeInBytes / (overflowToOffHeap ? cache.getOffHeapStoreSize() : cache.getMemoryStoreSize());
            return inMemorySizeInBytes + avgSize * 2L >= maxBytesInMem;
        }
        return (long)loadedElements >= maxElementsInMem;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

