/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageHandle;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MPLockedMessageEnumeration;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPILockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.interfaces.JsMessageWrapper;
import com.ibm.ws.sib.processor.impl.interfaces.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.ArrayList;
import java.util.Iterator;

abstract class AbstractLockedMessageEnumeration
implements MPLockedMessageEnumeration,
AlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceComponent tc = SibTr.register(AbstractLockedMessageEnumeration.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MPAlarmManager alarmManager = null;
    private boolean alarmRegistered = false;
    private boolean msgReferenceAlarmRegistered = false;
    private LMEMessage callbackEntryMsg;
    protected ConsumerSessionImpl consumerSession;
    protected LMEMessage currentMsg;
    protected LMEMessage currentUnlockedMessage;
    private boolean endReached;
    protected LMEMessage firstMsg;
    protected boolean isPubsub = false;
    protected LMEMessage lastMsg;
    private LocalConsumerPoint localConsumerPoint;
    protected boolean messageAvailable = false;
    private long messageLockExpiry = 0L;
    protected MessageProcessor messageProcessor;
    private LMEMessage nextMsgToExpire;
    private LMEMessage nextMsgReferenceToExpire;
    private int pooledCount;
    private LMEMessage pooledMsg;
    private static final int poolSize = 20;
    protected SIMPTransactionManager txManager;
    private boolean validState = false;
    private boolean setWaitTime = false;
    private boolean copyMsg = false;

    AbstractLockedMessageEnumeration(LocalConsumerPoint localConsumerPoint, MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractLockedMessageEnumeration", (Object)new Object[]{localConsumerPoint, messageProcessor});
        }
        this.firstMsg = null;
        this.lastMsg = null;
        this.callbackEntryMsg = null;
        this.currentMsg = null;
        this.pooledMsg = null;
        this.currentUnlockedMessage = null;
        this.pooledCount = 0;
        this.endReached = false;
        this.nextMsgToExpire = null;
        this.nextMsgReferenceToExpire = null;
        this.localConsumerPoint = localConsumerPoint;
        this.consumerSession = localConsumerPoint.getConsumerSession();
        this.messageProcessor = messageProcessor;
        this.txManager = messageProcessor.getTXManager();
        this.alarmManager = messageProcessor.getAlarmManager();
        this.copyMsg = ((ConnectionImpl)this.consumerSession.getConnectionInternal()).getMessageCopiedWhenReceived();
        this.setWaitTime = ((ConnectionImpl)this.consumerSession.getConnectionInternal()).getSetWaitTimeInMessage();
        this.isPubsub = localConsumerPoint.getConsumerManager().getDestination().isPubSub();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractLockedMessageEnumeration", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewMessage(JsMessageWrapper message, boolean isStored, boolean isRecoverable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewMessage", (Object)new Object[]{new Integer(this.hashCode()), message, new Boolean(isStored)});
        }
        JsMessage jsMsg = message.getMessage();
        long id = jsMsg.getSystemMessageValue();
        SIBUuid8 uuid = jsMsg.getSystemMessageSourceUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"addNewMessage", (Object)new Object[]{new Integer(this.hashCode()), new Long(jsMsg.getSystemMessageValue()), jsMsg.getSystemMessageSourceUuid(), message, new Boolean(isStored)});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this.localConsumerPoint, (TraceComponent)tc, (String)("verboseMsg OUT : " + message.getMessage().toVerboseString()));
        }
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            block25: {
                LMEMessage newElement = null;
                long messageReferenceExpiry = this.messageProcessor.getCustomProperties().get_message_reference_expiry_value();
                if (this.pooledMsg == null) {
                    newElement = new LMEMessage(id, uuid, message, isStored, isRecoverable, this.messageLockExpiry, messageReferenceExpiry);
                } else {
                    newElement = this.pooledMsg;
                    this.pooledMsg = this.pooledMsg.next;
                    newElement.next = null;
                    --this.pooledCount;
                    newElement.reuseMessage(id, uuid, message, isStored, isRecoverable, this.messageLockExpiry, messageReferenceExpiry);
                }
                newElement.previous = this.lastMsg;
                if (this.lastMsg != null) {
                    this.lastMsg.next = newElement;
                } else {
                    this.firstMsg = newElement;
                }
                this.lastMsg = newElement;
                if (this.messageLockExpiry != 0L) {
                    if (this.nextMsgToExpire == null) {
                        this.nextMsgToExpire = newElement;
                    }
                    if (!this.alarmRegistered) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"addNewMessage", (Object)("Registering MessageLock Expiry alarm for: " + this.nextMsgToExpire));
                        }
                        this.alarmManager.create(this.messageLockExpiry, this);
                        this.alarmRegistered = true;
                    }
                }
                if (messageReferenceExpiry != 0L) {
                    if (this.messageLockExpiry != 0L && messageReferenceExpiry > this.messageLockExpiry) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("MessageReferenceExpiry: " + messageReferenceExpiry + " is greater than messageLockExpiry: " + this.messageLockExpiry));
                            SibTr.debug((TraceComponent)tc, (String)"MessageReferneceExpiry Alarm not registered");
                        }
                    } else {
                        try {
                            if (message.getReportCOD() == null) {
                                if (this.nextMsgReferenceToExpire == null) {
                                    this.nextMsgReferenceToExpire = newElement;
                                }
                                if (!this.msgReferenceAlarmRegistered) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((TraceComponent)tc, (String)"addNewMessage", (Object)("Registering MessageReference Expiry alarm for: " + this.nextMsgReferenceToExpire));
                                    }
                                    this.alarmManager.create(messageReferenceExpiry, new MessageReferenceExpiryAlarm());
                                    this.msgReferenceAlarmRegistered = true;
                                }
                            }
                        }
                        catch (SIResourceException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                            SibTr.debug((TraceComponent)tc, (String)("Thrown exception when trying to create msg ref expiry alarm: " + (Object)((Object)e)));
                        }
                    }
                }
            }
            this.validState = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewMessage", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this, this.nextMsgToExpire, object});
        }
        ArrayList<JsMessageWrapper> messagesToUnlock = null;
        int unlockedActiveMessages = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            long currentTime = System.currentTimeMillis();
            while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime <= currentTime) {
                if (this.nextMsgToExpire.expiryTime != 0L) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Expiring lock on: " + this.nextMsgToExpire));
                    }
                    if (messagesToUnlock == null) {
                        messagesToUnlock = new ArrayList<JsMessageWrapper>();
                    }
                    messagesToUnlock.add(this.nextMsgToExpire.message);
                    this.nextMsgToExpire.lockExpired = true;
                    this.nextMsgToExpire.isStored = false;
                    this.nextMsgToExpire.message = null;
                    this.nextMsgToExpire.jsMessage = null;
                    ++unlockedActiveMessages;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("No expiry for: " + this.nextMsgToExpire));
                }
                do {
                    this.nextMsgToExpire = this.nextMsgToExpire.next;
                } while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime == 0L);
            }
            if (this.nextMsgToExpire != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Registering alarm for: " + this.nextMsgToExpire));
                }
                this.alarmManager.create(this.nextMsgToExpire.expiryTime - currentTime, this);
            } else {
                this.alarmRegistered = false;
            }
        }
        if (unlockedActiveMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(unlockedActiveMessages);
        }
        if (messagesToUnlock != null) {
            Iterator itr = messagesToUnlock.iterator();
            while (itr.hasNext()) {
                try {
                    this.unlockMessage((JsMessageWrapper)itr.next(), false);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.alarm", (String)"1:676:1.154.3.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:683:1.154.3.1", e});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) continue;
                    SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)((Object)e));
                }
                catch (SISessionDroppedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.alarm", (String)"1:695:1.154.3.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:702:1.154.3.1", e});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) continue;
                    SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)((Object)e));
                }
                catch (SIMPMessageNotLockedException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)this);
        }
    }

    protected boolean checkCurrentMessageAvailable(TransactionCommon transaction) throws SIIncorrectCallException, SIMPMessageNotLockedException, SIResourceException, SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)transaction);
        }
        if (!this.messageAvailable) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)"Invalid current Message");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_MESSAGE_ERROR_CWSIP0191", new Object[]{this.localConsumerPoint.getConsumerManager().getDestination().getName(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null));
        }
        if (this.localConsumerPoint.getConsumerManager().getDestination().isOrdered()) {
            if (this.currentMsg != this.firstMsg) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)"Ordering error - Current message is not first message");
                }
                throw new SIIncorrectCallException(nls.getFormattedMessage("ORDERED_MESSAGING_ERROR_CWSIP0194", new Object[]{this.localConsumerPoint.getConsumerManager().getDestination().getName(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null));
            }
            if (!this.localConsumerPoint.getConsumerManager().isNewTransactionAllowed((TransactionCommon)((Transaction)transaction))) {
                if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)"Ordering error - Transaction active");
                }
                throw new SISessionUnavailableException(nls.getFormattedMessage("ORDERED_MESSAGING_ERROR_CWSIP0194", new Object[]{this.localConsumerPoint.getConsumerManager().getDestination().getName(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null));
            }
        }
        if (this.currentMsg.lockExpired) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)"Message lock expired");
            }
            SIMessageHandle[] msgHandles = new SIMessageHandle[]{MessageProcessor.getJsMessageHandleFactory().createJsMessageHandle(this.currentMsg.uuid, this.currentMsg.id)};
            throw new SIMPMessageNotLockedException(nls.getFormattedMessage("MESSAGE_LOCK_EXPIRED_ERROR_CWSIP0193", new Object[]{msgHandles[0].toString(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null), msgHandles);
        }
        this.messageAvailable = false;
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"checkCurrentMessageAvailable", (Object)true);
        }
        return true;
    }

    protected void checkValidState(String method) throws SIIncorrectCallException {
        if (!this.validState) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkValidState");
            }
            SIIncorrectCallException e = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0131", new Object[]{method}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkValidState", (Object)((Object)e));
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOutBifurcatedMessages(BifurcatedConsumerSessionImpl owner, boolean bumpRedeliveryOnClose) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanOutBifurcatedMessages", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int unlockedMessages = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (this.firstMsg != null) {
                LMEMessage message = this.firstMsg;
                LMEMessage unlockMsg = null;
                while (message != null) {
                    unlockMsg = message;
                    message = message.next;
                    if (unlockMsg.owner != owner) continue;
                    if (unlockMsg.isStored) {
                        try {
                            this.unlockMessage(unlockMsg.message, bumpRedeliveryOnClose);
                        }
                        catch (SIMPMessageNotLockedException e) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                    this.removeMessage(unlockMsg);
                    ++unlockedMessages;
                }
            }
        }
        if (unlockedMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(unlockedMessages);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanOutBifurcatedMessages", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrent(SITransaction transaction) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)new Object[]{new Integer(this.hashCode()), transaction, this});
        }
        this.checkValidState("deleteCurrent");
        this.localConsumerPoint.checkNotClosed();
        if (transaction != null && !((TransactionCommon)transaction).isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)((Object)e));
            }
            throw e;
        }
        JsMessageWrapper msg = null;
        boolean isStored = false;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            this.checkCurrentMessageAvailable((TransactionCommon)transaction);
            msg = this.currentMsg.message;
            isStored = this.currentMsg.isStored;
            this.removeMessage(this.currentMsg);
            this.messageAvailable = false;
        }
        if (msg != null) {
            if (isStored) {
                this.removeMessageFromStore(msg, (TransactionCommon)transaction, true);
            } else {
                this.localConsumerPoint.removeActiveMessages(1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeen(SITransaction transaction) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)new Object[]{new Integer(this.hashCode()), transaction, this});
        }
        this.checkValidState("deleteSeen");
        this.localConsumerPoint.checkNotClosed();
        if (transaction != null && !((TransactionCommon)transaction).isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)((Object)e));
            }
            throw e;
        }
        if (this.localConsumerPoint.getConsumerManager().getDestination().isOrdered() && !this.localConsumerPoint.getConsumerManager().isNewTransactionAllowed((TransactionCommon)transaction)) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)"Ordering error - Transaction active");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("ORDERED_MESSAGING_ERROR_CWSIP0194", new Object[]{this.localConsumerPoint.getConsumerManager().getDestination().getName(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null));
        }
        LocalTransaction localTransaction = null;
        int deletedActiveMessages = 0;
        SIMPMessageNotLockedException notLockedException = null;
        int notLockedExceptionMessageIndex = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            this.messageAvailable = false;
            if (this.firstMsg != null) {
                SIMessageHandle[] messageHandles = new SIMessageHandle[this.getNumberOfLockedMessages()];
                LMEMessage pointerMsg = this.firstMsg;
                LMEMessage endMsg = this.currentMsg == null && this.endReached ? this.lastMsg : this.currentMsg;
                if (endMsg != null) {
                    TransactionCommon tranImpl = (TransactionCommon)transaction;
                    boolean more = true;
                    if (tranImpl != null) {
                        tranImpl.registerCallback((TransactionCallback)pointerMsg.message);
                    }
                    while (more) {
                        if (pointerMsg == endMsg) {
                            more = false;
                        }
                        if (pointerMsg.isStored) {
                            if (tranImpl == null) {
                                localTransaction = this.txManager.createLocalTransaction(!this.isRMQ());
                                tranImpl = localTransaction;
                                tranImpl.registerCallback((TransactionCallback)pointerMsg.message);
                            }
                            try {
                                this.removeMessageFromStore(pointerMsg.message, tranImpl, true);
                            }
                            catch (SIMPMessageNotLockedException e) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:1081:1.154.3.1", e});
                                messageHandles[notLockedExceptionMessageIndex] = pointerMsg.getJsMessage().getMessageHandle();
                                ++notLockedExceptionMessageIndex;
                                notLockedException = e;
                                if (localTransaction != null) {
                                    ++deletedActiveMessages;
                                }
                            }
                        } else {
                            ++deletedActiveMessages;
                        }
                        LMEMessage removedMsg = pointerMsg;
                        pointerMsg = pointerMsg.next;
                        this.removeMessage(removedMsg);
                    }
                }
            }
        }
        if (deletedActiveMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(deletedActiveMessages);
        }
        if (localTransaction != null) {
            localTransaction.commit();
        }
        if (notLockedException != null) {
            if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)this);
            }
            throw notLockedException;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)this);
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)new Integer(this.hashCode()));
        }
        this.checkValidState("getConsumerSession");
        this.localConsumerPoint.checkNotClosed();
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this.consumerSession);
        }
        return this.consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfLockedMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfLockedMessages");
        }
        int count = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            LMEMessage message = this.firstMsg;
            while (message != null) {
                ++count;
                message = message.next;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfLockedMessages", (Object)new Integer(count));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int count = 0;
        this.checkValidState("getRemainingMessageCount");
        this.localConsumerPoint.checkNotClosed();
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (!this.endReached) {
                LMEMessage message = this.currentMsg == null ? this.firstMsg : this.currentMsg.next;
                while (message != null) {
                    ++count;
                    message = message.next;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Integer(count));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        boolean hasNext = false;
        this.checkValidState("hasNext");
        this.localConsumerPoint.checkNotClosed();
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (!this.endReached) {
                if (this.currentMsg == null) {
                    if (this.firstMsg != null) {
                        hasNext = true;
                    }
                } else if (this.currentMsg.next != null) {
                    hasNext = true;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Boolean(hasNext));
        }
        return hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        JsMessage jsMsg = null;
        JsMessageWrapper msg = null;
        LMEMessage dirtyMessage = null;
        boolean removeMsg = false;
        this.checkValidState("nextLocked");
        this.localConsumerPoint.checkNotClosed();
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            if (this.currentMsg != null) {
                this.currentMsg = this.currentMsg.next;
            } else if (!this.endReached) {
                this.currentMsg = this.firstMsg;
            }
            if (this.currentMsg != null) {
                msg = this.currentMsg.message;
                jsMsg = this.currentMsg.jsMessage;
                if (jsMsg != null && !this.currentMsg.wasRead) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:1318:1.154.3.1"}, null));
                    if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)e));
                    }
                    throw e;
                }
                if (this.currentMsg.isStored && !this.currentMsg.isRecoverable) {
                    removeMsg = true;
                    this.currentMsg.isStored = false;
                }
                dirtyMessage = this.currentMsg;
                this.currentMsg.wasRead = true;
                this.messageAvailable = true;
            } else {
                this.messageAvailable = false;
                this.endReached = true;
            }
        }
        if (msg != null && jsMsg == null) {
            jsMsg = this.setPropertiesInMessage(this.currentMsg);
            if (removeMsg) {
                try {
                    this.removeMessageFromStore(msg, null, false);
                }
                catch (SIMPMessageNotLockedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.nextLocked", (String)"1:1396:1.154.3.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:1403:1.154.3.1", e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"nextLocked", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:1414:1.154.3.1", e}, null), (Throwable)e);
                }
            }
            dirtyMessage.jsMessage = jsMsg;
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(null, jsMsg, this.consumerSession.getDestinationAddress(), this.consumerSession.getIdInternal());
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)new Object[]{jsMsg});
        }
        return jsMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage peek() throws SISessionUnavailableException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"peek", (Object)this);
        }
        this.checkValidState("peek");
        this.localConsumerPoint.checkNotClosed();
        JsMessage jsMsg = null;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (!this.endReached) {
                if (this.currentMsg == null) {
                    if (this.firstMsg != null) {
                        jsMsg = this.setPropertiesInMessage(this.firstMsg);
                    }
                } else if (this.currentMsg.next != null) {
                    jsMsg = this.setPropertiesInMessage(this.currentMsg.next);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"peek", (Object)jsMsg);
        }
        return jsMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIBusMessage[] processMsgSet(SIMessageHandle[] msgHandles, TransactionCommon transaction, BifurcatedConsumerSessionImpl bifurcatedConsumer, boolean unlock, boolean delete, boolean read, boolean incrementLockCount) throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException, SIMPMessageNotLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{new Integer(this.hashCode()), SIMPUtils.messageHandleArrayToString(msgHandles), transaction, bifurcatedConsumer, new Boolean(unlock), new Boolean(delete), new Boolean(read), new Boolean(incrementLockCount), this});
        }
        int numMsgs = msgHandles.length;
        LocalTransaction localTransaction = null;
        if (transaction != null && !transaction.isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)e));
            }
            throw e;
        }
        SIBusMessage[] messages = null;
        if (read) {
            messages = new SIBusMessage[numMsgs];
        }
        SIMessageHandle[] missingMsgs = null;
        int missingMsgIndex = 0;
        int removedActiveMessages = 0;
        JsMessageWrapper[] messagesToUnlock = null;
        int unlockIndex = 0;
        JsMessageWrapper autoCommitMessage = null;
        try {
            AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
            synchronized (abstractLockedMessageEnumeration) {
                int nextId = 0;
                for (nextId = 0; nextId < numMsgs; ++nextId) {
                    if (msgHandles[nextId] != null) {
                        LMEMessage lmeMessage = this.firstMsg;
                        boolean msgFound = false;
                        while (lmeMessage != null) {
                            boolean expiredMsgFound = false;
                            if (lmeMessage.id == ((JsMessageHandle)msgHandles[nextId]).getSystemMessageValue() && lmeMessage.uuid.equals((Object)((JsMessageHandle)msgHandles[nextId]).getSystemMessageSourceUuid()) && lmeMessage != this.currentUnlockedMessage) {
                                if (!lmeMessage.lockExpired) {
                                    if (lmeMessage.owner != null && lmeMessage.owner != bifurcatedConsumer) break;
                                    if (read) {
                                        messages[nextId] = lmeMessage.getJsMessage();
                                        lmeMessage.expiryTime = 0L;
                                        if (bifurcatedConsumer != null && !delete) {
                                            lmeMessage.owner = bifurcatedConsumer;
                                        }
                                    }
                                    boolean markMsgAsMissing = false;
                                    if (delete) {
                                        if (lmeMessage.isStored) {
                                            if (transaction == null) {
                                                if (numMsgs > 1 || !lmeMessage.message.isReference() && lmeMessage.message.getReportCOD() != null || lmeMessage.message.isRemoteGet()) {
                                                    localTransaction = this.txManager.createLocalTransaction(!this.isRMQ());
                                                    transaction = localTransaction;
                                                } else {
                                                    autoCommitMessage = lmeMessage.message;
                                                }
                                            } else if (lmeMessage.message.isRemoteGet() && transaction.isAutoCommit()) {
                                                localTransaction = this.txManager.createLocalTransaction(!this.isRMQ());
                                                transaction = localTransaction;
                                            }
                                            if (autoCommitMessage == null) {
                                                try {
                                                    this.removeMessageFromStore(lmeMessage.message, transaction, true);
                                                }
                                                catch (SIMPMessageNotLockedException e) {
                                                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                                    markMsgAsMissing = true;
                                                }
                                            }
                                        } else {
                                            ++removedActiveMessages;
                                        }
                                        this.removeMessage(lmeMessage);
                                    } else if (unlock) {
                                        if (lmeMessage.isStored) {
                                            if (messagesToUnlock == null) {
                                                messagesToUnlock = new JsMessageWrapper[numMsgs];
                                            }
                                            messagesToUnlock[unlockIndex++] = lmeMessage.message;
                                        }
                                        this.removeMessage(lmeMessage);
                                        ++removedActiveMessages;
                                    }
                                    if (markMsgAsMissing) break;
                                    msgFound = true;
                                    break;
                                }
                                LMEMessage temp = lmeMessage.next;
                                this.removeMessage(lmeMessage);
                                lmeMessage = temp;
                                expiredMsgFound = true;
                            }
                            if (!expiredMsgFound) {
                                lmeMessage = lmeMessage.next;
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)tc, (String)("Checking msg for read and delete : " + lmeMessage));
                        }
                        if (msgFound) continue;
                        if (missingMsgs == null) {
                            missingMsgs = new SIMessageHandle[numMsgs];
                        }
                        missingMsgs[missingMsgIndex] = msgHandles[nextId];
                        ++missingMsgIndex;
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)"SIIncorrectCallException one or more null SIMessageHandles");
                    }
                    throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0132", null, null));
                }
            }
            if (autoCommitMessage != null) {
                try {
                    this.removeMessageFromStore(autoCommitMessage, null, true);
                }
                catch (SIMPMessageNotLockedException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            } else if (localTransaction != null) {
                localTransaction.commit();
            }
            if (removedActiveMessages != 0) {
                this.localConsumerPoint.removeActiveMessages(removedActiveMessages);
            }
            if (unlockIndex != 0) {
                for (int i = 0; i < unlockIndex; ++i) {
                    try {
                        this.unlockMessage((JsMessageWrapper)messagesToUnlock[i], incrementLockCount);
                        continue;
                    }
                    catch (SIMPMessageNotLockedException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                }
            }
            if (missingMsgs != null) {
                SIMessageHandle[] croppedMissingMsgs = new SIMessageHandle[missingMsgIndex];
                System.arraycopy(missingMsgs, 0, croppedMissingMsgs, 0, missingMsgIndex);
                SIMPMessageNotLockedException e = new SIMPMessageNotLockedException(nls.getFormattedMessage("CORE_MESSAGE_NOT_FOUND_ERROR_CWSIP0173", new Object[]{SIMPUtils.messageHandleArrayToString(croppedMissingMsgs), this.localConsumerPoint.getConsumerManager().getDestination().getName(), this.localConsumerPoint.getConsumerManager().getMessageProcessor().getMessagingEngineName()}, null), croppedMissingMsgs);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)e));
                }
                throw e;
            }
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.processMsgSet", (String)"1:1824:1.154.3.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:1831:1.154.3.1", e});
            if (localTransaction != null) {
                localTransaction.rollback();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{messages, this});
        }
        return messages;
    }

    abstract boolean isRMQ();

    protected void removeMessage(LMEMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{new Integer(this.hashCode()), message, this});
        }
        if (message == this.callbackEntryMsg) {
            this.callbackEntryMsg = message.previous;
        }
        if (message == this.currentMsg) {
            this.currentMsg = message.previous;
        }
        if (message == this.nextMsgToExpire) {
            do {
                this.nextMsgToExpire = this.nextMsgToExpire.next;
            } while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime == 0L);
        }
        if (message == this.nextMsgReferenceToExpire) {
            do {
                this.nextMsgReferenceToExpire = this.nextMsgReferenceToExpire.next;
            } while (this.nextMsgReferenceToExpire != null && this.nextMsgReferenceToExpire.expiryTime == 0L);
        }
        if (message.previous != null) {
            message.previous.next = message.next;
        } else {
            this.firstMsg = message.next;
        }
        if (message.next != null) {
            message.next.previous = message.previous;
        } else {
            this.lastMsg = message.previous;
        }
        if (this.pooledCount < 20) {
            message.message = null;
            message.next = this.pooledMsg;
            message.previous = null;
            message.owner = null;
            message.jsMessage = null;
            message.expiryTime = 0L;
            message.expiryMsgReferenceTime = 0L;
            this.pooledMsg = message;
            ++this.pooledCount;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)this);
        }
    }

    abstract void removeMessageFromStore(JsMessageWrapper var1, TransactionCommon var2, boolean var3) throws SIResourceException, SISessionDroppedException, SIIncorrectCallException, SIMPMessageNotLockedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCallbackCursor() throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetCallbackCursor", (Object)new Integer(this.hashCode()));
        }
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            this.unlockAllUnread();
            this.callbackEntryMsg = this.lastMsg;
            this.currentMsg = this.lastMsg;
            this.messageAvailable = false;
            this.endReached = false;
            this.validState = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetCallbackCursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)new Object[]{this, new Integer(this.hashCode())});
        }
        this.checkValidState("resetCursor");
        this.localConsumerPoint.checkNotClosed();
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            this.currentMsg = this.callbackEntryMsg;
            this.endReached = false;
            this.messageAvailable = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageLockExpiry(long messageLockExpiry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageLockExpiry", (Object)new Long(messageLockExpiry));
            SibTr.exit((TraceComponent)tc, (String)"setMessageLockExpiry");
        }
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            this.messageLockExpiry = messageLockExpiry;
        }
    }

    final JsMessage setPropertiesInMessage(LMEMessage theMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPropertiesInMessage", (Object)theMessage);
        }
        boolean copyMade = false;
        JsMessageWrapper jsMessageWrapper = theMessage.message;
        JsMessage jsMsg = jsMessageWrapper.getMessage();
        try {
            if (jsMessageWrapper.guessRedeliveredCount() != 0) {
                if (this.isPubsub) {
                    jsMsg = jsMsg.getReceived();
                    copyMade = true;
                }
                jsMsg.setRedeliveredCount(jsMessageWrapper.guessRedeliveredCount());
            }
            long waitTime = jsMessageWrapper.updateStatisticsMessageWaitTime();
            if (this.setWaitTime) {
                boolean waitTimeIsSignificant;
                boolean bl = waitTimeIsSignificant = waitTime > this.messageProcessor.getCustomProperties().get_message_wait_time_granularity();
                if (waitTimeIsSignificant) {
                    if (this.isPubsub && !copyMade) {
                        jsMsg = jsMsg.getReceived();
                        copyMade = true;
                    }
                    jsMsg.setMessageWaitTime(waitTime);
                }
            }
            if (!copyMade && (theMessage.isStored && this.copyMsg || this.isPubsub)) {
                jsMsg = jsMsg.getReceived();
            }
        }
        catch (MessageCopyFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.setPropertiesInMessage", (String)"1:2086:1.154.3.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:2093:1.154.3.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setPropertiesInMessage", (Object)((Object)e));
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:2104:1.154.3.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPropertiesInMessage", (Object)jsMsg);
        }
        return jsMsg;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        LMEMessage msg;
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent + "endReached:" + this.endReached + "\n");
        buffer.append(indent + "msgAvailable:" + this.messageAvailable + "\n");
        if (this.currentMsg == null) {
            buffer.append(indent + "No current message\n");
        }
        if ((msg = this.firstMsg) != null) {
            while (msg != null) {
                if (msg == this.firstMsg) {
                    buffer.append(indent + "firstMsg:\n");
                }
                if (msg == this.callbackEntryMsg) {
                    buffer.append(indent + "callbackEntryMsg:\n");
                }
                if (msg == this.currentUnlockedMessage) {
                    buffer.append(indent + "currentUnlockedMessage:\n");
                }
                if (msg == this.currentMsg) {
                    buffer.append(indent + "currentMsg:\n");
                }
                if (msg == this.nextMsgToExpire) {
                    buffer.append(indent + "nextMsgToExpire:\n");
                }
                if (msg == this.nextMsgReferenceToExpire) {
                    buffer.append(indent + "nextMsgReferenceToExpire:\n");
                }
                if (msg == this.lastMsg) {
                    buffer.append(indent + "lastMsg:\n");
                }
                buffer.append(indent + "  " + msg.toString());
                msg = msg.next;
            }
        } else {
            buffer.append(indent + "No messages in the enumeration\n");
        }
        buffer.append(indent + "pooledCount: " + this.pooledCount + "\n");
        return buffer.toString();
    }

    protected void unlockAll() throws SIResourceException, SIMPMessageNotLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll");
        }
        this.unlockAll(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll(boolean closingSession) throws SIResourceException, SIMPMessageNotLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int unlockedMessages = 0;
        SIMPMessageNotLockedException notLockedException = null;
        int notLockedExceptionMessageIndex = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            this.messageAvailable = false;
            if (this.firstMsg != null) {
                LMEMessage pointerMsg = this.firstMsg;
                LMEMessage removedMsg = null;
                SIMessageHandle[] messageHandles = new SIMessageHandle[this.getNumberOfLockedMessages()];
                boolean more = true;
                while (more) {
                    if (pointerMsg == this.lastMsg) {
                        more = false;
                    }
                    if (pointerMsg != this.currentUnlockedMessage) {
                        if (pointerMsg.isStored) {
                            try {
                                this.unlockMessage(pointerMsg.message, true);
                            }
                            catch (SIMPMessageNotLockedException e) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:2229:1.154.3.1", e});
                                messageHandles[notLockedExceptionMessageIndex] = pointerMsg.getJsMessage().getMessageHandle();
                                ++notLockedExceptionMessageIndex;
                                if (notLockedException == null) {
                                    notLockedException = e;
                                }
                            }
                            catch (SISessionDroppedException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.unlockAll", (String)"1:2243:1.154.3.1", (Object)this);
                                if (!closingSession) {
                                    this.handleSessionDroppedException(e);
                                }
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.unlockAll", "1:2255:1.154.3.1", e});
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)((Object)e));
                                }
                                throw e;
                            }
                        }
                        ++unlockedMessages;
                    }
                    removedMsg = pointerMsg;
                    pointerMsg = pointerMsg.next;
                    this.removeMessage(removedMsg);
                }
                this.currentUnlockedMessage = null;
            }
        }
        if (unlockedMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(unlockedMessages);
        }
        if (notLockedException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)this);
            }
            throw notLockedException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)this);
        }
    }

    abstract void handleSessionDroppedException(SISessionDroppedException var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void unlockAllUnread() throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && AbstractLockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)AbstractLockedMessageEnumeration.tc, (String)"unlockAllUnread", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        unlockedMessages = 0;
        var2_2 = this;
        synchronized (var2_2) {
            this.messageAvailable = false;
            if (this.firstMsg != null && !this.endReached) {
                pointerMsg = null;
                pointerMsg = this.currentMsg == null ? this.firstMsg : this.currentMsg.next;
                removedMsg = null;
                more = true;
                ** if (pointerMsg == null) goto lbl31
                while (more) {
                    if (pointerMsg == this.lastMsg) {
                        more = false;
                    }
                    if (pointerMsg != this.currentUnlockedMessage) {
                        if (TraceComponent.isAnyTracingEnabled() && AbstractLockedMessageEnumeration.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)AbstractLockedMessageEnumeration.tc, (String)("Unlocking Message " + pointerMsg));
                        }
                        if (pointerMsg.isStored) {
                            try {
                                this.unlockMessage(pointerMsg.message, false);
                            }
                            catch (SIMPMessageNotLockedException e) {
                                SibTr.exception((TraceComponent)AbstractLockedMessageEnumeration.tc, (Exception)e);
                            }
                        }
                        ++unlockedMessages;
                    }
                    removedMsg = pointerMsg;
                    pointerMsg = pointerMsg.next;
                    this.removeMessage(removedMsg);
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
lbl31:
            // 4 sources

        }
        if (unlockedMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(unlockedMessages);
        }
        if (TraceComponent.isAnyTracingEnabled() && AbstractLockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)AbstractLockedMessageEnumeration.tc, (String)"unlockAllUnread", (Object)this);
        }
    }

    protected abstract void unlockMessage(JsMessageWrapper var1, boolean var2) throws SIMPMessageNotLockedException, SISessionDroppedException, SIResourceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll(boolean closingSession, boolean incrementUnlockCount) throws SIResourceException, SIMPMessageNotLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{new Integer(this.hashCode()), this, incrementUnlockCount});
        }
        int unlockedMessages = 0;
        SIMPMessageNotLockedException notLockedException = null;
        int notLockedExceptionMessageIndex = 0;
        AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = this;
        synchronized (abstractLockedMessageEnumeration) {
            this.messageAvailable = false;
            if (this.firstMsg != null) {
                LMEMessage pointerMsg = this.firstMsg;
                LMEMessage removedMsg = null;
                SIMessageHandle[] messageHandles = new SIMessageHandle[this.getNumberOfLockedMessages()];
                boolean more = true;
                while (more) {
                    if (pointerMsg == this.lastMsg) {
                        more = false;
                    }
                    if (pointerMsg != this.currentUnlockedMessage) {
                        if (pointerMsg.isStored) {
                            try {
                                this.unlockMessage(pointerMsg.message, incrementUnlockCount);
                            }
                            catch (SIMPMessageNotLockedException e) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration", "1:2228:1.154.1.32", e});
                                messageHandles[notLockedExceptionMessageIndex] = pointerMsg.getJsMessage().getMessageHandle();
                                ++notLockedExceptionMessageIndex;
                                if (notLockedException == null) {
                                    notLockedException = e;
                                }
                            }
                            catch (SISessionDroppedException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.unlockAll", (String)"1:2242:1.154.1.32", (Object)this);
                                if (!closingSession) {
                                    this.handleSessionDroppedException(e);
                                }
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AbstractLockedMessageEnumeration.unlockAll", "1:2254:1.154.1.32", e});
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)((Object)e));
                                }
                                throw e;
                            }
                        }
                        ++unlockedMessages;
                    }
                    removedMsg = pointerMsg;
                    pointerMsg = pointerMsg.next;
                    this.removeMessage(removedMsg);
                }
                this.currentUnlockedMessage = null;
            }
        }
        if (unlockedMessages != 0) {
            this.localConsumerPoint.removeActiveMessages(unlockedMessages);
        }
        if (notLockedException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)this);
            }
            throw notLockedException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)this);
        }
    }

    final class MessageReferenceExpiryAlarm
    implements AlarmListener {
        MessageReferenceExpiryAlarm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this, AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire, object});
            }
            long currentTime = System.currentTimeMillis();
            AbstractLockedMessageEnumeration abstractLockedMessageEnumeration = AbstractLockedMessageEnumeration.this;
            synchronized (abstractLockedMessageEnumeration) {
                while (AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire != null && ((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.expiryMsgReferenceTime <= currentTime) {
                    block13: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Removing the msg refernence on: " + AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire));
                        }
                        try {
                            if (((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.message != null) {
                                ((SIMPMessage)((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.message).releaseJsMessage();
                            }
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                            SibTr.debug((TraceComponent)tc, (String)("Got exception when releasing JsMessage from the message item: " + e));
                        }
                    }
                    ((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.jsMessage = null;
                    AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire = ((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.next;
                }
                if (AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Registering Msg Reference Expiry alarm for: " + AbstractLockedMessageEnumeration.this.nextMsgReferenceToExpire));
                    }
                    AbstractLockedMessageEnumeration.this.alarmManager.create(((AbstractLockedMessageEnumeration)AbstractLockedMessageEnumeration.this).nextMsgReferenceToExpire.expiryMsgReferenceTime - currentTime, this);
                } else {
                    AbstractLockedMessageEnumeration.this.msgReferenceAlarmRegistered = false;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)this);
            }
        }
    }

    final class LMEMessage {
        protected long expiryTime = 0L;
        protected long expiryMsgReferenceTime = 0L;
        protected long id;
        protected boolean isRecoverable;
        protected boolean isStored;
        protected JsMessage jsMessage = null;
        protected boolean lockExpired;
        protected JsMessageWrapper message;
        protected LMEMessage next;
        protected BifurcatedConsumerSessionImpl owner = null;
        protected LMEMessage previous;
        protected SIBUuid8 uuid;
        protected boolean wasRead = false;

        LMEMessage(long key, SIBUuid8 uuid, JsMessageWrapper message, boolean isStored, boolean isRecoverable, long messageLockExpiry, long messageReferenceExpiry) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"LMEMessage", (Object)new Object[]{key, uuid, message, isStored, isRecoverable, messageLockExpiry, messageReferenceExpiry});
            }
            this.message = message;
            this.id = key;
            this.uuid = uuid;
            this.isStored = isStored;
            this.isRecoverable = isRecoverable;
            this.lockExpired = false;
            if (messageLockExpiry != 0L && isRecoverable) {
                this.expiryTime = System.currentTimeMillis() + messageLockExpiry;
            }
            if (messageReferenceExpiry != 0L) {
                this.expiryMsgReferenceTime = System.currentTimeMillis() + messageReferenceExpiry;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LMEMessage", (Object)this);
            }
        }

        public JsMessage getJsMessage() throws SIResourceException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
            }
            if (this.jsMessage == null) {
                this.jsMessage = this.message.getMessage();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)this.jsMessage);
            }
            return this.jsMessage;
        }

        public void reuseMessage(long key, SIBUuid8 uuid, JsMessageWrapper message, boolean isStored, boolean isRecoverable, long messageLockExpiry, long messageReferenceExpiry) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"reuseMessage", (Object)new Object[]{new Long(key), uuid, message, new Boolean(isStored), new Boolean(isRecoverable), new Long(messageLockExpiry), new Long(messageReferenceExpiry)});
            }
            this.message = message;
            this.wasRead = false;
            this.jsMessage = null;
            this.id = key;
            this.uuid = uuid;
            this.isStored = isStored;
            this.isRecoverable = isRecoverable;
            this.lockExpired = false;
            if (messageLockExpiry != 0L && isRecoverable) {
                this.expiryTime = System.currentTimeMillis() + messageLockExpiry;
            }
            if (messageReferenceExpiry != 0L) {
                this.expiryMsgReferenceTime = System.currentTimeMillis() + messageReferenceExpiry;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reuseMessage", (Object)this);
            }
        }

        public String toString() {
            return "Key:" + this.uuid + "_" + this.id + " Str:" + this.isStored + " Rec:" + this.isRecoverable + " ExpTime:" + this.expiryTime + " MessageRefExpTime:" + this.expiryMsgReferenceTime + " LckExp:" + this.lockExpired + " Owner:" + (this.owner != null ? this.owner.hashCode() : 0) + " Msg:" + this.message + "\n";
        }
    }
}

