/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveEntryNotFoundException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveIOException;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveInvalidEntryException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManifestInfo {
    private static final String APPLIES_TO = "Applies-To";
    private static final String REQUIRE_FEATURE = "Require-Feature";
    private static final String PROVIDER = "Bundle-Vendor";
    private static final String SAMPLE_TYPE = "Sample-Type";
    private static final String SAMPLE_TYPE_PRODUCT = "product";
    private static final String SAMPLE_TYPE_OPENSOURCE = "thirdParty";
    private final String _prov;
    private final String _appliesTo;
    private final ResourceType _type;
    private final List<String> _requiresList;
    private final String _archiveRoot;
    private final Manifest _manifest;
    static final long serialVersionUID = 196321796094104283L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ManifestInfo(String prov, String appliesTo, ResourceType type, List<String> requiresList, String archiveRoot, Manifest manifest) {
        this._prov = prov;
        this._appliesTo = appliesTo;
        this._type = type;
        this._requiresList = requiresList;
        this._archiveRoot = archiveRoot;
        this._manifest = manifest;
    }

    public String getProviderName() {
        return this._prov;
    }

    public String getAppliesTo() {
        return this._appliesTo;
    }

    public ResourceType getType() {
        return this._type;
    }

    public List<String> getRequiredFeature() {
        return this._requiresList;
    }

    public String getArchiveRoot() {
        return this._archiveRoot;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ManifestInfo parseManifest(JarFile jar) throws RepositoryArchiveException, RepositoryArchiveIOException {
        String prov = null;
        Manifest mf = null;
        try {
            mf = jar.getManifest();
        }
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.repository.parsers.internal.ManifestInfo", (String)"139", null, (Object[])new Object[]{jar});
                throw new RepositoryArchiveIOException("Unable to access manifest in sample", new File(jar.getName()), e);
            }
            catch (Throwable throwable) {
                try {
                    jar.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.internal.ManifestInfo", (String)"144", null, (Object[])new Object[]{jar});
                    throw new RepositoryArchiveIOException("Unable to access manifest in sample", new File(jar.getName()), (Throwable)e2);
                }
            }
        }
        try {
            jar.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.parsers.internal.ManifestInfo", (String)"144", null, (Object[])new Object[]{jar});
            throw new RepositoryArchiveIOException("Unable to access manifest in sample", new File(jar.getName()), (Throwable)e);
        }
        if (null == mf) {
            throw new RepositoryArchiveEntryNotFoundException("No manifest file found in sample", new File(jar.getName()), "/META-INF/MANIFEST.MF");
        }
        String appliesTo = null;
        ResourceType type = null;
        ArrayList<String> requiresList = new ArrayList<String>();
        Attributes mainattrs = mf.getMainAttributes();
        for (Object at : mainattrs.keySet()) {
            String attribName = ((Attributes.Name)at).toString();
            String attribValue = (String)mainattrs.get(at);
            if (APPLIES_TO.equals(attribName)) {
                appliesTo = attribValue;
                continue;
            }
            if (SAMPLE_TYPE.equals(attribName)) {
                String typeString = (String)mainattrs.get(at);
                if (SAMPLE_TYPE_OPENSOURCE.equals(typeString)) {
                    type = ResourceType.OPENSOURCE;
                    continue;
                }
                if (!SAMPLE_TYPE_PRODUCT.equals(typeString)) throw new IllegalArgumentException("The following jar file is not a known sample type " + jar.getName());
                type = ResourceType.PRODUCTSAMPLE;
                continue;
            }
            if (REQUIRE_FEATURE.equals(attribName)) {
                StringTokenizer featuresTokenizer = new StringTokenizer(attribValue, ",");
                while (featuresTokenizer.hasMoreElements()) {
                    String nextFeature = (String)featuresTokenizer.nextElement();
                    requiresList.add(nextFeature);
                }
                continue;
            }
            if (!PROVIDER.equals(attribName)) continue;
            prov = attribValue;
        }
        if (null == prov) {
            throw new RepositoryArchiveInvalidEntryException("No Bundle-Vendor specified in the sample's manifest", new File(jar.getName()), "/META-INF/MANIFEST.MF");
        }
        if (null == type) {
            throw new RepositoryArchiveInvalidEntryException("No Sample-Type specified in the sample's manifest", new File(jar.getName()), "/META-INF/MANIFEST.MF");
        }
        String archiveRoot = mainattrs.getValue("Archive-Root");
        archiveRoot = archiveRoot != null ? archiveRoot : "";
        return new ManifestInfo(prov, appliesTo, type, requiresList, archiveRoot, mf);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestInfo", ManifestInfo.class, null, null);
    }
}

