/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.audit;

import com.ibm.oauth.core.api.audit.OAuthAuditEntry;
import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class XMLFileOAuthAuditHandler
implements OAuthAuditHandler {
    static final String CLASS = XMLFileOAuthAuditHandler.class.getName();
    static final String CLOSING_TAG = "</entries>";
    static final Logger _log = Logger.getLogger(CLASS);
    public static final String FILENAME = "xmlFileAuditHandler.filename";
    static final String TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.getProperty("line.separator") + "<entries xmlns=\"http://www.ibm.com/oauth/audit\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/oauth/audit oauthAudit.xsd\">" + System.getProperty("line.separator") + "</entries>";
    private boolean _initialized = false;
    private RandomAccessFile _raf = null;
    private long _pos = 0L;
    private Document _document;
    private LSSerializer _serializer;

    @Override
    public void init(OAuthComponentConfiguration config) {
        String filename = config.getConfigPropertyValue(FILENAME);
        if (filename != null) {
            File actualFile = new File(filename);
            if (!actualFile.exists()) {
                try {
                    this.createFile(actualFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    _log.warning("Fail to create XML audit file, audit handler disabled.");
                    return;
                }
            }
            try {
                this._raf = new RandomAccessFile(actualFile, "rw");
                this._pos = this.positionClosingTag();
                this._raf.seek(this._pos);
            }
            catch (IOException e) {
                e.printStackTrace();
                _log.warning("Fail to seek the closing tag in XML audit file, audit handler disabled.");
                return;
            }
            try {
                this.initXMLSerializer();
            }
            catch (Exception e) {
                e.printStackTrace();
                _log.warning("Fail to initialize XML serializer, audit handler disabled.");
                return;
            }
            this._initialized = true;
        } else {
            _log.warning("xmlFileAuditHandler.filename config is null, audit handler disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEntry(OAuthAuditEntry entry) throws OAuth20Exception {
        if (this._initialized) {
            String xmlFrag = this._serializer.writeToString(entry.toXML(this._document)) + "\n";
            XMLFileOAuthAuditHandler xMLFileOAuthAuditHandler = this;
            synchronized (xMLFileOAuthAuditHandler) {
                try {
                    byte[] data = Base64Coder.getBytes((String)xmlFrag);
                    this._raf.write(data);
                    this._raf.write(Base64Coder.getBytes((String)CLOSING_TAG));
                    this._pos += (long)data.length;
                    this._raf.seek(this._pos);
                }
                catch (IOException e) {
                    _log.log(Level.SEVERE, "Fail to write audit entry", e);
                }
            }
        }
    }

    private void initXMLSerializer() throws Exception {
        DOMImplementationRegistry reg = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)reg.getDOMImplementation("LS"));
        LSParser parser = impl.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        LSInput input = impl.createLSInput();
        ByteArrayInputStream is = new ByteArrayInputStream(Base64Coder.getBytes((String)TEMPLATE));
        input.setByteStream(is);
        this._document = parser.parse(input);
        this._serializer = impl.createLSSerializer();
        this._serializer.getDomConfig().setParameter("format-pretty-print", true);
        this._serializer.getDomConfig().setParameter("xml-declaration", false);
    }

    private void createFile(File actualFile) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(actualFile));
        ByteArrayInputStream is = new ByteArrayInputStream(Base64Coder.getBytes((String)TEMPLATE));
        byte[] buf = new byte[1024];
        int count = 0;
        while ((count = is.read(buf)) != -1) {
            ((OutputStream)os).write(buf, 0, count);
        }
        is.close();
        ((OutputStream)os).close();
    }

    private long positionClosingTag() throws IOException {
        long start;
        byte[] closingTag = Base64Coder.getBytes((String)CLOSING_TAG);
        long pos = this._raf.length();
        int trunk = 4096;
        byte[] content = null;
        do {
            start = pos - (long)trunk < 0L ? 0L : pos - (long)trunk;
            int len = (int)(pos - start);
            int remain = 0;
            if (content != null) {
                remain = content.length > closingTag.length ? closingTag.length : content.length;
            }
            this._raf.seek(start);
            byte[] temp = new byte[len + remain];
            for (int count = 0; count < len; count += this._raf.read(temp, count, len - count)) {
            }
            if (remain > 0) {
                System.arraycopy(content, 0, temp, len, remain);
            }
            content = temp;
            for (int i = len += remain; i >= closingTag.length; --i) {
                for (int j = 1; j <= closingTag.length && content[i - j] == closingTag[closingTag.length - j]; ++j) {
                    if (j != closingTag.length) continue;
                    return start + (long)i - (long)closingTag.length;
                }
            }
        } while ((pos = start) > 0L);
        return this._raf.length();
    }
}

