/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.PublicApi;
import graphql.analysis.QueryDepthInfo;
import graphql.analysis.QueryTraverser;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.validation.ValidationError;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class MaxQueryDepthInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MaxQueryDepthInstrumentation.class);
    private final int maxDepth;
    private final Function<QueryDepthInfo, Boolean> maxQueryDepthExceededFunction;

    public MaxQueryDepthInstrumentation(int maxDepth) {
        this(maxDepth, queryDepthInfo -> true);
    }

    public MaxQueryDepthInstrumentation(int maxDepth, Function<QueryDepthInfo, Boolean> maxQueryDepthExceededFunction) {
        this.maxDepth = maxDepth;
        this.maxQueryDepthExceededFunction = maxQueryDepthExceededFunction;
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return SimpleInstrumentationContext.whenCompleted((errors, throwable) -> {
            QueryDepthInfo queryDepthInfo;
            boolean throwAbortException;
            if (errors != null && errors.size() > 0 || throwable != null) {
                return;
            }
            QueryTraverser queryTraverser = this.newQueryTraverser(parameters);
            int depth = queryTraverser.reducePreOrder((env, acc) -> Math.max(this.getPathLength(env.getParentEnvironment()), acc), 0);
            log.debug("Query depth info: {}", (Object)depth);
            if (depth > this.maxDepth && (throwAbortException = this.maxQueryDepthExceededFunction.apply(queryDepthInfo = QueryDepthInfo.newQueryDepthInfo().depth(depth).build()).booleanValue())) {
                throw this.mkAbortException(depth, this.maxDepth);
            }
        });
    }

    protected AbortExecutionException mkAbortException(int depth, int maxDepth) {
        return new AbortExecutionException("maximum query depth exceeded " + depth + " > " + maxDepth);
    }

    QueryTraverser newQueryTraverser(InstrumentationValidationParameters parameters) {
        return QueryTraverser.newQueryTraverser().schema(parameters.getSchema()).document(parameters.getDocument()).operationName(parameters.getOperation()).variables(parameters.getVariables()).build();
    }

    private int getPathLength(QueryVisitorFieldEnvironment path) {
        int length = 1;
        while (path != null) {
            path = path.getParentEnvironment();
            ++length;
        }
        return length;
    }
}

