/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.DeferredRollbackException;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkList;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XidParticipant
implements TransactionParticipant {
    private static TraceComponent tc = SibTr.register(XidParticipant.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final TransactionStateLock _stateLock = new TransactionStateLock();
    private TransactionState _state = TransactionState.STATE_ACTIVE;
    private boolean _rollbackChanges = false;
    private boolean _indoubt = false;
    private TransactionState _preCommitSubstate = TransactionState.STATE_NONE;
    private PersistentTranId _ptid;
    private WorkList _workList;
    private final List<TransactionCallback> _callbacks = Collections.synchronizedList(new ArrayList(5));
    private MessageStoreImpl _ms;
    private PersistenceManager _persistence;
    private int _maxSize;
    private int _size = 0;
    private BatchingContext _bc;

    public XidParticipant(MessageStoreImpl ms, PersistentTranId ptid, PersistenceManager persistence, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"MessageStore=" + (Object)((Object)ms), "PersistentTranId=" + ptid, "Persistence=" + persistence, "MaxSize=" + maxSize});
        }
        this._ms = ms;
        this._ptid = ptid;
        this._persistence = persistence;
        this._maxSize = maxSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public XidParticipant(MessageStoreImpl ms, PersistentTranId ptid, PersistenceManager persistence, int maxSize, TransactionState state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"MessageStore=" + (Object)((Object)ms), "PersistentTranId=" + ptid, "Persistence=" + persistence, "State=" + this._state});
        }
        this._ms = ms;
        this._ptid = ptid;
        this._persistence = persistence;
        this._state = state;
        this._maxSize = maxSize;
        if (this._state == TransactionState.STATE_PREPARED) {
            this._rollbackChanges = true;
            this._indoubt = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public boolean hasSubordinates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasSubordinates");
        }
        boolean retval = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasSubordinates", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addWork(WorkItem item) throws ProtocolException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + item));
        }
        TransactionStateLock transactionStateLock = this._stateLock;
        synchronized (transactionStateLock) {
            if (this._state != TransactionState.STATE_ACTIVE && !this._indoubt) {
                ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
                }
                throw pe;
            }
        }
        if (this._workList == null) {
            this._workList = new TaskList();
        }
        if (item == null) {
            ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            }
            throw pe;
        }
        this._workList.addWork(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
        }
    }

    @Override
    public WorkList getWorkList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWorkList", (Object)("return=" + this._workList));
        }
        return this._workList;
    }

    public void registerCallback(TransactionCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + callback));
        }
        this._callbacks.add(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerCallback");
        }
    }

    public boolean isAutoCommit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public PersistentTranId getPersistentTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentTranId");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws SIResourceException {
        if (++this._size > this._maxSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new SIResourceException((Throwable)new TransactionMaxSizeExceededException());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        boolean retval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAlive");
        }
        TransactionStateLock transactionStateLock = this._stateLock;
        synchronized (transactionStateLock) {
            retval = this._state == TransactionState.STATE_ACTIVE || this._indoubt;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAlive", (Object)("return=" + retval));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare() throws ProtocolException, RollbackException, SeverePersistenceException, TransactionException {
        block41: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            TransactionStateLock transactionStateLock = this._stateLock;
            synchronized (transactionStateLock) {
                if (this._state != TransactionState.STATE_ACTIVE) {
                    ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot prepare Transaction. Transaction is complete or completing!", (Object)((Object)pe));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
                    }
                    throw pe;
                }
                this._preCommitSubstate = TransactionState.STATE_PREPARING;
            }
            try {
                for (int i = 0; i < this._callbacks.size(); ++i) {
                    TransactionCallback callback = this._callbacks.get(i);
                    callback.beforeCompletion((TransactionCommon)this);
                }
                if (this._workList != null) {
                    this._workList.preCommit(this);
                    TransactionStateLock i = this._stateLock;
                    synchronized (i) {
                        this._state = TransactionState.STATE_PREPARING;
                    }
                    this._rollbackChanges = true;
                    this._persistence.prepare(this);
                    i = this._stateLock;
                    synchronized (i) {
                        if (this._preCommitSubstate == TransactionState.STATE_ROLLBACK_DEFERRED) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.event((Object)this, (TraceComponent)tc, (String)("Deferred rollback requested during prepare for TranId: " + this._ptid));
                            }
                            throw new DeferredRollbackException();
                        }
                        this._state = this._preCommitSubstate = TransactionState.STATE_PREPARED;
                        break block41;
                    }
                }
                TransactionStateLock i = this._stateLock;
                synchronized (i) {
                    this._state = this._preCommitSubstate = TransactionState.STATE_PREPARED;
                }
            }
            catch (SeverePersistenceException spe) {
                FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.prepare", (String)"1:420:1.73", (Object)this);
                if (this._ms != null) {
                    this._ms.reportLocalError();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unrecoverable persistence exception caught during prepare phase of transaction!", (Object)((Object)spe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)((Object)spe));
                }
                throw spe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.prepare", (String)"1:436:1.73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction will roll-back due to Exception in prepare!", (Object)e);
                }
                TransactionStateLock callback = this._stateLock;
                synchronized (callback) {
                    this._preCommitSubstate = TransactionState.STATE_ROLLINGBACK;
                }
                try {
                    this.rollback(true);
                }
                catch (Exception e2) {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.prepare", (String)"1:466:1.73", (Object)this);
                    TransactionStateLock transactionStateLock2 = this._stateLock;
                    synchronized (transactionStateLock2) {
                        this._state = this._preCommitSubstate = TransactionState.STATE_ROLLBACK_EXPECTED;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("Exception caught rolling-back transaction after preCommit failure! " + e2));
                    }
                    throw new TransactionException((Throwable)e2);
                }
                TransactionStateLock e2 = this._stateLock;
                synchronized (e2) {
                    this._state = this._preCommitSubstate = TransactionState.STATE_ROLLEDBACK;
                }
                RollbackException re = new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{e}, (Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)((Object)re));
                }
                throw re;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)"return=0");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void commit(boolean onePhase) throws ProtocolException, RollbackException, SeverePersistenceException, TransactionException, PersistenceException {
        block56: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object)("onePhase=" + onePhase));
            }
            TransactionStateLock transactionStateLock = this._stateLock;
            // MONITORENTER : transactionStateLock
            if (this._state == TransactionState.STATE_COMMITTED || this._state == TransactionState.STATE_ROLLEDBACK) {
                ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot commit Transaction. Transaction is already complete!", (Object)((Object)pe));
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw pe;
                if (!tc.isEntryEnabled()) throw pe;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                throw pe;
            }
            if (!onePhase && this._state != TransactionState.STATE_PREPARED) {
                ProtocolException pe = new ProtocolException("XA_PROTOCOL_ERROR_SIMS1000", new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot commit Transaction. Transaction has not been prepared!", (Object)((Object)pe));
                }
                if (!TraceComponent.isAnyTracingEnabled()) throw pe;
                if (!tc.isEntryEnabled()) throw pe;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                throw pe;
            }
            if (onePhase) {
                this._preCommitSubstate = TransactionState.STATE_PREPARING;
            } else {
                this._state = TransactionState.STATE_COMMITTING_2PC;
            }
            // MONITOREXIT : transactionStateLock
            try {
                TransactionStateLock callback;
                if (onePhase) {
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        callback = this._callbacks.get(i);
                        callback.beforeCompletion((TransactionCommon)this);
                    }
                    if (this._workList != null) {
                        this._workList.preCommit(this);
                    }
                    TransactionStateLock i = this._stateLock;
                    // MONITORENTER : i
                    this._state = TransactionState.STATE_COMMITTING_1PC;
                    if (this._preCommitSubstate == TransactionState.STATE_ROLLBACK_DEFERRED) {
                        if (!TraceComponent.isAnyTracingEnabled()) throw new DeferredRollbackException();
                        if (!tc.isDebugEnabled()) throw new DeferredRollbackException();
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("Deferred rollback requested during preCommit for TranId: " + this._ptid));
                        throw new DeferredRollbackException();
                    }
                    // MONITOREXIT : i
                }
                callback = this._stateLock;
                // MONITORENTER : callback
                boolean indoubt = this._indoubt;
                // MONITOREXIT : callback
                if (this._workList != null) {
                    this._persistence.commit(this, onePhase);
                    this._workList.commit(this);
                } else if (this._workList == null && indoubt) {
                    this._persistence.commit(this, onePhase);
                }
                if (indoubt && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt transaction completed successfully. TranId=" + this._ptid));
                }
                callback = this._stateLock;
                // MONITORENTER : callback
                this._state = TransactionState.STATE_COMMITTED;
                if (onePhase) {
                    this._preCommitSubstate = TransactionState.STATE_PREPARED;
                }
                // MONITOREXIT : callback
                callback = this._stateLock;
            }
            catch (SeverePersistenceException spe) {
                try {
                    FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"1:636:1.73", (Object)this);
                    if (this._ms != null) {
                        this._ms.reportLocalError();
                    }
                    if (!TraceComponent.isAnyTracingEnabled()) throw spe;
                    if (!tc.isEventEnabled()) throw spe;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)spe));
                    throw spe;
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"1:651:1.73", (Object)this);
                        if (onePhase) {
                            block57: {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction will rollback due to exception in commit!", (Object)e);
                                }
                                TransactionStateLock committed = this._stateLock;
                                // MONITORENTER : committed
                                this._preCommitSubstate = TransactionState.STATE_ROLLINGBACK;
                                // MONITOREXIT : committed
                                try {
                                    if (this._workList != null) {
                                        this._workList.rollback(this);
                                    }
                                }
                                catch (Exception e2) {
                                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.msgstore.transactions.XIDParticipant.commit", (String)"1:683:1.73", (Object)this);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block57;
                                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught rolling-back transaction after commit failure!", (Object)e2);
                                }
                            }
                            TransactionStateLock e2 = this._stateLock;
                            // MONITORENTER : e2
                            this._state = this._preCommitSubstate = TransactionState.STATE_ROLLEDBACK;
                            // MONITOREXIT : e2
                            RollbackException re = new RollbackException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{e}, (Throwable)e);
                            throw re;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)"Transaction will be reset for retry due to exception in commit!", (Object)e);
                        }
                        TransactionStateLock transactionStateLock2 = this._stateLock;
                        // MONITORENTER : transactionStateLock2
                        this._state = TransactionState.STATE_PREPARED;
                        // MONITOREXIT : transactionStateLock2
                        if (!(e instanceof PersistenceException)) throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{e}, (Throwable)e);
                        throw (PersistenceException)((Object)e);
                    }
                }
                catch (Throwable throwable) {
                    block58: {
                        TransactionStateLock transactionStateLock3 = this._stateLock;
                        // MONITORENTER : transactionStateLock3
                        TransactionState state = this._state;
                        // MONITOREXIT : transactionStateLock3
                        if (state != TransactionState.STATE_PREPARED) {
                            boolean committed = state == TransactionState.STATE_COMMITTED;
                            try {
                                if (this._workList != null) {
                                    this._workList.postComplete(this, committed);
                                }
                                for (int i = 0; i < this._callbacks.size(); ++i) {
                                    TransactionCallback callback = this._callbacks.get(i);
                                    callback.afterCompletion((TransactionCommon)this, committed);
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"1:761:1.73", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block58;
                                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)e);
                            }
                        }
                    }
                    if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                    if (!tc.isEntryEnabled()) throw throwable;
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
                    throw throwable;
                }
            }
            // MONITORENTER : callback
            TransactionState state = this._state;
            // MONITOREXIT : callback
            if (state != TransactionState.STATE_PREPARED) {
                boolean committed = state == TransactionState.STATE_COMMITTED;
                try {
                    if (this._workList != null) {
                        this._workList.postComplete(this, committed);
                    }
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        TransactionCallback callback = this._callbacks.get(i);
                        callback.afterCompletion((TransactionCommon)this, committed);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"1:761:1.73", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block56;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)e);
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        return;
    }

    @Override
    public void rollback() throws ProtocolException, SeverePersistenceException, TransactionException, PersistenceException {
        this.rollback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(boolean internal) throws ProtocolException, SeverePersistenceException, TransactionException, PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)("internal=" + internal));
        }
        TransactionStateLock transactionStateLock = this._stateLock;
        synchronized (transactionStateLock) {
            if (!(internal || this._state == TransactionState.STATE_ROLLBACK_EXPECTED || this._state != TransactionState.STATE_COMMITTED && this._state != TransactionState.STATE_ROLLEDBACK && this._state != TransactionState.STATE_COMMITTING_1PC && this._state != TransactionState.STATE_COMMITTING_2PC && this._preCommitSubstate != TransactionState.STATE_ROLLBACK_DEFERRED && this._preCommitSubstate != TransactionState.STATE_ROLLINGBACK)) {
                ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Cannot rollback Transaction. Transaction is not in a valid state: _state=" + this._state + ", _preCommitSubstate=" + this._preCommitSubstate), (Object)((Object)pe));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
                }
                throw pe;
            }
            if (this._preCommitSubstate == TransactionState.STATE_PREPARING) {
                this._preCommitSubstate = TransactionState.STATE_ROLLBACK_DEFERRED;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Deferred rollback request accepted for TranId: " + this._ptid));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"STATE_ROLLBACK_DEFERRED");
                }
                return;
            }
            this._state = TransactionState.STATE_ROLLINGBACK;
        }
        try {
            boolean indoubt;
            boolean rollbackChanges;
            TransactionStateLock transactionStateLock2 = this._stateLock;
            synchronized (transactionStateLock2) {
                rollbackChanges = this._rollbackChanges;
                indoubt = this._indoubt;
            }
            if (this._workList != null) {
                if (rollbackChanges) {
                    this._persistence.rollback(this);
                }
                this._workList.rollback(this);
            } else if (this._workList == null && indoubt) {
                this._persistence.rollback(this);
            }
            if (indoubt && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Indoubt transaction completed successfully. TranId=" + this._ptid));
            }
            transactionStateLock2 = this._stateLock;
            synchronized (transactionStateLock2) {
                this._state = TransactionState.STATE_ROLLEDBACK;
            }
        }
        catch (SeverePersistenceException spe) {
            FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"1:896:1.73", (Object)this);
            if (this._ms != null) {
                this._ms.reportLocalError();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unrecoverable persistence exception caught during rollback phase of transaction!", (Object)((Object)spe));
            }
            throw spe;
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"1:910:1.73", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Persistence exception caught during rollback phase of transaction!", (Object)((Object)pe));
            }
            throw pe;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.rollback", (String)"1:918:1.73", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught during rollback phase of transaction!", (Object)e);
            }
            throw new TransactionException("COMPLETION_EXCEPTION_SIMS1002", new Object[]{e}, (Throwable)e);
        }
        finally {
            block47: {
                TransactionState state;
                TransactionStateLock transactionStateLock3 = this._stateLock;
                synchronized (transactionStateLock3) {
                    state = this._state;
                }
                if (state == TransactionState.STATE_ROLLEDBACK) {
                    try {
                        if (this._workList != null) {
                            this._workList.postComplete(this, false);
                        }
                        for (int i = 0; i < this._callbacks.size(); ++i) {
                            TransactionCallback callback = this._callbacks.get(i);
                            callback.afterCompletion((TransactionCommon)this, false);
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.XidParticipant.commit", (String)"1:951:1.73", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block47;
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught during post commit phase of transaction!", (Object)e);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
        }
    }

    @Override
    public String toXmlString() {
        StringBuffer retval = new StringBuffer();
        retval.append("<transaction>\n");
        retval.append("<type>GLOBAL</type>\n");
        retval.append("<xid>");
        retval.append(this._ptid);
        retval.append("</xid>\n");
        retval.append("<state>");
        retval.append(this._state);
        retval.append("</state>\n");
        retval.append("<size>");
        retval.append(this._size);
        retval.append("</size>\n");
        retval.append("<max-size>");
        retval.append(this._maxSize);
        retval.append("</max-size>\n");
        if (this._workList != null) {
            retval.append(this._workList.toXmlString());
        }
        retval.append("</transaction>\n");
        return retval.toString();
    }

    @Override
    public final int getTransactionType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_GLOBAL");
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionState(TransactionState state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionState", (Object)("State=" + state));
        }
        TransactionStateLock transactionStateLock = this._stateLock;
        synchronized (transactionStateLock) {
            this._state = state;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionState getTransactionState() {
        TransactionStateLock transactionStateLock = this._stateLock;
        synchronized (transactionStateLock) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionState");
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionState", (Object)("return=" + this._state));
            }
            return this._state;
        }
    }

    @Override
    public BatchingContext getBatchingContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    @Override
    public void setBatchingContext(BatchingContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + bc));
        }
        this._bc = bc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBatchingContext");
        }
    }

    @Override
    public MessageStore getOwningMessageStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore", (Object)("return=" + (Object)((Object)this._ms)));
        }
        return this._ms;
    }

    private static class TransactionStateLock {
        private TransactionStateLock() {
        }
    }
}

