/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RawDataDumper
implements XmlConstants {
    private final PersistentMessageStore _persistentMessageStore;
    private final HashMap _tupleMap = new HashMap();
    private final FormattedWriter _writer;
    private final boolean _callbackToItem;

    public RawDataDumper(PersistentMessageStore persistentMessageStore, FormattedWriter writer) {
        this(persistentMessageStore, writer, false);
    }

    public RawDataDumper(PersistentMessageStore persistentMessageStore, FormattedWriter writer, boolean callbackToItem) {
        this._persistentMessageStore = persistentMessageStore;
        this._writer = writer;
        this._callbackToItem = callbackToItem;
    }

    private final void _buildTupleMap(PersistentMessageStore pm) throws PersistenceException {
        List list = pm.readAllStreams();
        for (Persistable tuple : list) {
            long parent = tuple.getContainingStreamId();
            Long key = parent;
            ArrayList<Persistable> siblings = (ArrayList<Persistable>)this._tupleMap.get(key);
            if (null == siblings) {
                siblings = new ArrayList<Persistable>();
                this._tupleMap.put(key, siblings);
            }
            siblings.add(tuple);
        }
    }

    private final void _startTag(String tagName, Persistable persistable) throws IOException {
        this._writer.write(60);
        this._writer.write(this._writer.getNameSpace());
        this._writer.write(tagName);
        this._writer.write(32);
        this._writer.write("id");
        this._writer.write("=\"");
        this._writer.write(Long.toString(persistable.getUniqueId()));
        this._writer.write("\" >");
    }

    private final void _writeCallback(Persistable persistable) throws IOException {
        if (this._callbackToItem) {
            try {
                String className = persistable.getItemClassName();
                AbstractItem item = (AbstractItem)Class.forName(className).newInstance();
                List<DataSlice> dataSlices = this._persistentMessageStore.readDataOnly(persistable);
                if (dataSlices != null) {
                    item.restore(dataSlices);
                    item.xmlWriteOn(this._writer);
                }
            }
            catch (IOException ioexc) {
                this._writer.write((Throwable)ioexc);
                throw ioexc;
            }
            catch (Throwable t) {
                this._writer.write(t);
            }
        }
    }

    private final void _writeItem(Persistable persistable) throws IOException {
        this._startTag("item", persistable);
        this._writer.indent();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("item");
    }

    private final void _writeItemReference(Persistable persistable) throws IOException {
        this._startTag("reference", persistable);
        this._writer.indent();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("reference");
    }

    private final void _writeItemStream(Persistable persistable) throws IOException {
        this._startTag("itemStream", persistable);
        this._writer.indent();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.newLine();
        ArrayList childStreamTuples = (ArrayList)this._tupleMap.remove(persistable.getUniqueId());
        this._writer.startTag("itemStreams");
        this._writer.indent();
        if (null != childStreamTuples) {
            for (Persistable tuple : childStreamTuples) {
                if (tuple.getTupleType() != TupleTypeEnum.ITEM_STREAM) continue;
                this._writer.newLine();
                this._writeItemStream(tuple);
                this._writer.flush();
            }
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("itemStreams");
        this._writer.newLine();
        this._writer.startTag("referenceStreams");
        this._writer.indent();
        if (null != childStreamTuples) {
            for (Persistable tuple : childStreamTuples) {
                if (tuple.getTupleType() != TupleTypeEnum.REFERENCE_STREAM) continue;
                this._writer.newLine();
                this._writeReferenceStream(tuple);
                this._writer.flush();
            }
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("referenceStreams");
        this._writer.newLine();
        this._writer.startTag("items");
        this._writer.indent();
        try {
            List list = this._persistentMessageStore.readNonStreamItems(persistable);
            for (Persistable tuple : list) {
                this._writer.newLine();
                this._writeItem(tuple);
                this._writer.flush();
            }
        }
        catch (PersistenceException e) {
            this._writer.write("Exception reading items");
            this._writer.write((Throwable)e);
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("items");
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("itemStream");
    }

    private final void _writeReferenceStream(Persistable persistable) throws IOException {
        this._startTag("referenceStream", persistable);
        this._writer.indent();
        persistable.xmlWrite(this._writer);
        this._writeCallback(persistable);
        this._writer.newLine();
        this._writer.startTag("references");
        this._writer.indent();
        try {
            List list = this._persistentMessageStore.readNonStreamItems(persistable);
            for (Persistable tuple : list) {
                this._writer.newLine();
                this._writeItemReference(tuple);
                this._writer.flush();
            }
        }
        catch (PersistenceException e) {
            this._writer.write("Exception reading items");
            this._writer.write((Throwable)e);
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("references");
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("referenceStream");
    }

    public final void dump() throws IOException {
        this._writer.startTag("MessageStore");
        this._writer.indent();
        try {
            this._writer.newLine();
            this._writer.startTag("itemStreams");
            this._writer.indent();
            try {
                Persistable rootPersistable = this._persistentMessageStore.readRootPersistable();
                this._buildTupleMap(this._persistentMessageStore);
                ArrayList children = (ArrayList)this._tupleMap.remove(rootPersistable.getUniqueId());
                for (int i = 0; null != children && i < children.size(); ++i) {
                    Persistable tuple = (Persistable)children.get(i);
                    this._writer.newLine();
                    this._writeItemStream(tuple);
                    this._writer.flush();
                }
            }
            catch (MessageStoreException e) {
                this._writer.write("Exception reading itemStreams");
                this._writer.write((Throwable)e);
            }
            this._writer.outdent();
            this._writer.newLine();
            this._writer.endTag("itemStreams");
        }
        catch (IOException e) {
            this._writer.write("exception reading root item stream");
            this._writer.write((Throwable)e);
        }
        this._writer.outdent();
        this._writer.newLine();
        this._writer.endTag("MessageStore");
        this._writer.newLine();
        this._writer.flush();
    }
}

