/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.servlet.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionFilter
implements Filter {
    private FilterConfig filterConfig;
    private static final TraceComponent tc = Tr.register(SessionFilter.class);
    private static final String LOGIN_ERROR_PAGE = "/adminCenter/login.jsp?no_access";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String methodName = "doFilter";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            HttpServletRequest httpServletReq = (HttpServletRequest)req;
            HttpServletResponse httpServletResp = (HttpServletResponse)resp;
            HttpSession session = httpServletReq.getSession(false);
            String requestURI = httpServletReq.getRequestURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{requestURI});
            }
            if (requestURI.equals("/adminCenter/j_security_check") && httpServletReq.getMethod().equals("GET")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Session = " + session), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"Redirecting to /adminCenter/login.jsp?no_access", (Object[])new Object[0]);
                }
                httpServletResp.sendRedirect(LOGIN_ERROR_PAGE);
                if (session != null) {
                    session.invalidate();
                }
            }
        }
        chain.doFilter(req, resp);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }
}

