/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.v1.IToolDataService;
import com.ibm.ws.ui.persistence.IPersistenceProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IToolDataService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class PlainTextLoaderService
implements IToolDataService {
    private static final TraceComponent tc = Tr.register(PlainTextLoaderService.class);
    private IPersistenceProvider persistenceProviderFile;
    private IPersistenceProvider persistenceProviderCollective;

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY, target="(com.ibm.ws.ui.persistence.provider=FILE)")
    protected synchronized void setIPersistenceProviderFILE(IPersistenceProvider provider) {
        this.persistenceProviderFile = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"FILE"});
    }

    protected synchronized void unsetIPersistenceProviderFILE(IPersistenceProvider provider) {
        if (this.persistenceProviderFile == provider) {
            this.persistenceProviderFile = null;
        }
    }

    @Reference(service=IPersistenceProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(com.ibm.ws.ui.persistence.provider=COLLECTIVE)")
    protected synchronized void setIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        this.persistenceProviderCollective = provider;
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"COLLECTIVE"});
    }

    protected synchronized void unsetIPersistenceProviderCOLLECTIVE(IPersistenceProvider provider) {
        if (this.persistenceProviderCollective == provider) {
            this.persistenceProviderCollective = null;
        }
        Tr.info((TraceComponent)tc, (String)"STORAGE_INITIALIZED_PLAINTEXT_LOADER", (Object[])new Object[]{"FILE"});
    }

    @Activate
    protected synchronized void activate() {
    }

    @Deactivate
    protected synchronized void deactive() {
    }

    protected synchronized IPersistenceProvider getPersist() {
        if (this.persistenceProviderCollective != null) {
            return this.persistenceProviderCollective;
        }
        return this.persistenceProviderFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolData(String userId, String toolName) {
        String persistedName;
        String string = persistedName = toolName + "/" + userId;
        synchronized (string) {
            if (this.persistenceProviderCollective != null) {
                return this.loadToolDataFromPersistence(this.persistenceProviderCollective, userId, toolName);
            }
            return this.loadToolDataFromPersistence(this.persistenceProviderFile, userId, toolName);
        }
    }

    @FFDCIgnore(value={FileNotFoundException.class})
    private String loadToolDataFromPersistence(IPersistenceProvider persist, String userId, String toolName) {
        try {
            String persistedName = toolName + "/" + userId;
            String toolData = persist.loadPlainText(persistedName);
            Tr.info((TraceComponent)tc, (String)"LOADED_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            return toolData;
        }
        catch (FileNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The persisted tool data is not available. This is an expected code path and is likely fine.\n", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_LOAD_TOOL_DATA_ACCESS", (Object[])new Object[]{userId, toolName});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteToolData(String userId, String toolName) {
        String persistedName;
        boolean deletedFromCollective = true;
        boolean deletedFromFile = true;
        String string = persistedName = toolName + "/" + userId;
        synchronized (string) {
            if (this.persistenceProviderCollective != null) {
                deletedFromCollective = this.deleteToolDataFromPersistence(this.persistenceProviderCollective, userId, toolName);
            }
            if (this.persistenceProviderFile != null) {
                deletedFromFile = this.deleteToolDataFromPersistence(this.persistenceProviderFile, userId, toolName);
            }
        }
        return deletedFromFile && deletedFromCollective;
    }

    @Override
    public String addToolData(String userId, String toolName, String toolData) {
        return this.postAndPutToolDataToPersistence(this.getPersist(), userId, toolName, toolData);
    }

    private boolean deleteToolDataFromPersistence(IPersistenceProvider persist, String userId, String toolName) {
        try {
            String persistedName = toolName + "/" + userId;
            boolean ret = true;
            if (persist != null && persist.exists(persistedName) && (ret = persist.delete(persistedName))) {
                Tr.info((TraceComponent)tc, (String)"DELETED_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            }
            return ret;
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_DELETE_PERSISTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postAndPutToolDataToPersistence(IPersistenceProvider persist, String userId, String toolName, String toolData) {
        try {
            String persistedName;
            String string = persistedName = toolName + "/" + userId;
            synchronized (string) {
                persist.storePlainText(persistedName, toolData);
                Tr.info((TraceComponent)tc, (String)"POSTED_TOOL_DATA", (Object[])new Object[]{userId, toolName});
            }
            return toolData;
        }
        catch (JSONMarshallException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_POST_TOOL_JSON_DATA_CONTENT", (Object[])new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            Tr.error((TraceComponent)tc, (String)"UNABLE_TO_POST_TOOL_DATA_CONTENT", (Object[])new Object[]{userId});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String userId, String toolName) {
        String persistedName;
        String string = persistedName = toolName + "/" + userId;
        synchronized (string) {
            if (this.persistenceProviderCollective != null) {
                return this.persistenceProviderCollective.exists(persistedName);
            }
            return this.persistenceProviderFile.exists(persistedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promoteIfPossible(String userId, String toolName) {
        String persistedName;
        String string = persistedName = toolName + "/" + userId;
        synchronized (string) {
            if (this.persistenceProviderCollective != null && !this.persistenceProviderCollective.exists(persistedName) && this.persistenceProviderFile.exists(persistedName)) {
                try {
                    String s = this.loadToolDataFromPersistence(this.persistenceProviderFile, userId, toolName);
                    if (s != null) {
                        this.persistenceProviderCollective.storePlainText(persistedName, s);
                    }
                }
                catch (IOException e) {
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PROMOTE_TOOL_DATA_CONTENT", (Object[])new Object[]{userId, toolName});
                }
                catch (JSONMarshallException e) {
                    Tr.error((TraceComponent)tc, (String)"UNABLE_TO_PROMOTE_TOOL_JSON_DATA_CONTENT", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }
}

