/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.configuration;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxRsClientProxyInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientProxyInterceptor.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
    static final long serialVersionUID = -7438741561066834468L;

    @Trivial
    private static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            Object o2 = ((List)o).get(0);
            o = o2;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public LibertyJaxRsClientProxyInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        String sHost;
        String host = LibertyJaxRsClientProxyInterceptor.toString(message.get((Object)"com.ibm.ws.jaxrs.client.proxy.host"));
        String port = LibertyJaxRsClientProxyInterceptor.toString(message.get((Object)"com.ibm.ws.jaxrs.client.proxy.port"));
        String type = LibertyJaxRsClientProxyInterceptor.toString(message.get((Object)"com.ibm.ws.jaxrs.client.proxy.type"));
        String proxyAuthType = LibertyJaxRsClientProxyInterceptor.toString(message.get((Object)"com.ibm.ws.jaxrs.client.proxy.authType"));
        String proxyAuthUser = LibertyJaxRsClientProxyInterceptor.toString(message.get((Object)"com.ibm.ws.jaxrs.client.proxy.username"));
        ProtectedString proxyAuthPW = (ProtectedString)message.get((Object)"com.ibm.ws.jaxrs.client.proxy.password");
        Conduit conduit = message.getExchange().getConduit(message);
        if (host != null && !(sHost = host.toString()).isEmpty() && conduit instanceof HTTPConduit) {
            this.configClientProxy((HTTPConduit)conduit, sHost, port, type, proxyAuthType, proxyAuthUser, proxyAuthPW);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchMethodError.class, Exception.class, Exception.class})
    private void configClientProxy(HTTPConduit httpConduit, String host, String port, String type, String proxyAuthType, String proxyAuthUser, ProtectedString proxyAuthPW) {
        HTTPClientPolicy clientPolicy;
        ProxyServerType proxyServerType;
        block25: {
            int iPort = 80;
            if (port != null) {
                try {
                    iPort = Integer.parseInt(port);
                }
                catch (NumberFormatException numberFormatException) {
                    void e;
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor", (String)"125", (Object)((Object)this), (Object[])new Object[]{httpConduit, host, port, type, proxyAuthType, proxyAuthUser, proxyAuthPW});
                    Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.proxy.portinvalid", (Object[])new Object[]{port, "com.ibm.ws.jaxrs.client.proxy.port", 80, e.getMessage()});
                }
            }
            proxyServerType = ProxyServerType.HTTP;
            if (type != null) {
                try {
                    proxyServerType = ProxyServerType.valueOf((String)type.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    void e;
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor", (String)"137", (Object)((Object)this), (Object[])new Object[]{httpConduit, host, port, type, proxyAuthType, proxyAuthUser, proxyAuthPW});
                    Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.proxy.typeinvalid", (Object[])new Object[]{type, "com.ibm.ws.jaxrs.client.proxy.type", ProxyServerType.HTTP, e.getMessage()});
                }
            }
            if ((clientPolicy = httpConduit.getClient()) == null) {
                clientPolicy = new HTTPClientPolicy();
                httpConduit.setClient(clientPolicy);
            }
            clientPolicy.setProxyServer(host);
            try {
                clientPolicy.setProxyServerPort(iPort);
            }
            catch (NoSuchMethodError e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"configClientProxy - NSME setProxyServerPort - retrying...", (Object[])new Object[]{e});
                }
                try {
                    Method m = HTTPClientPolicy.class.getMethod("setProxyServerPort", Integer.TYPE);
                    m.invoke((Object)clientPolicy, iPort);
                }
                catch (Exception ex) {
                    try {
                        Method m = HTTPClientPolicy.class.getMethod("setProxyServerPort", Integer.class);
                        m.invoke((Object)clientPolicy, new Integer(iPort));
                    }
                    catch (Exception ex2) {
                        Method[] methods = HTTPClientPolicy.class.getMethods();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                        Tr.debug((TraceComponent)tc, (String)"configClientProxy - NSME setProxyServerPort(int OR Integer) - retrying...", (Object[])new Object[]{methods, ex2});
                    }
                }
            }
        }
        clientPolicy.setProxyServerType(proxyServerType);
        ProxyAuthorizationPolicy authPolicy = null;
        if (proxyAuthUser != null || proxyAuthPW != null) {
            authPolicy = new ProxyAuthorizationPolicy();
            if (proxyAuthType != null && !"Basic".equalsIgnoreCase(proxyAuthType) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unrecognized proxy authorization type, \"" + proxyAuthType + "\".  Only \"Basic\" is recognized."), (Object[])new Object[0]);
            }
            proxyAuthType = "Basic";
            authPolicy.setAuthorizationType(proxyAuthType);
            if (proxyAuthUser != null) {
                authPolicy.setUserName(proxyAuthUser);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No proxy authorization username specified.  No proxy authorization data will be generated.", (Object[])new Object[0]);
                }
                authPolicy = null;
            }
            if (authPolicy != null && proxyAuthPW != null) {
                authPolicy.setPassword(new String(proxyAuthPW.getChars()));
            } else if (proxyAuthPW == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No proxy authorization password specified.  No proxy authorization data will be generated.", (Object[])new Object[0]);
                }
                authPolicy = null;
            }
        }
        if (authPolicy != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("configuring proxy auth policy " + authPolicy + " + to httpConduit " + httpConduit), (Object[])new Object[0]);
            }
            httpConduit.setProxyAuthorization(authPolicy);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            private static final String DISABLED_SCHEMES_PROP = "jdk.http.auth.tunneling.disabledSchemes";
            static final long serialVersionUID = -4064196112860634L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                String propVal = System.getProperty(DISABLED_SCHEMES_PROP);
                if (propVal == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"<clinit> setting property jdk.http.auth.tunneling.disabledSchemes=''", (Object[])new Object[0]);
                    }
                    System.setProperty(DISABLED_SCHEMES_PROP, "");
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("<clinit> property jdk.http.auth.tunneling.disabledSchemes already set to " + propVal), (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor$1", 1.class, (String)"com.ibm.ws.jaxrs20.client", (String)"com.ibm.ws.jaxrs20.client.internal.resources.JAXRSClientMessages");
            }
        });
    }
}

