/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transport.sip.SipConnLink;
import com.ibm.ws.sip.stack.transport.sip.SipInboundChannel;
import com.ibm.ws.sip.stack.util.AddressUtils;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContextFactory;
import java.io.IOException;

public abstract class SipOutboundConnLink
extends SipConnLink
implements OutboundConnectionLink {
    private static final TraceComponent tc = Tr.register(SipOutboundConnLink.class);
    private static SipOutboundConnLink s_current = null;
    private static int s_connectTimeout = SIPTransactionStack.instance().getConfiguration().getConnectTimeout();
    private final String m_chainName;

    public SipOutboundConnLink(String peerHost, int peerPort, SipInboundChannel channel) {
        super(peerHost, peerPort, channel);
        this.m_chainName = channel.getOutboundChainName();
    }

    private VirtualConnectionFactory getOutboundVCFactory() throws ChannelException, ChainException {
        ChannelFramework cf = ChannelFrameworkFactory.getChannelFramework();
        return cf.getOutboundVCFactory(this.m_chainName);
    }

    private Object createConnectRequestContext(String host, int port, int timeout) {
        SIPListenningConnection listeningConnection = this.getSIPListenningConnection();
        String localBindAddress = listeningConnection.getListeningPoint().getHost();
        if (!AddressUtils.isIpAddress(localBindAddress)) {
            localBindAddress = "0.0.0.0";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"createConnectRequestContext", (Object[])new Object[]{"Connecting from [" + localBindAddress + "] to [" + host + ':' + port + ']'});
        }
        TCPConnectRequestContext context = TCPConnectRequestContextFactory.getRef().createTCPConnectRequestContext(localBindAddress, 0, host, port, timeout);
        return context;
    }

    public void ready(VirtualConnection vc) {
        this.connectionEstablished();
    }

    public void connect(Object address) throws Exception {
        ((OutboundConnectionLink)this.getDeviceLink()).connect(address);
        this.ready(this.getVirtualConnection());
    }

    public void connectAsynch(Object address) {
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        try {
            VirtualConnectionFactory factory = this.getOutboundVCFactory();
            Class<SipOutboundConnLink> clazz = SipOutboundConnLink.class;
            synchronized (SipOutboundConnLink.class) {
                s_current = this;
                VirtualConnection vc = factory.createConnection();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.setVirtualConnection(vc);
                if (!(vc instanceof OutboundVirtualConnection)) {
                    throw new IllegalStateException("Not an OutboundVirtualConnection");
                }
                OutboundVirtualConnection outboundConnection = (OutboundVirtualConnection)vc;
                String host = this.getRemoteHost();
                int port = this.getRemotePort();
                if (s_connectTimeout == 0) {
                    s_connectTimeout = -1;
                }
                Object connectRequestContext = this.createConnectRequestContext(host, port, s_connectTimeout);
                outboundConnection.connectAsynch(connectRequestContext, (ConnectionReadyCallback)this);
            }
        }
        catch (Exception e2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"Exception", e2});
            }
            this.close();
            throw new IOException(e2.getMessage());
        }
    }

    static SipOutboundConnLink getPendingConnection() {
        SipOutboundConnLink current = s_current;
        s_current = null;
        return current;
    }
}

