/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.dar.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.dar.SARInfoFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.sip.ar.SipApplicationRouterInfo;

public class PropertyFileParser {
    private static final LogMgr c_logger = Log.get(PropertyFileParser.class);
    private HashMap<String, List<SipApplicationRouterInfo>> methodForApplicationMap = null;
    private StringBuffer propData = null;
    private File propFile = null;

    public PropertyFileParser(File propFile, HashMap<String, List<SipApplicationRouterInfo>> methodForApplicationMap) throws IOException {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("CWSCT0416I: Default application router, property strategy, loading property file - " + propFile.getPath() + " .");
        }
        this.propFile = propFile;
        this.methodForApplicationMap = methodForApplicationMap;
        this.loadFile();
    }

    public void loadFile() throws IOException {
        try (InputStream inputStream = null;){
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "loadFile");
            }
            inputStream = new FileInputStream(this.propFile);
            Properties appRouterProp = new Properties();
            appRouterProp.load(inputStream);
            this.parse(appRouterProp);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "loadFile");
            }
        }
    }

    public void reload() {
        if (this.propFile != null) {
            try {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("CWSCT0418I: Default application router, property strategy, property file has been reloaded.");
                }
                this.loadFile();
            }
            catch (IOException e2) {
                c_logger.error("error.dar.property.parser.1");
                e2.printStackTrace();
            }
        }
    }

    private void parse(Properties appRouterProps) {
        Set<Object> keys = appRouterProps.keySet();
        Pattern appPattern = Pattern.compile("\\([^\\(]*\\)");
        for (Object methodName : keys) {
            String appInfoString = appRouterProps.getProperty(methodName.toString());
            Matcher appMatcher = appPattern.matcher(appInfoString);
            List appList = this.exctractApplications(appMatcher, appInfoString);
            this.methodForApplicationMap.put(methodName.toString(), appList);
        }
    }

    private List exctractApplications(Matcher appMatcher, String appInfoString) {
        ArrayList<SipApplicationRouterInfo> appList = new ArrayList<SipApplicationRouterInfo>();
        while (appMatcher.find()) {
            String currApplicationInfo = appInfoString.substring(appMatcher.start(), appMatcher.end());
            SipApplicationRouterInfo sarInfo = SARInfoFactory.createSARInfoFactory(currApplicationInfo);
            appList.add(sarInfo);
        }
        return appList;
    }

    private HashMap<String, List<SipApplicationRouterInfo>> getMethodForApplicationMap() {
        return this.methodForApplicationMap;
    }
}

