/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.naptr;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.naptr.ISenderListener;
import com.ibm.ws.sip.container.naptr.SendProcessor;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.util.SipUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import java.io.IOException;

public class Sender
extends SendProcessor {
    private static final LogMgr c_logger = Log.get(Sender.class);
    private static Sender s_SenderInstance = null;
    private static Object s_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sender getInstnace() {
        if (s_SenderInstance == null) {
            Object object = s_lock;
            synchronized (object) {
                if (s_SenderInstance == null) {
                    s_SenderInstance = new Sender();
                }
            }
        }
        return s_SenderInstance;
    }

    @Override
    public void responseReceived(SipServletResponseImpl resp, ISenderListener client) {
        client.responseReceived(resp);
    }

    @Override
    public void sendRequest(OutgoingSipServletRequest request, ISenderListener client) throws IOException {
        try {
            SipUtil.setDestinationHeader(client.getTarget(), request.getRequest());
        }
        catch (SipParseException e2) {
            throw new IOException(e2.getMessage());
        }
        try {
            this.send(request, client);
        }
        catch (IOException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("IOException when sending request. try next destination for request: ");
                buff.append(request);
                c_logger.traceDebug(this, "sendToNextDestination", buff.toString());
            }
            client.failedToSendRequest(true);
        }
    }

    @Override
    public void processTimeout(ISenderListener client) {
        client.failedToSendRequest(false);
    }

    @Override
    public void cleanItself() {
        super.cleanItself();
    }

    @Override
    public SipURL getLastUsedDestination(ISenderListener client) {
        return client.getTarget();
    }
}

