/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20RefreshTokenInvalidClientException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20RefreshTokenInvalidClientException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _refresh;
    private String _clientId;

    public OAuth20RefreshTokenInvalidClientException(String refresh, String clientId) {
        super("invalid_grant", "The refresh token: " + refresh + " does not belong to the client attempting to use it: " + clientId, null);
        this._refresh = refresh;
        this._clientId = clientId;
    }

    public OAuth20RefreshTokenInvalidClientException(String msgKey, String refresh, String clientId) {
        super("invalid_grant", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{refresh, clientId}), null);
        this._msgKey = msgKey;
        this._refresh = refresh;
        this._clientId = clientId;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._refresh, (Locale)locale, (String)encoding), WebUtils.encode((String)this._clientId, (Locale)locale, (String)encoding));
    }

    String getRefreshToken() {
        return this._refresh;
    }

    String getClientId() {
        return this._clientId;
    }
}

