/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATCoordinatorTran;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATTransaction
implements Synchronization {
    private static final String CLASS_NAME = WSATTransaction.class.getName();
    private static final TraceComponent TC = Tr.register(WSATTransaction.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static Map<String, WSATTransaction> tranMap = Collections.synchronizedMap(new HashMap());
    private final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final String globalId;
    private WSATCoordinator registration;
    private WSATCoordinator coordinator;
    private final boolean recoveryTran;
    private final long expiryTime;
    static final long serialVersionUID = -4342633310850938475L;

    public static void putTran(WSATTransaction tran) {
        tranMap.put(tran.getGlobalId(), tran);
    }

    public static WSATTransaction getTran(String globalId) {
        return tranMap.get(globalId);
    }

    public static void removeTran(String globalId) {
        tranMap.remove(globalId);
    }

    public static WSATCoordinatorTran getCoordTran(String globalId) {
        WSATTransaction wsatTran = WSATTransaction.getTran(globalId);
        if (wsatTran != null && !(wsatTran instanceof WSATCoordinatorTran)) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Transaction is not a coordinator", (Object[])new Object[0]);
            }
            wsatTran = null;
        }
        return (WSATCoordinatorTran)wsatTran;
    }

    public WSATTransaction(String id, long timeout) {
        this(id, timeout, false);
    }

    public WSATTransaction(String id, long timeout, boolean recovery) {
        this.globalId = id;
        this.expiryTime = timeout;
        this.recoveryTran = recovery;
        if (!this.recoveryTran) {
            this.tranService.registerTranSync(this);
        }
    }

    @Trivial
    public String getGlobalId() {
        return this.globalId;
    }

    @Trivial
    protected boolean isRecovery() {
        return this.recoveryTran;
    }

    public long getTimeout() {
        return this.expiryTime;
    }

    public WSATCoordinator setRegistration(EndpointReferenceType epr) {
        WSATCoordinator reg;
        this.registration = reg = new WSATCoordinator(this.globalId, epr);
        return reg;
    }

    public WSATCoordinator getRegistration() {
        return this.registration;
    }

    public synchronized WSATCoordinator setCoordinator(EndpointReferenceType epr) {
        WSATCoordinator coord;
        this.coordinator = coord = new WSATCoordinator(this.globalId, epr);
        return coord;
    }

    public synchronized WSATCoordinator setCoordinator(WSATCoordinator coord) {
        this.coordinator = coord;
        return coord;
    }

    public synchronized WSATCoordinator getCoordinator() {
        return this.coordinator;
    }

    public synchronized void removeCoordinator() {
        if (this.isRecovery()) {
            this.afterCompletion(0);
        }
    }

    public WSATContext getContext() {
        WSATContext ctx = null;
        if (!this.isRecovery()) {
            ctx = new WSATContext(this.getGlobalId(), this.getRegistration(), this.getTimeout());
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Transaction is in recovery mode, returning null CoordinationContext", (Object[])new Object[0]);
        }
        return ctx;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Removing global transaction: {0}", (Object[])new Object[]{this});
        }
        WSATTransaction.removeTran(this.getGlobalId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.globalId;
    }
}

