/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.tasks.BaseBatchRestTask;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public abstract class BaseWaitTask<T extends BaseWaitTask>
extends BaseBatchRestTask<T> {
    private static final Pattern ExitStatusRC = Pattern.compile("^\\d+");

    public BaseWaitTask(String taskName, String scriptName) {
        super(taskName, scriptName);
    }

    @Override
    protected List<String> getOptionalOptionsMessages() {
        List<String> retMe = super.getOptionalOptionsMessages();
        retMe.add(this.buildOptionsMessage("wait.optional-key", "wait.optional-desc"));
        return retMe;
    }

    @Override
    protected List<String> getTaskOptions() {
        List<String> retMe = super.getTaskOptions();
        retMe.addAll(this.getNlsOptionNames("wait.optional-key."));
        return retMe;
    }

    protected JobExecution waitForTermination(JobInstance jobInstance) throws IOException, InterruptedException {
        return this.waitForTermination(jobInstance, null);
    }

    protected JobExecution waitForTermination(JobInstance jobInstance, JobExecution jobExecution) throws IOException, InterruptedException {
        if (this.shouldGetJobLog()) {
            this.issueJobLogLocationMessage(jobInstance);
        }
        jobExecution = jobExecution == null ? this.getPollingBatchRestClient().waitForTermination(jobInstance) : this.getPollingBatchRestClient().waitForTermination(jobExecution);
        return this.finishUp(jobInstance, jobExecution);
    }

    protected JobExecution finishUp(JobInstance jobInstance, JobExecution jobExecution) throws IOException {
        this.issueJobFinishedMessage(jobInstance, jobExecution);
        this.issueJobExecutionMessage(jobExecution);
        if (this.shouldGetJobLog()) {
            this.issueDownloadingJobLogMessage(jobInstance);
            this.getBatchRestClient().getJobLogsForJobInstance(jobInstance.getInstanceId(), "text").copyToStream(this.getTaskIO().getStdout());
        }
        return jobExecution;
    }

    protected void issueJobLogLocationMessage(JobInstance jobInstance) {
        this.getTaskIO().info(ResourceBundleUtils.getMessage("joblog.location", jobInstance.getJobName(), jobInstance.getInstanceId(), this.getBatchRestClient().buildJobLogsRestLink(jobInstance, null)));
    }

    protected void issueDownloadingJobLogMessage(JobInstance jobInstance) {
        this.getTaskIO().info(ResourceBundleUtils.getMessage("joblog.download", jobInstance.getJobName(), jobInstance.getInstanceId(), this.getBatchRestClient().buildJobLogsRestLink(jobInstance, "text")));
    }

    protected boolean shouldGetJobLog() {
        return this.getTaskArgs().isSpecified("--getJobLog");
    }

    protected boolean shouldWaitForTermination() {
        return this.getTaskArgs().isSpecified("--wait");
    }

    protected int getProcessReturnCode(JobExecution jobExecution) {
        return this.shouldReturnExitStatus() ? this.parseExitStatusReturnCode(jobExecution.getExitStatus()) : this.getBatchStatusReturnCode(jobExecution.getBatchStatus());
    }

    protected boolean shouldReturnExitStatus() {
        return this.getTaskArgs().isSpecified("--returnExitStatus");
    }

    protected int parseExitStatusReturnCode(String exitStatus) {
        Matcher matcher = ExitStatusRC.matcher(exitStatus);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        try {
            return this.getBatchStatusReturnCode(BatchStatus.valueOf((String)exitStatus));
        }
        catch (IllegalArgumentException iae) {
            throw new NumberFormatException("The exitStatus, '" + exitStatus + "', does not begin with a parsable integer");
        }
    }

    protected boolean shouldAddShutdownHook() {
        return this.getTaskArgs().isSpecified("--stopOnShutdown");
    }

    protected Thread addShutdownHook(JobInstance jobInstance) {
        StopJobShutdownHook hook = new StopJobShutdownHook(jobInstance);
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }

    protected boolean removeShutdownHook(Thread hook) {
        return hook != null ? Runtime.getRuntime().removeShutdownHook(hook) : false;
    }

    private class StopJobShutdownHook
    extends Thread {
        private JobInstance jobInstance;

        public StopJobShutdownHook(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        @Override
        public void run() {
            try {
                BaseWaitTask.this.issueShutdownHookMessage(this.jobInstance);
                BaseWaitTask.this.getBatchRestClient().stop(this.jobInstance);
                BaseWaitTask.this.issueJobStopSubmittedMessage(this.jobInstance);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

