/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.rest;

import com.ibm.ws.jbatch.utility.rest.BatchRestClient;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.util.List;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class PollingBatchClient {
    private BatchRestClient batchRestClient;
    private long pollingInterval_ms = 30000L;
    private boolean verboseWait = false;
    private TaskIO taskIO = null;

    public PollingBatchClient(BatchRestClient batchRestClient, long pollingInterval_ms) {
        this.batchRestClient = batchRestClient;
        this.pollingInterval_ms = pollingInterval_ms;
    }

    public long getPollingInterval_ms() {
        return this.pollingInterval_ms;
    }

    public BatchRestClient getBatchRestClient() {
        return this.batchRestClient;
    }

    public JobExecution waitForLatestJobExecution(JobInstance jobInstance) throws InterruptedException, IOException {
        return this.waitForLatestJobExecution(jobInstance.getInstanceId());
    }

    public JobExecution waitForLatestJobExecution(long jobInstanceId) throws InterruptedException, IOException {
        List<JobExecution> jobExecutions = this.getBatchRestClient().getJobExecutions(jobInstanceId);
        while (jobExecutions.isEmpty()) {
            this.waitForLatestJobExecutionVerbose(jobInstanceId);
            Thread.sleep(this.getPollingInterval_ms());
            jobExecutions = this.getBatchRestClient().getJobExecutions(jobInstanceId);
        }
        return PollingBatchClient.getLatestJobExecution(jobExecutions);
    }

    public JobExecution waitForTermination(JobInstance jobInstance) throws InterruptedException, IOException {
        return this.waitForTermination(this.waitForLatestJobExecution(jobInstance));
    }

    public JobExecution waitForTermination(JobExecution jobExecution) throws InterruptedException, IOException {
        while (!this.isDone(jobExecution.getBatchStatus())) {
            this.waitForTerminationVerbose(jobExecution);
            Thread.sleep(this.getPollingInterval_ms());
            jobExecution = this.getBatchRestClient().getJobExecution(jobExecution.getExecutionId());
        }
        return jobExecution;
    }

    public PollingBatchClient setVerboseWait(boolean verboseWait, TaskIO taskIO) {
        this.verboseWait = verboseWait;
        this.taskIO = taskIO;
        return this;
    }

    protected boolean isVerboseWait() {
        return this.verboseWait && this.taskIO != null;
    }

    public void waitForTerminationVerbose(JobExecution jobExecution) {
        if (this.isVerboseWait()) {
            this.taskIO.info(ResourceBundleUtils.getMessage("waiting.for.termination", jobExecution.toString()));
        }
    }

    public void waitForLatestJobExecutionVerbose(long jobInstanceId) {
        if (this.isVerboseWait()) {
            this.taskIO.info(ResourceBundleUtils.getMessage("waiting.for.latest.job.execution", jobInstanceId));
        }
    }

    public void waitForNextJobExecutionVerbose(JobExecution jobExecution) {
        if (this.isVerboseWait()) {
            this.taskIO.info(ResourceBundleUtils.getMessage("waiting.for.next.job.execution", jobExecution.toString()));
        }
    }

    public boolean isDone(BatchStatus batchStatus) {
        switch (batchStatus) {
            case STOPPED: 
            case FAILED: 
            case COMPLETED: 
            case ABANDONED: {
                return true;
            }
        }
        return false;
    }

    public JobExecution waitForNextJobExecution(JobInstance jobInstance, JobExecution afterThisJobExecution) throws InterruptedException, IOException {
        if (afterThisJobExecution == null) {
            return this.waitForLatestJobExecution(jobInstance);
        }
        JobExecution retMe = this.getNextJobExecution(this.getBatchRestClient().getJobExecutions(jobInstance), afterThisJobExecution);
        while (retMe == null) {
            this.waitForNextJobExecutionVerbose(afterThisJobExecution);
            Thread.sleep(this.getPollingInterval_ms());
            retMe = this.getNextJobExecution(this.getBatchRestClient().getJobExecutions(jobInstance), afterThisJobExecution);
        }
        return retMe;
    }

    protected JobExecution getNextJobExecution(List<JobExecution> jobExecutions, JobExecution afterThisJobExecution) {
        JobExecution prev = null;
        for (JobExecution jobExecution : jobExecutions) {
            if (jobExecution.getExecutionId() == afterThisJobExecution.getExecutionId()) {
                return prev;
            }
            prev = jobExecution;
        }
        throw new IllegalArgumentException("afterThisJobExecution (" + afterThisJobExecution + ") not in the given list of JobExecutions (" + jobExecutions + ")");
    }

    public static JobExecution getLatestJobExecution(List<JobExecution> jobExecutions) {
        return jobExecutions != null && jobExecutions.size() > 0 ? jobExecutions.get(0) : null;
    }

    public JobExecution getLatestJobExecution(long jobInstanceId) throws IOException {
        return PollingBatchClient.getLatestJobExecution(this.getBatchRestClient().getJobExecutions(jobInstanceId));
    }
}

