/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAProviderIntegration;
import com.ibm.ws.jpa.JPAVersion;
import com.ibm.ws.jpa.hibernate.LibertyJtaPlatform;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.persistence.spi.PersistenceUnitInfo;

public abstract class AbstractJPAProviderIntegration
implements JPAProviderIntegration {
    private static final TraceComponent tc = Tr.register(AbstractJPAProviderIntegration.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    protected static final String PROVIDER_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    protected static final String PROVIDER_HIBERNATE = "org.hibernate.jpa.HibernatePersistenceProvider";
    protected static final String PROVIDER_OPENJPA = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    protected final ConcurrentSkipListSet<String> providersUsed = new ConcurrentSkipListSet();

    @Override
    public void disablePersistenceUnitLogging(Map<String, Object> integrationProperties) {
        integrationProperties.put("eclipselink.logging.level", "OFF");
        integrationProperties.put("eclipselink.session-name", "disabled-logging-pu" + UUID.randomUUID().toString());
    }

    @FFDCIgnore(value={Exception.class})
    private void logProviderInfo(String providerName, ClassLoader loader) {
        block8: {
            try {
                if (PROVIDER_ECLIPSELINK.equals(providerName)) {
                    Class<?> Version2 = AbstractJPAProviderIntegration.loadClass(loader, "org.eclipse.persistence.Version");
                    String version = (String)Version2.getMethod("getVersionString", new Class[0]).invoke(Version2.newInstance(), new Object[0]);
                    Tr.info((TraceComponent)tc, (String)"JPA_THIRD_PARTY_PROV_INFO_CWWJP0053I", (Object[])new Object[]{"EclipseLink", version});
                } else if (PROVIDER_HIBERNATE.equals(providerName)) {
                    Class<?> Version3 = AbstractJPAProviderIntegration.loadClass(loader, "org.hibernate.Version");
                    String version = (String)Version3.getMethod("getVersionString", new Class[0]).invoke(null, new Object[0]);
                    Tr.info((TraceComponent)tc, (String)"JPA_THIRD_PARTY_PROV_INFO_CWWJP0053I", (Object[])new Object[]{"Hibernate", version});
                } else if (PROVIDER_OPENJPA.equals(providerName)) {
                    StringBuilder version = new StringBuilder();
                    Class<?> OpenJPAVersion = AbstractJPAProviderIntegration.loadClass(loader, "org.apache.openjpa.conf.OpenJPAVersion");
                    OpenJPAVersion.getMethod("appendOpenJPABanner", StringBuilder.class).invoke(OpenJPAVersion.newInstance(), version);
                    Tr.info((TraceComponent)tc, (String)"JPA_THIRD_PARTY_PROV_INFO_CWWJP0053I", (Object[])new Object[]{"OpenJPA", version});
                } else {
                    Tr.info((TraceComponent)tc, (String)"JPA_THIRD_PARTY_PROV_NAME_CWWJP0052I", (Object[])new Object[]{providerName});
                }
            }
            catch (Exception x) {
                Tr.info((TraceComponent)tc, (String)"JPA_THIRD_PARTY_PROV_NAME_CWWJP0052I", (Object[])new Object[]{providerName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"unable to determine provider info", (Object[])new Object[]{x});
            }
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static Class<?> loadClass(final ClassLoader cl, final String className) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return cl.loadClass(className);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return cl.loadClass(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void moduleStarting(ModuleInfo moduleInfo) {
    }

    @Override
    public void moduleStarted(ModuleInfo moduleInfo) {
    }

    @Override
    public void moduleStopping(ModuleInfo moduleInfo) {
    }

    @Override
    public void moduleStopped(ModuleInfo moduleInfo) {
    }

    @Override
    public boolean supportsEntityManagerPooling() {
        return false;
    }

    @Override
    @FFDCIgnore(value={ClassNotFoundException.class})
    public void updatePersistenceProviderIntegrationProperties(PersistenceUnitInfo puInfo, Map<String, Object> props) {
        String providerName;
        block13: {
            providerName = puInfo.getPersistenceProviderClassName();
            if (PROVIDER_ECLIPSELINK.equals(providerName)) {
                Properties properties;
                props.put("eclipselink.target-server", "WebSphere_Liberty");
                if (puInfo instanceof JPAPUnitInfo) {
                    props.put("eclipselink.application-id", ((JPAPUnitInfo)puInfo).getApplName());
                }
                if (!(properties = puInfo.getProperties()).containsKey("eclipselink.allow-null-max-min") && JPAAccessor.getJPAComponent().getJPAVersion().lesserThan(JPAVersion.JPA30)) {
                    props.put("eclipselink.allow-null-max-min", "false");
                }
                if (!properties.containsKey("eclipselink.sql.allow-convert-result-to-boolean") && JPAAccessor.getJPAComponent().getJPAVersion().equals((Object)JPAVersion.JPA22)) {
                    props.put("eclipselink.sql.allow-convert-result-to-boolean", "false");
                }
                if (!properties.containsKey("eclipselink.concurrency.manager.allow.readlockstacktrace") && JPAAccessor.getJPAComponent().getJPAVersion().equals((Object)JPAVersion.JPA30)) {
                    props.put("eclipselink.concurrency.manager.allow.readlockstacktrace", "false");
                }
            } else if (PROVIDER_HIBERNATE.equals(providerName)) {
                ClassLoader loader = puInfo.getClassLoader();
                if (this.isWebSphereLibertyJtaPlatformAvailable(loader)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Detected WebSphereLibertyJtaPlatform, not applying dynamic proxy JtaPlatform.", (Object[])new Object[0]);
                    }
                } else {
                    try {
                        Class<?> JtaPlatform = AbstractJPAProviderIntegration.loadClass(loader, "org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform");
                        Object libertyJtaPlatform = Proxy.newProxyInstance(loader, new Class[]{JtaPlatform}, (InvocationHandler)new LibertyJtaPlatform());
                        props.put("hibernate.transaction.jta.platform", libertyJtaPlatform);
                    }
                    catch (ClassNotFoundException x) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to provide JtaPlatform for Liberty TransactionManager to Hibernate", (Object[])new Object[]{x});
                    }
                }
            }
        }
        if (this.providersUsed.add(providerName)) {
            this.logProviderInfo(providerName, puInfo.getClassLoader());
        }
    }

    @Override
    public void updatePersistenceUnitProperties(String providerClassName, Properties props) {
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private boolean isWebSphereLibertyJtaPlatformAvailable(ClassLoader loader) {
        try {
            AbstractJPAProviderIntegration.loadClass(loader, "org.hibernate.engine.transaction.jta.platform.internal.WebSphereLibertyJtaPlatform");
            return true;
        }
        catch (ClassNotFoundException notFound) {
            return false;
        }
    }
}

