/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.util.HashMap;
import java.util.WeakHashMap;

public class ClassLoaderLocal {
    private Object key = new Object();
    private static final ClassLocalMap globalMap = new ClassLocalMap();
    private String name;
    private static final WeakHashMap localMaps = new WeakHashMap();

    public ClassLoaderLocal() {
        this("<anonymous>");
    }

    public ClassLoaderLocal(String name) {
        this.name = name;
    }

    public Object initialValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object o) {
        ClassLocalMap map;
        ClassLocalMap classLocalMap = map = this.getLoaderLocalMap();
        synchronized (classLocalMap) {
            map.put(this.key, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobal(Object o) {
        ClassLocalMap classLocalMap = globalMap;
        synchronized (classLocalMap) {
            globalMap.put(this.key, o);
        }
    }

    public Object getGlobal() {
        return this.getOrCreate(globalMap);
    }

    public Object get() {
        return this.getOrCreate(this.getLoaderLocalMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrCreate(ClassLocalMap globalMap) {
        ClassLocalMap classLocalMap = globalMap;
        synchronized (classLocalMap) {
            if (globalMap.containsKey(this.key)) {
                return globalMap.get(this.key);
            }
            Object init = this.initialValue();
            globalMap.put(this.key, init);
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLocalMap getLoaderLocalMap() {
        ClassLocalMap map;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            map = globalMap;
        } else {
            WeakHashMap weakHashMap = localMaps;
            synchronized (weakHashMap) {
                map = (ClassLocalMap)localMaps.get(cl);
                if (map == null) {
                    map = new ClassLocalMap();
                    localMaps.put(cl, map);
                }
            }
        }
        return map;
    }

    private static class ClassLocalMap
    extends HashMap {
        ClassLocalMap() {
        }
    }
}

