/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.ConnectionResults;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.resource.ResourceException;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;

public class OracleHelper
extends DatabaseHelper {
    private static TraceComponent tc = com.ibm.websphere.ras.Tr.register(OracleHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String ORACLELOG_FILE_SIZE_LIMIT = "oracleLogFileSizeLimit";
    private static final String ORACLELOG_FILE_COUNT = "oracleLogFileCount";
    private static final String ORACLELOG_FILENAME = "oracleLogFileName";
    private static final String ORACLELOG_TRACELEVEL = "oracleLogTraceLevel";
    private static final String ORACLELOG_FORMAT = "oracleLogFormat";
    private static final String ORACLELOG_PACKAGENAME = "oracleLogPackageName";
    private static final int NOT_CACHED = -99;
    private int driverMajorVersion = -99;
    private int driverMinorVersion = -99;
    private static final String oracle_jdbc_OracleConnection = "oracle.jdbc.OracleConnection";
    private static final String oracle_jdbc_OraclePreparedStatement = "oracle.jdbc.OraclePreparedStatement";
    private static final String oracle_jdbc_driver_OracleLog = "oracle.jdbc.driver.OracleLog";
    private final AtomicReference<Class<?>> OracleConnection = new AtomicReference();
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private MethodHandle setConnectionProperties;
    private MethodHandle getConnectionProperties;
    private final AtomicReference<Method> clearDefines = new AtomicReference();
    private final AtomicReference<Method> close = new AtomicReference();
    private final AtomicReference<Method> getDefaultExecuteBatch = new AtomicReference();
    private final AtomicReference<Method> getDefaultRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> getDefaultTimeZone = new AtomicReference();
    private final AtomicReference<Method> getIncludeSynonyms = new AtomicReference();
    private final AtomicReference<Method> getRemarksReporting = new AtomicReference();
    private final AtomicReference<Method> getRestrictGetTables = new AtomicReference();
    private final AtomicReference<Method> getSessionTimeZone = new AtomicReference();
    private final AtomicReference<Method> isProxySession = new AtomicReference();
    private final AtomicReference<Method> setDefaultExecuteBatch = new AtomicReference();
    private final AtomicReference<Method> setDefaultRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> setDefaultTimeZone = new AtomicReference();
    private final AtomicReference<Method> setEndToEndMetrics = new AtomicReference();
    private final AtomicReference<Method> setIncludeSynonyms = new AtomicReference();
    private final AtomicReference<Method> setLobPrefetchSize = new AtomicReference();
    private final AtomicReference<Method> setRemarksReporting = new AtomicReference();
    private final AtomicReference<Method> setRestrictGetTables = new AtomicReference();
    private final AtomicReference<Method> setRowPrefetch = new AtomicReference();
    private final AtomicReference<Method> setSessionTimeZone = new AtomicReference();
    private String[] matrix;
    private static final TraceComponent oraTc = Tr.register((String)"com.ibm.ws.oracle.logwriter", (String)"WAS.database", null);

    OracleHelper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        this.dataStoreHelper = "com.ibm.websphere.rsadapter.Oracle11gDataStoreHelper";
        mcf.supportsIsReadOnly = false;
        this.xaEndResetsAutoCommit = true;
        this.matrix = new String[4];
        int limit = 0;
        int count = 1;
        String _oracleLogFileName = null;
        Logger _logger = null;
        Formatter _formatter = null;
        FileHandler _handler = null;
        String _oraclePackageName = "oracle.jdbc.driver";
        String _oracleLogTraceLevel = "INFO";
        String _oracleLogFormat = "SimpleFormat";
        String holder = null;
        Properties props = mcf.dsConfig.get().vendorProps;
        if (props != null) {
            holder = props.getProperty(ORACLELOG_PACKAGENAME);
            if (holder != null && !holder.equals("")) {
                _oraclePackageName = holder;
            }
            if ((holder = props.getProperty(ORACLELOG_FILENAME)) != null && !holder.equals("")) {
                _oracleLogFileName = holder;
            }
            if (oraTc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_PACKAGENAME is: ", (Object[])new Object[]{_oraclePackageName});
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_FILENAME is:  ", (Object[])new Object[]{_oracleLogFileName});
            }
            _logger = Logger.getLogger(_oraclePackageName);
            if (_oracleLogFileName != null && !_oracleLogFileName.equals("")) {
                holder = props.getProperty(ORACLELOG_TRACELEVEL);
                if (holder != null && !holder.equals("")) {
                    _oracleLogTraceLevel = holder;
                }
                if ((holder = props.getProperty(ORACLELOG_FORMAT)) != null && !holder.equals("")) {
                    _oracleLogFormat = holder;
                }
                if (_oracleLogFormat != null && (_oracleLogFormat.charAt(0) == 'S' || _oracleLogFormat.charAt(0) == 's')) {
                    if (oraTc.isDebugEnabled()) {
                        com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"SimpleFormatter is used", (Object[])new Object[0]);
                    }
                    _formatter = new SimpleFormatter();
                } else {
                    if (oraTc.isDebugEnabled()) {
                        com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"XMLFormatter is used", (Object[])new Object[0]);
                    }
                    _formatter = new XMLFormatter();
                }
                holder = props.getProperty(ORACLELOG_FILE_SIZE_LIMIT);
                if (holder != null && !holder.equals("")) {
                    limit = Integer.parseInt(holder);
                }
                if ((holder = props.getProperty(ORACLELOG_FILE_COUNT)) != null && !holder.equals("")) {
                    count = Integer.parseInt(holder);
                }
                if (oraTc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)("DSConfigHelper.ORACLELOG_FILE_COUNT is: " + count), (Object[])new Object[0]);
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)("DSConfigHelper.ORACLELOG_FILE_SIZE_LIMIT is: " + limit), (Object[])new Object[0]);
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_FORMAT is: ", (Object[])new Object[]{_oracleLogFormat});
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"DSConfigHelper.ORACLELOG_TRACELEVEL is: ", (Object[])new Object[]{_oracleLogTraceLevel});
                }
                try {
                    _handler = new FileHandler(_oracleLogFileName + "%g.%u", limit, count);
                    _handler.setFormatter(_formatter);
                    _handler.setLevel(Level.ALL);
                    _logger.setLevel(AdapterUtil.getLevelBasedOnName(_oracleLogTraceLevel));
                    _logger.setUseParentHandlers(false);
                    _logger.addHandler(_handler);
                }
                catch (IOException iox) {
                    com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"ORACLE_TRACE_WARNING", (Object[])new Object[]{_oracleLogFileName, iox});
                }
            } else if (oraTc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"Oracle trace file is not set, Oracle logging/tracing will be mergned with WAS logging based on WAS logging settings", (Object[])new Object[0]);
            }
        }
        Collections.addAll(this.staleConCodes, 20, 28, 1012, 1014, 1033, 1034, 1035, 1089, 1090, 1092, 3113, 3114, 12505, 12541, 12560, 12571, 17002, 17008, 17009, 17401, 17410, 17430, 17447, 24794, 25408);
    }

    @Override
    public boolean supportsSubjectDoAsForKerberos() {
        return true;
    }

    @Override
    public boolean alwaysSetAutoCommit() {
        return false;
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (!this.mcf.dsConfig.get().enableBranchCouplingExtension) {
            return super.branchCouplingSupported(couplingType);
        }
        if (couplingType == 0) {
            if (this.mcf.dataStoreHelper == null) {
                return 65536;
            }
            return this.mcf.dataStoreHelper.modifyXAFlag(0);
        }
        return 0;
    }

    @Override
    public Map<String, Object> cacheVendorConnectionProps(Connection sqlConn) throws SQLException {
        try {
            Method m;
            Class c = this.OracleConnection.get();
            if (c == null) {
                c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OracleConnection);
                this.OracleConnection.set(c);
            }
            HashMap<String, Object> tempProps = new HashMap<String, Object>();
            if (this.driverMajorVersion == -99) {
                this.driverMajorVersion = sqlConn.getMetaData().getDriverMajorVersion();
            }
            if ((m = this.getDefaultExecuteBatch.get()) == null) {
                m = c.getMethod("getDefaultExecuteBatch", new Class[0]);
                this.getDefaultExecuteBatch.set(m);
            }
            tempProps.put("DefaultExecuteBatch", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getDefaultRowPrefetch.get();
            if (m == null) {
                m = c.getMethod("getDefaultRowPrefetch", new Class[0]);
                this.getDefaultRowPrefetch.set(m);
            }
            tempProps.put("DefaultRowPrefetch", m.invoke((Object)sqlConn, new Object[0]));
            if (this.driverMajorVersion > 10) {
                m = this.getDefaultTimeZone.get();
                if (m == null) {
                    m = c.getMethod("getDefaultTimeZone", new Class[0]);
                    this.getDefaultTimeZone.set(m);
                }
                tempProps.put("DefaultTimeZone", m.invoke((Object)sqlConn, new Object[0]));
            }
            if ((m = this.getIncludeSynonyms.get()) == null) {
                m = c.getMethod("getIncludeSynonyms", new Class[0]);
                this.getIncludeSynonyms.set(m);
            }
            tempProps.put("IncludeSynonyms", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getRemarksReporting.get();
            if (m == null) {
                m = c.getMethod("getRemarksReporting", new Class[0]);
                this.getRemarksReporting.set(m);
            }
            tempProps.put("RemarksReporting", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getRestrictGetTables.get();
            if (m == null) {
                m = c.getMethod("getRestrictGetTables", new Class[0]);
                this.getRestrictGetTables.set(m);
            }
            tempProps.put("RestrictGetTables", m.invoke((Object)sqlConn, new Object[0]));
            m = this.getSessionTimeZone.get();
            if (m == null) {
                m = c.getMethod("getSessionTimeZone", new Class[0]);
                this.getSessionTimeZone.set(m);
            }
            tempProps.put("SessionTimeZone", m.invoke((Object)sqlConn, new Object[0]));
            return tempProps;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        boolean result;
        boolean trace;
        block11: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[0]);
            }
            result = false;
            try {
                Class c = this.OracleConnection.get();
                if (c == null) {
                    c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OracleConnection);
                    this.OracleConnection.set(c);
                }
                if (!c.isInstance(conn)) break block11;
                try {
                    Method m = this.isProxySession.get();
                    if (m == null) {
                        m = c.getMethod("isProxySession", new Class[0]);
                        this.isProxySession.set(m);
                    }
                    if (((Boolean)m.invoke((Object)conn, new Object[0])).booleanValue()) {
                        m = this.close.get();
                        if (m == null) {
                            m = c.getMethod("close", Integer.TYPE);
                            this.close.set(m);
                        }
                        m.invoke((Object)conn, 1);
                        result = true;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw AdapterUtil.toSQLException(x);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((TraceComponent)tc, (String)"doConnectionCleanup", (Object)result);
        }
        return result;
    }

    @Override
    public boolean doConnectionVendorPropertyReset(Connection sqlConn, Map<String, Object> props) throws SQLException {
        try {
            Method m;
            Class c = this.OracleConnection.get();
            if (c == null) {
                c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OracleConnection);
                this.OracleConnection.set(c);
            }
            if ((m = this.setDefaultExecuteBatch.get()) == null) {
                m = c.getMethod("setDefaultExecuteBatch", Integer.TYPE);
                this.setDefaultExecuteBatch.set(m);
            }
            m.invoke((Object)sqlConn, props.get("DefaultExecuteBatch"));
            m = this.setDefaultRowPrefetch.get();
            if (m == null) {
                m = c.getMethod("setDefaultRowPrefetch", Integer.TYPE);
                this.setDefaultRowPrefetch.set(m);
            }
            m.invoke((Object)sqlConn, props.get("DefaultRowPrefetch"));
            if (this.driverMajorVersion > 10) {
                m = this.setDefaultTimeZone.get();
                if (m == null) {
                    m = c.getMethod("setDefaultTimeZone", TimeZone.class);
                    this.setDefaultTimeZone.set(m);
                }
                m.invoke((Object)sqlConn, props.get("DefaultTimeZone"));
            }
            if ((m = this.setIncludeSynonyms.get()) == null) {
                m = c.getMethod("setIncludeSynonyms", Boolean.TYPE);
                this.setIncludeSynonyms.set(m);
            }
            m.invoke((Object)sqlConn, props.get("IncludeSynonyms"));
            m = this.setRemarksReporting.get();
            if (m == null) {
                m = c.getMethod("setRemarksReporting", Boolean.TYPE);
                this.setRemarksReporting.set(m);
            }
            m.invoke((Object)sqlConn, props.get("RemarksReporting"));
            m = this.setRestrictGetTables.get();
            if (m == null) {
                m = c.getMethod("setRestrictGetTables", Boolean.TYPE);
                this.setRestrictGetTables.set(m);
            }
            m.invoke((Object)sqlConn, props.get("RestrictGetTables"));
            String s = (String)props.get("SessionTimeZone");
            if (s == null) {
                s = TimeZone.getDefault().getID();
            }
            if ((m = this.setSessionTimeZone.get()) == null) {
                m = c.getMethod("setSessionTimeZone", String.class);
                this.setSessionTimeZone.set(m);
            }
            m.invoke((Object)sqlConn, s);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
        return true;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        Class c;
        Method m;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doStatementCleanup", (Object[])new Object[0]);
        }
        if (stmt.getFetchDirection() != 1000) {
            stmt.setFetchDirection(1000);
        }
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
        try {
            m = this.clearDefines.get();
            if (m == null) {
                c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OraclePreparedStatement);
                m = c.getMethod("clearDefines", new Class[0]);
                this.clearDefines.set(m);
            }
            m.invoke((Object)stmt, new Object[0]);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
        try {
            m = this.getDefaultRowPrefetch.get();
            if (m == null) {
                c = this.OracleConnection.get();
                if (c == null) {
                    c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OracleConnection);
                    this.OracleConnection.set(c);
                }
                m = c.getMethod("getDefaultRowPrefetch", new Class[0]);
                this.getDefaultRowPrefetch.set(m);
            }
            Object defaultRowPrefetch = m.invoke((Object)stmt.getConnection(), new Object[0]);
            m = this.setRowPrefetch.get();
            if (m == null) {
                Class c2 = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OraclePreparedStatement);
                m = c2.getMethod("setRowPrefetch", Integer.TYPE);
                this.setRowPrefetch.set(m);
            }
            m.invoke((Object)stmt, defaultRowPrefetch);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
        if (this.driverMajorVersion == -99) {
            DatabaseMetaData metadata = stmt.getConnection().getMetaData();
            this.driverMajorVersion = metadata.getDriverMajorVersion();
            this.driverMinorVersion = metadata.getDriverMinorVersion();
        }
        if (this.driverMajorVersion > 11 || this.driverMajorVersion == 11 && this.driverMinorVersion >= 2) {
            try {
                m = this.setLobPrefetchSize.get();
                if (m == null) {
                    c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OraclePreparedStatement);
                    m = c.getMethod("setLobPrefetchSize", Integer.TYPE);
                    this.setLobPrefetchSize.set(m);
                }
                m.invoke((Object)stmt, 4000);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw AdapterUtil.toSQLException(x);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doStatementCleanup");
        }
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public String getXAExceptionContents(XAException xae) {
        StringBuilder xsb;
        block4: {
            xsb = new StringBuilder(350);
            try {
                Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, "oracle.jdbc.xa.OracleXAException");
                if (c.isInstance(xae)) {
                    int xaerror = (Integer)c.getMethod("getXAError", new Class[0]).invoke((Object)xae, new Object[0]);
                    int oraerr = (Integer)c.getMethod("getOracleError", new Class[0]).invoke((Object)xae, new Object[0]);
                    Method getXAErrorMessage = c.getMethod("getXAErrorMessage", Integer.TYPE);
                    String EOLN = AdapterUtil.EOLN;
                    xsb.append(EOLN).append("The XA Error is            : ").append(xaerror).append(EOLN);
                    xsb.append("The XA Error message is    : ").append(getXAErrorMessage.invoke(null, xaerror)).append(EOLN);
                    xsb.append("The Oracle Error code is   : ").append(oraerr).append(EOLN);
                    xsb.append("The Oracle Error message is: ").append(getXAErrorMessage.invoke(null, oraerr)).append(EOLN);
                }
            }
            catch (Exception x) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"getXAExceptionContents", (Object[])new Object[]{x});
            }
        }
        if (xae.getCause() != null) {
            xsb.append("The cause is               : ").append(xae.getCause());
        }
        return xsb.toString();
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || 1004 == x.getErrorCode() || 1005 == x.getErrorCode() || 1017 == x.getErrorCode();
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return oraTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !oraTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public void disableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        block3: {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Disabling logging on Oracle10g and later", (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        OracleHelper.this.setTrace(false);
                        return null;
                    }
                });
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"enableJdbcLogging failed to enable trace in Oracle, execution will continue", (Object[])new Object[]{x});
            }
        }
        mc.mcf.loggingEnabled = false;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        block3: {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"Enabling logging on Oracle10g and later", (Object[])new Object[0]);
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        OracleHelper.this.setTrace(true);
                        return null;
                    }
                });
            }
            catch (Exception x) {
                FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"236", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                com.ibm.websphere.ras.Tr.debug((TraceComponent)oraTc, (String)"enableJdbcLogging failed to enable trace in Oracle, execution will continue", (Object[])new Object[]{x});
            }
        }
        mcf.loggingEnabled = true;
    }

    @Override
    public void enableJdbcLogging(WSRdbManagedConnectionImpl mc) throws ResourceException {
        this.enableJdbcLogging(mc.mcf);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        return null;
    }

    @Override
    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        if (externalCall) {
            if (readOnly) {
                throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", "setReadOnly", Connection.class.getName()));
            }
            com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"ORA_READONLY", (Object[])new Object[0]);
        } else if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly ignored for internal call", (Object[])new Object[0]);
        }
    }

    @Override
    public void psSetBytes(PreparedStatement pstmtImpl, int i, byte[] x) throws SQLException {
        int length;
        int n = length = x == null ? 0 : x.length;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("psSetBytes: " + length), (Object[])new Object[0]);
        }
        if (x != null && length > 2000) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"ORACLE setBytes byte array length > 2000 workaround.", (Object[])new Object[0]);
            }
            pstmtImpl.setBinaryStream(i, (InputStream)new ByteArrayInputStream(x), length);
        } else {
            pstmtImpl.setBytes(i, x);
        }
    }

    @Override
    public void psSetString(PreparedStatement pstmtImpl, int i, String x) throws SQLException {
        int length;
        int n = length = x == null ? 0 : x.getBytes().length;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("string length: " + length), (Object[])new Object[0]);
        }
        if (length > 4000) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Oracle setString length > 4000 bytes workaround.", (Object[])new Object[0]);
            }
            pstmtImpl.setCharacterStream(i, (Reader)new StringReader(x), x.length());
        } else {
            pstmtImpl.setString(i, x);
        }
    }

    private void setKerberosDatasourceProperties(CommonDataSource ds) throws ResourceException {
        try {
            Properties connProps;
            if (this.setConnectionProperties == null) {
                this.getConnectionProperties = lookup.findVirtual(ds.getClass(), "getConnectionProperties", MethodType.methodType(Properties.class));
                this.setConnectionProperties = lookup.findVirtual(ds.getClass(), "setConnectionProperties", MethodType.methodType(Void.TYPE, Properties.class));
            }
            if ((connProps = this.getConnectionProperties.invoke(ds)) == null) {
                connProps = new Properties();
            }
            if (!connProps.containsKey("oracle.net.authentication_services") && !connProps.containsKey("oracle.net.kerberos5_mutual_authentication")) {
                connProps.put("oracle.net.authentication_services", "( KERBEROS5 )");
                connProps.put("oracle.net.kerberos5_mutual_authentications", "true");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"Automatically setting kerberos connectionProperties for Oracle: ", (Object[])new Object[]{connProps});
                }
                this.setConnectionProperties.invoke(ds, connProps);
            }
        }
        catch (Throwable e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public Connection getConnectionFromDatasource(DataSource ds, WSManagedConnectionFactoryImpl.KerbUsage useKerb, Object gssCredential) throws SQLException {
        if (useKerb != WSManagedConnectionFactoryImpl.KerbUsage.NONE) {
            try {
                OracleHelper.checkIBMJava8();
                this.setKerberosDatasourceProperties(ds);
            }
            catch (ResourceException ex) {
                throw AdapterUtil.toSQLException(ex);
            }
        }
        return super.getConnectionFromDatasource(ds, useKerb, gssCredential);
    }

    @Override
    public ConnectionResults getPooledConnection(CommonDataSource ds, String userName, String password, boolean is2Phase, WSConnectionRequestInfoImpl cri, WSManagedConnectionFactoryImpl.KerbUsage useKerberos, Object gssCredential) throws ResourceException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object[])new Object[]{AdapterUtil.toString(ds), userName, "******", is2Phase ? "two-phase" : "one-phase", cri, useKerberos, gssCredential});
        }
        if (useKerberos != WSManagedConnectionFactoryImpl.KerbUsage.NONE) {
            OracleHelper.checkIBMJava8();
            this.setKerberosDatasourceProperties(ds);
        }
        ConnectionResults results = super.getPooledConnection(ds, userName, password, is2Phase, cri, useKerberos, gssCredential);
        if (isTraceOn && tc.isEntryEnabled()) {
            com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"getPooledConnection", (Object)results);
        }
        return results;
    }

    private static void checkIBMJava8() throws ResourceException {
        if (JavaInfo.majorVersion() == 8 && JavaInfo.vendor() == JavaInfo.Vendor.IBM) {
            com.ibm.websphere.ras.Tr.error((TraceComponent)tc, (String)"KERBEROS_ORACLE_IBMJDK_NOT_SUPPORTED", (Object[])new Object[0]);
            throw new ResourceException(AdapterUtil.getNLSMessage("KERBEROS_ORACLE_IBMJDK_NOT_SUPPORTED"));
        }
    }

    @Override
    public int getHoldability(Connection conn) throws SQLException {
        int holdability = 0;
        if (tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{AdapterUtil.toString(conn)});
        }
        try {
            if (this.holdabilitySupported) {
                holdability = conn.getHoldability();
                return holdability;
            }
            return 0;
        }
        catch (AbstractMethodError ame) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError"});
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 17023) {
                if (tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{"getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException: " + sqle.getMessage()});
                }
                this.holdabilitySupported = false;
                return 0;
            }
            throw sqle;
        }
    }

    @Override
    public void setClientInformationArray(String[] clientInfoArray, WSRdbManagedConnectionImpl mc, boolean explicitCall) throws SQLException {
        if (explicitCall) {
            mc.clientInfoExplicitlySet = true;
        } else {
            mc.clientInfoImplicitlySet = true;
        }
        this.matrix[1] = clientInfoArray[0];
        this.setEndToEndMetrics(mc.sqlConn, this.matrix, (short)0);
    }

    @Override
    public void resetClientInformation(WSRdbManagedConnectionImpl mc) throws SQLException {
        if (mc.clientInfoExplicitlySet || mc.clientInfoImplicitlySet) {
            if (tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object[])new Object[]{mc});
            }
            this.matrix[1] = null;
            this.setEndToEndMetrics(mc.sqlConn, this.matrix, (short)0);
            mc.clientInfoExplicitlySet = false;
            mc.clientInfoImplicitlySet = false;
        }
    }

    public void setEndToEndMetrics(Connection sqlConn, String[] matrix, short s) throws SQLException {
        try {
            Method m = this.setEndToEndMetrics.get();
            if (m == null) {
                Class c = this.OracleConnection.get();
                if (c == null) {
                    c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_OracleConnection);
                    this.OracleConnection.set(c);
                }
                m = c.getMethod("setEndToEndMetrics", String[].class, Short.TYPE);
                this.setEndToEndMetrics.set(m);
            }
            m.invoke(WSJdbcTracer.getImpl(sqlConn), matrix, s);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    private void setTrace(boolean b) {
        try {
            Class c = WSManagedConnectionFactoryImpl.priv.loadClass(this.mcf.jdbcDriverLoader, oracle_jdbc_driver_OracleLog);
            c.getMethod("setTrace", Boolean.TYPE).invoke(null, b);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x instanceof InvocationTargetException ? x.getCause() : x);
        }
    }
}

