/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.DB2Helper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;

public class DB2iNativeHelper
extends DB2Helper {
    private static TraceComponent tc = Tr.register(DB2iNativeHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final AtomicReference<Class<?>> com_ibm_db2_jdbc_app_DB2ConnectionHandle_class = new AtomicReference();
    private final AtomicReference<Class<?>> com_ibm_db2_jdbc_app_UDBConnectionHandle_class = new AtomicReference();
    private final AtomicReference<Method> DB2ConnectionHandle_getServerJobName = new AtomicReference();
    private final AtomicReference<Method> UDBConnectionHandle_getServerJobName = new AtomicReference();
    boolean isolationLevelSwitchingSupport = false;
    boolean switchingSupportDetermined = false;
    private String os400Version_;
    private int os400VersionNum_;

    DB2iNativeHelper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        this.dataStoreHelper = "com.ibm.websphere.rsadapter.DB2AS400DataStoreHelper";
        Properties props = mcf.dsConfig.get().vendorProps;
        String switchingSupported = (String)props.get("isolationLevelSwitchingSupport");
        if (switchingSupported != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("isolationSwitchingSupported property = " + switchingSupported), (Object[])new Object[0]);
            }
            this.isolationLevelSwitchingSupport = Boolean.valueOf(switchingSupported);
            this.switchingSupportDetermined = true;
        }
        Collections.addAll(this.staleConCodes, "HY017");
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        block8: {
            SQLWarning warn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup", (Object[])new Object[0]);
            }
            if ((warn = conn.getWarnings()) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): no warnings to cleanup", (Object[])new Object[0]);
                }
            } else {
                try {
                    conn.clearWarnings();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings done", (Object[])new Object[0]);
                    }
                }
                catch (SQLException se) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): cleanup of warnings failed", (Object[])new Object[]{se});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup");
        }
        return false;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setCursorName(null);
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public String getCorrelator(final WSRdbManagedConnectionImpl mc) throws SQLException {
        block14: {
            try {
                Class<?> c = this.com_ibm_db2_jdbc_app_DB2ConnectionHandle_class.get();
                if (c == null) {
                    if (System.getSecurityManager() == null) {
                        c = mc.mcf.jdbcDriverLoader.loadClass("com.ibm.db2.jdbc.app.DB2ConnectionHandle");
                        this.com_ibm_db2_jdbc_app_DB2ConnectionHandle_class.set(c);
                    } else {
                        c = (Class<?>)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                            @Override
                            public Class<?> run() throws ClassNotFoundException {
                                return mc.mcf.jdbcDriverLoader.loadClass("com.ibm.db2.jdbc.app.DB2ConnectionHandle");
                            }
                        });
                        this.com_ibm_db2_jdbc_app_DB2ConnectionHandle_class.set(c);
                    }
                }
                if (c.isInstance(mc.sqlConn)) {
                    Method m = this.DB2ConnectionHandle_getServerJobName.get();
                    if (m == null) {
                        m = c.getMethod("getServerJobName", new Class[0]);
                        this.DB2ConnectionHandle_getServerJobName.set(m);
                    }
                    return (String)m.invoke((Object)mc.sqlConn, new Object[0]);
                }
                c = this.com_ibm_db2_jdbc_app_UDBConnectionHandle_class.get();
                if (c == null) {
                    if (System.getSecurityManager() == null) {
                        c = mc.mcf.jdbcDriverLoader.loadClass("com.ibm.db2.jdbc.app.UDBConnectionHandle");
                        this.com_ibm_db2_jdbc_app_UDBConnectionHandle_class.set(c);
                    } else {
                        c = (Class<?>)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                            @Override
                            public Class<?> run() throws ClassNotFoundException {
                                return mc.mcf.jdbcDriverLoader.loadClass("com.ibm.db2.jdbc.app.UDBConnectionHandle");
                            }
                        });
                        this.com_ibm_db2_jdbc_app_DB2ConnectionHandle_class.set(c);
                    }
                }
                if (c.isInstance(mc.sqlConn)) {
                    Method m = this.UDBConnectionHandle_getServerJobName.get();
                    if (m == null) {
                        m = c.getMethod("getServerJobName", new Class[0]);
                        this.UDBConnectionHandle_getServerJobName.set(m);
                    }
                    return (String)m.invoke((Object)mc.sqlConn, new Object[0]);
                }
            }
            catch (NullPointerException npx) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobName()", npx, "method not supported on DB2 driver being used"});
            }
            catch (NoSuchMethodError nsex) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobName()", nsex, "method not supported on DB2 driver being used"});
            }
            catch (Exception e) {
                Tr.warning((TraceComponent)tc, (String)"DSA_GENERIC_MSG", (Object[])new Object[]{"getServerJobName()", e, "method may not be supported on DB2 driver being used"});
                if (!(e.getCause() instanceof SQLException)) break block14;
                AdapterUtil.mapSQLException((SQLException)e.getCause(), mc);
            }
        }
        return null;
    }

    protected static final int generateVersionNumber(String s) {
        int i = -1;
        StringTokenizer stringtokenizer = new StringTokenizer(s, "VRM", false);
        if (stringtokenizer.countTokens() == 3) {
            String s1 = stringtokenizer.nextToken();
            s1 = s1 + stringtokenizer.nextToken();
            s1 = s1 + stringtokenizer.nextToken();
            i = Integer.parseInt(s1);
        }
        return i;
    }

    @Override
    public boolean isIsolationLevelSwitchingSupport() {
        if (!this.switchingSupportDetermined) {
            this.os400Version_ = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.version");
                }
            });
            this.os400VersionNum_ = DB2iNativeHelper.generateVersionNumber(this.os400Version_);
            if (this.os400VersionNum_ >= 530) {
                this.isolationLevelSwitchingSupport = true;
            }
            this.switchingSupportDetermined = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isolationSwitchingSupported has a value of " + this.isolationLevelSwitchingSupport), (Object[])new Object[0]);
        }
        return this.isolationLevelSwitchingSupport;
    }
}

