/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class JsJmsMessageFactory {
    private static TraceComponent tc = SibTr.register(JsJmsMessageFactory.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JsJmsMessageFactory instance = null;
    private static Exception createException = null;

    public static JsJmsMessageFactory getInstance() throws Exception {
        if (instance == null) {
            throw createException;
        }
        return instance;
    }

    public abstract JsJmsMessage createJmsMessage() throws MessageCreateFailedException;

    public abstract JsJmsBytesMessage createJmsBytesMessage() throws MessageCreateFailedException;

    public abstract JsJmsMapMessage createJmsMapMessage() throws MessageCreateFailedException;

    public abstract JsJmsObjectMessage createJmsObjectMessage() throws MessageCreateFailedException;

    public abstract JsJmsStreamMessage createJmsStreamMessage() throws MessageCreateFailedException;

    public abstract JsJmsTextMessage createJmsTextMessage() throws MessageCreateFailedException;

    private static void createFactoryInstance() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createFactoryInstance");
        }
        try {
            Class<?> cls = Class.forName("com.ibm.ws.sib.mfp.impl.JsJmsMessageFactoryImpl");
            instance = (JsJmsMessageFactory)cls.newInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.JsJmsMessageFactory.createFactoryInstance", (String)"133");
            SibTr.error((TraceComponent)tc, (String)"UNABLE_TO_CREATE_JMSFACTORY_CWSIF0011", (Object)e);
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createFactoryInstance");
        }
    }

    static {
        try {
            JsJmsMessageFactory.createFactoryInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.JsJmsMessageFactory.<clinit>", (String)"62");
            createException = e;
        }
    }
}

