/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.endpoint.JaxWsPublisherContext;
import com.ibm.ws.jaxws.metadata.EndpointType;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilder;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.support.LibertyJaxWsImplementorInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.InfoStoreException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.JAXWSMethodDispatcher;
import org.apache.cxf.jaxws.JAXWSProviderMethodDispatcher;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.jaxws.support.WebServiceProviderConfiguration;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.DescriptionInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsServiceFactoryBean
extends JaxWsServiceFactoryBean {
    private static final TraceComponent tc = Tr.register(LibertyJaxWsServiceFactoryBean.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static final String URI_POLICY_NS = "http://www.w3.org/ns/ws-policy";
    private static final String URI_WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private AbstractServiceConfiguration jaxWsConfiguration;
    private final JaxWsPublisherContext publisherContext;
    private LibertyJaxWsImplementorInfo implInfo;
    private List<WebServiceFeature> setWsFeatures;
    private final List<WebServiceFeature> wsFeatures = new ArrayList<WebServiceFeature>();
    static final long serialVersionUID = 7352129168340617506L;

    public LibertyJaxWsServiceFactoryBean(LibertyJaxWsImplementorInfo implInfo, JaxWsPublisherContext publisherContext) {
        super((JaxWsImplementorInfo)implInfo);
        this.publisherContext = publisherContext;
        this.implInfo = implInfo;
        this.initializeConfig(this.implInfo);
        this.serviceClass = implInfo.getEndpointClass();
        this.serviceType = implInfo.getSEIType();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServiceClass(Class<?> serviceClass) {
        if (serviceClass == null) {
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"The service class is null", (Object[])new Object[0]);
            return;
        }
        EndpointInfoBuilder builder = (EndpointInfoBuilder)this.publisherContext.getAttribute("ENDPOINT_INFO_BUILDER");
        EndpointInfoBuilderContext context = (EndpointInfoBuilderContext)this.publisherContext.getAttribute("ENDPOINT_INFO_BUILDER_CONTEXT");
        if (null != builder && null != context) {
            block13: {
                try {
                    context.getInfoStore().open();
                    this.setJaxWsImplementorInfo(new LibertyJaxWsImplementorInfo(serviceClass, builder.build(context, serviceClass.getName(), EndpointType.SERVLET), this.publisherContext));
                }
                catch (InfoStoreException e) {
                    try {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean", (String)"108", (Object)((Object)this), (Object[])new Object[]{serviceClass});
                        throw new WebServiceException((Throwable)e);
                        catch (ClassNotFoundException e5333332) {
                            FFDCFilter.processException((Throwable)e5333332, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean", (String)"110", (Object)((Object)this), (Object[])new Object[]{serviceClass});
                            throw new WebServiceException(Tr.formatMessage((TraceComponent)tc, (String)"err.unable.set.serviceclass", (Object[])new Object[]{serviceClass}), (Throwable)e5333332);
                        }
                        catch (Exception e3) {
                            FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean", (String)"112", (Object)((Object)this), (Object[])new Object[]{serviceClass});
                            throw new WebServiceException((Throwable)e3);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            context.getInfoStore().close();
                            throw throwable;
                        }
                        catch (InfoStoreException infoStoreException) {
                            void e4;
                            FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean", (String)"117", (Object)((Object)this), (Object[])new Object[]{serviceClass});
                            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                            if (!tc.isDebugEnabled()) throw throwable;
                            Tr.debug((TraceComponent)tc, (String)"The exception occurs when close the infoStore.", (Object[])new Object[]{e4});
                        }
                        throw throwable;
                    }
                }
                try {
                    context.getInfoStore().close();
                }
                catch (InfoStoreException infoStoreException) {
                    void e;
                    FFDCFilter.processException((Throwable)infoStoreException, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean", (String)"117", (Object)((Object)this), (Object[])new Object[]{serviceClass});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)"The exception occurs when close the infoStore.", (Object[])new Object[]{e});
                }
            }
            this.serviceClass = this.getJaxWsImplementorInfo().getEndpointClass();
            this.checkServiceClassAnnotations(this.serviceClass);
            this.serviceType = this.implInfo.getSEIType();
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Invoke the setServiceClass method from " + super.getClass().getName()), (Object[])new Object[0]);
        }
        super.setServiceClass(serviceClass);
    }

    public Service create() {
        Service s = super.create();
        s.put((Object)"endpoint.class", this.implInfo.getEndpointClass());
        if (s.getDataBinding() != null) {
            this.setMTOMFeatures(s.getDataBinding());
        }
        return s;
    }

    private void setMTOMFeatures(DataBinding databinding) {
        if (this.wsFeatures != null) {
            for (WebServiceFeature wsf : this.wsFeatures) {
                if (!(wsf instanceof MTOMFeature)) continue;
                databinding.setMtomEnabled(true);
                MTOMFeature f = (MTOMFeature)wsf;
                if (f.getThreshold() <= 0) continue;
                databinding.setMtomThreshold(((MTOMFeature)wsf).getThreshold());
            }
        }
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        JaxWsEndpointImpl ep = new JaxWsEndpointImpl(this.getBus(), this.getService(), ei, (JaxWsImplementorInfo)this.implInfo, this.wsFeatures, this.getFeatures(), true);
        if (null != ei && !this.isFromWsdl()) {
            JaxWsEndpointImplHelper helper = new JaxWsEndpointImplHelper(ep, ei);
            helper.buildWsdlExtensibilities();
            helper.extractWsdlExtensibilities();
        }
        this.sendEvent(FactoryBeanListener.Event.ENDPOINT_CREATED, new Object[]{ei, ep});
        return ep;
    }

    public void setWsFeatures(List<WebServiceFeature> swsFeatures) {
        this.setWsFeatures = swsFeatures;
        if (null != swsFeatures) {
            this.wsFeatures.addAll(swsFeatures);
        }
    }

    public void setJaxWsImplementorInfo(JaxWsImplementorInfo jaxWsImplementorInfo) {
        if (jaxWsImplementorInfo instanceof LibertyJaxWsImplementorInfo) {
            this.implInfo = (LibertyJaxWsImplementorInfo)jaxWsImplementorInfo;
            this.initializeConfig(this.implInfo);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invoke the setJaxWsImplementorInfo from " + super.getClass().getName()), (Object[])new Object[0]);
            }
            super.setJaxWsImplementorInfo(jaxWsImplementorInfo);
        }
    }

    protected void initializeConfig(JaxWsImplementorInfo jaxWsImplementorInfo) {
        if (jaxWsImplementorInfo.isWebServiceProvider()) {
            this.jaxWsConfiguration = new WebServiceProviderConfiguration();
            this.jaxWsConfiguration.setServiceFactory((ReflectionServiceFactoryBean)this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            this.setWrapped(false);
            this.setDataBinding((DataBinding)new SourceDataBinding());
            this.setMethodDispatcher((MethodDispatcher)new JAXWSProviderMethodDispatcher(jaxWsImplementorInfo));
        } else {
            XmlSchema schema;
            this.jaxWsConfiguration = new JaxWsServiceConfiguration();
            this.jaxWsConfiguration.setServiceFactory((ReflectionServiceFactoryBean)this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            Class seiClass = jaxWsImplementorInfo.getEndpointClass();
            if (seiClass != null && seiClass.getPackage() != null && (schema = seiClass.getPackage().getAnnotation(XmlSchema.class)) != null && XmlNsForm.QUALIFIED.equals((Object)schema.elementFormDefault())) {
                this.setQualifyWrapperSchema(true);
            }
            this.setMethodDispatcher((MethodDispatcher)new JAXWSMethodDispatcher(jaxWsImplementorInfo));
        }
        this.loadWSFeatureAnnotation();
    }

    private void loadWSFeatureAnnotation() {
        ArrayList<Object> features = new ArrayList<Object>();
        features.add(this.implInfo.getMTOMFeature());
        features.add(this.implInfo.getAddressingFeature());
        features.add(this.implInfo.getRespectBindingFeature());
        for (int i = 0; i < features.size(); ++i) {
            if (null == features.get(i)) continue;
            this.wsFeatures.add((WebServiceFeature)features.get(i));
        }
        if (this.setWsFeatures != null) {
            this.wsFeatures.addAll(this.setWsFeatures);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JaxWsEndpointImplHelper {
        private final JaxWsEndpointImpl endpoint;
        private final EndpointInfo endpointInfo;
        private final BindingInfo bindingInfo;
        static final long serialVersionUID = 7808847248819044400L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JaxWsEndpointImplHelper(JaxWsEndpointImpl endpoint, EndpointInfo endpointInfo) {
            this.endpoint = endpoint;
            this.endpointInfo = endpointInfo;
            this.bindingInfo = endpointInfo.getBinding();
        }

        /*
         * WARNING - void declaration
         */
        public void buildWsdlExtensibilities() {
            block6: {
                AddressingFeature addressing = this.getAddressFeature();
                if (addressing != null) {
                    ExtensionRegistry extensionRegistry = ((WSDLManager)LibertyJaxWsServiceFactoryBean.this.getBus().getExtension(WSDLManager.class)).getExtensionRegistry();
                    try {
                        ExtensibilityElement el = extensionRegistry.createExtension(Binding.class, JAXWSAConstants.WSAW_USINGADDRESSING_QNAME);
                        el.setRequired(Boolean.valueOf(addressing.isRequired()));
                        this.bindingInfo.addExtensor((Object)el);
                        StringBuilder polRefId = new StringBuilder(this.bindingInfo.getName().getLocalPart());
                        polRefId.append("_WSAM_Addressing_Policy");
                        UnknownExtensibilityElement uel = new UnknownExtensibilityElement();
                        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                        writer.writeStartElement("wsp", "PolicyReference", LibertyJaxWsServiceFactoryBean.URI_POLICY_NS);
                        writer.writeAttribute("URI", "#" + polRefId.toString());
                        writer.writeEndElement();
                        Element pr = writer.getDocument().getDocumentElement();
                        uel.setElement(pr);
                        uel.setElementType(DOMUtils.getElementQName((Element)pr));
                        this.bindingInfo.addExtensor((Object)uel);
                        writer = new W3CDOMStreamWriter();
                        writer.writeStartElement("wsp", "Policy", LibertyJaxWsServiceFactoryBean.URI_POLICY_NS);
                        writer.writeAttribute("wsu", LibertyJaxWsServiceFactoryBean.URI_WSU_NS, "Id", polRefId.toString());
                        writer.writeStartElement("wsam", "Addressing", "http://www.w3.org/2007/05/addressing/metadata");
                        if (!addressing.isRequired()) {
                            writer.writeAttribute("wsp", LibertyJaxWsServiceFactoryBean.URI_POLICY_NS, "Optional", "true");
                        }
                        writer.writeStartElement("wsp", "Policy", LibertyJaxWsServiceFactoryBean.URI_POLICY_NS);
                        String s = this.getAddressingFeatureRequirement(addressing);
                        if (s != null) {
                            writer.writeEmptyElement("wsam", s, "http://www.w3.org/2007/05/addressing/metadata");
                        }
                        writer.writeEndElement();
                        writer.writeEndElement();
                        writer.writeEndElement();
                        pr = writer.getDocument().getDocumentElement();
                        uel = new UnknownExtensibilityElement();
                        uel.setElement(pr);
                        uel.setElementType(DOMUtils.getElementQName((Element)pr));
                        if (this.bindingInfo.getService().getDescription() == null) {
                            DescriptionInfo description = new DescriptionInfo();
                            description.setName(this.bindingInfo.getService().getName());
                            this.bindingInfo.getService().setDescription(description);
                        }
                        this.bindingInfo.getService().getDescription().addExtensor((Object)uel);
                    }
                    catch (Exception el) {
                        void e;
                        FFDCFilter.processException((Throwable)el, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean$JaxWsEndpointImplHelper", (String)"310", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug((TraceComponent)tc, (String)"The exception is encountered when buildWsdlExtensibilities.", (Object[])new Object[]{e});
                    }
                }
            }
        }

        private AddressingFeature getAddressFeature() {
            for (WebServiceFeature wsFeature : LibertyJaxWsServiceFactoryBean.this.wsFeatures) {
                if (!(wsFeature instanceof AddressingFeature)) continue;
                return (AddressingFeature)wsFeature;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private String getAddressingFeatureRequirement(AddressingFeature addressingFeature) {
            block5: {
                try {
                    AddressingFeature.Responses o = addressingFeature.getResponses();
                    if (o != null) {
                        String s = o.toString();
                        if ("ANONYMOUS".equals(s)) {
                            return "AnonymousResponses";
                        }
                        if ("NON_ANONYMOUS".equals(s)) {
                            return "NonAnonymousResponses";
                        }
                    }
                }
                catch (Throwable o) {
                    void ex;
                    FFDCFilter.processException((Throwable)o, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean$JaxWsEndpointImplHelper", (String)"338", (Object)this, (Object[])new Object[]{addressingFeature});
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"The error is encountered when get the Responses of the AddressingFeature, probably using JAX-WS 2.1", (Object[])new Object[]{ex});
                }
            }
            return null;
        }

        public void extractWsdlExtensibilities() {
            List bindingExtensors = this.endpointInfo.getBinding().getExtensors(ExtensibilityElement.class);
            List portExtensors = this.endpointInfo.getExtensors(ExtensibilityElement.class);
            if (this.hasUsingAddressing(bindingExtensors) || this.hasUsingAddressing(portExtensors)) {
                WSAddressingFeature feature = new WSAddressingFeature();
                if (this.addressingRequired(bindingExtensors) || this.addressingRequired(portExtensors)) {
                    feature.setAddressingRequired(true);
                }
                this.addAddressingFeature((AbstractFeature)feature);
            }
            this.extractWsdlEprs();
        }

        private boolean hasUsingAddressing(List<ExtensibilityElement> exts) {
            boolean found = false;
            if (exts != null) {
                Iterator<ExtensibilityElement> extensionElements = exts.iterator();
                while (extensionElements.hasNext() && !found) {
                    ExtensibilityElement ext = extensionElements.next();
                    found = JAXWSAConstants.WSAW_USINGADDRESSING_QNAME.equals(ext.getElementType());
                }
            }
            return found;
        }

        private boolean addressingRequired(List<ExtensibilityElement> exts) {
            boolean found = false;
            if (exts != null) {
                Iterator<ExtensibilityElement> extensionElements = exts.iterator();
                while (extensionElements.hasNext() && !found) {
                    ExtensibilityElement ext = extensionElements.next();
                    if (!JAXWSAConstants.WSAW_USINGADDRESSING_QNAME.equals(ext.getElementType()) || ext.getRequired() == null) continue;
                    return ext.getRequired();
                }
            }
            return false;
        }

        private void extractWsdlEprs() {
            List portExtensors = this.endpointInfo.getExtensors(ExtensibilityElement.class);
            if (portExtensors != null) {
                Iterator extensionElements = portExtensors.iterator();
                QName wsaEpr = new QName("http://www.w3.org/2005/08/addressing", "EndpointReference");
                while (extensionElements.hasNext()) {
                    ExtensibilityElement ext = (ExtensibilityElement)extensionElements.next();
                    if (!(ext instanceof UnknownExtensibilityElement) || !wsaEpr.equals(ext.getElementType())) continue;
                    DOMSource domSource = new DOMSource(((UnknownExtensibilityElement)ext).getElement());
                    W3CEndpointReference w3cEPR = new W3CEndpointReference((Source)domSource);
                    EndpointReferenceType ref = ProviderImpl.convertToInternal((EndpointReference)w3cEPR);
                    this.endpointInfo.getTarget().setMetadata(ref.getMetadata());
                    this.endpointInfo.getTarget().setReferenceParameters(ref.getReferenceParameters());
                    this.endpointInfo.getTarget().getOtherAttributes().putAll(ref.getOtherAttributes());
                }
            }
        }

        private void addAddressingFeature(AbstractFeature feature) {
            if (this.endpoint.getFeatures() == null || this.endpoint.getFeatures().isEmpty()) {
                this.endpoint.getFeatures().add(feature);
            } else {
                for (AbstractFeature f : this.endpoint.getFeatures()) {
                    if (!(f instanceof WSAddressingFeature)) continue;
                    return;
                }
                this.endpoint.getFeatures().add(feature);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.support.LibertyJaxWsServiceFactoryBean$JaxWsEndpointImplHelper", JaxWsEndpointImplHelper.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
        }
    }
}

