/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.resource.ResourceResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoJSR250Annotations
public class BusApplicationContextResourceResolver
implements ResourceResolver,
ApplicationContextAware {
    ApplicationContext context;

    public BusApplicationContextResourceResolver() {
    }

    public BusApplicationContextResourceResolver(ApplicationContext c) {
        this.context = c;
    }

    public InputStream getAsStream(String name) {
        Resource r = this.context.getResource(name);
        if (r != null && r.exists()) {
            try {
                return r.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((r = this.context.getResource("/" + name)) != null && r.exists()) {
            try {
                return r.getInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T resolve(String resourceName, Class<T> resourceType) {
        try {
            T resource = null;
            resource = resourceName == null ? (T)resourceType.cast(this.context.getBean(resourceType)) : (T)resourceType.cast(this.context.getBean(resourceName, resourceType));
            return resource;
        }
        catch (NoSuchBeanDefinitionException resource) {
            try {
                Resource r;
                if (ClassLoader.class.isAssignableFrom(resourceType)) {
                    return resourceType.cast(this.context.getClassLoader());
                }
                if (URL.class.isAssignableFrom(resourceType) && (r = this.context.getResource(resourceName)) != null && r.exists()) {
                    r.getInputStream().close();
                    return resourceType.cast(r.getURL());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

