/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoHandler;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.sso20.acs.AcsHandler;
import com.ibm.ws.security.saml.sso20.metadata.MetadataHandler;
import com.ibm.ws.security.saml.sso20.slo.SLOHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HandlerFactory {
    public static final TraceComponent tc = Tr.register(HandlerFactory.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static MetadataHandler metadataHandler = new MetadataHandler();
    private static AcsHandler acsHandler = new AcsHandler();
    private static SLOHandler sloHandler = new SLOHandler();
    static final long serialVersionUID = -8567379225030120065L;

    public static SsoHandler getHandlerInstance(SsoRequest samlRequest) {
        SsoHandler result = null;
        Constants.SamlSsoVersion samlVersion = samlRequest.getSamlVersion();
        Constants.EndpointType type = samlRequest.getType();
        if (samlVersion == Constants.SamlSsoVersion.SAMLSSO20) {
            switch (type) {
                case SAMLMETADATA: {
                    return metadataHandler;
                }
                case ACS: {
                    return acsHandler;
                }
                case SLO: {
                    return sloHandler;
                }
                case LOGOUT: {
                    return sloHandler;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handler(" + (Object)((Object)samlVersion) + ")(" + (Object)((Object)type) + "):" + result), (Object[])new Object[0]);
        }
        return result;
    }

    public static MetadataHandler getMetadataHandler() {
        return metadataHandler;
    }

    public static void setMetadataHandler(MetadataHandler metadataHandler) {
        HandlerFactory.metadataHandler = metadataHandler;
    }

    public static AcsHandler getAcsHandler() {
        return acsHandler;
    }

    public static void setAcsHandler(AcsHandler acsHandler) {
        HandlerFactory.acsHandler = acsHandler;
    }
}

