/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal;

import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.batch.runtime.JobExecution;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.IOUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BatchRequestUtil {
    private static final TraceComponent tc = Tr.register(BatchRequestUtil.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.rest.resources.RESTMessages");
    public static final String NEWLINE = "%n";
    public static final String REST_URL_REGEX = "(.*\\/ibm\\/api\\/batch\\/(v[1-4]\\/)?)";
    private static boolean isSSLAvailable = true;
    static final long serialVersionUID = 3569650846284193836L;

    public static String normalizeURLPath(String path) {
        return (path = path.replaceAll("//*", "/")).endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public static String getUrlVersion(String url) {
        if (url == null) {
            return "";
        }
        Matcher matcher = BatchRequestUtil.matchPattern(url);
        matcher.find();
        if (matcher.group(2) == null) {
            return "";
        }
        return matcher.group(2);
    }

    public static String getUrlRoot(RESTRequest request) {
        Matcher matcher = BatchRequestUtil.matchPattern(request.getURL());
        matcher.find();
        return matcher.group(1);
    }

    private static Matcher matchPattern(String url) {
        Pattern pattern = Pattern.compile(REST_URL_REGEX);
        return pattern.matcher(url);
    }

    public static int getContentLength(RESTRequest request) {
        String contentLengthString = request.getHeader("Content-Length");
        return StringUtils.isEmpty(contentLengthString) ? 0 : Integer.parseInt(contentLengthString);
    }

    public static List<String> splitPath(String path) {
        path = BatchRequestUtil.normalizeURLPath(path);
        ArrayList<String> retMe = new ArrayList<String>();
        int idx = -1;
        while ((idx = path.indexOf("/")) >= 0) {
            if (idx > 0) {
                retMe.add(path.substring(0, idx));
            }
            path = path.substring(idx + 1);
        }
        if (path.length() > 0) {
            retMe.add(path);
        }
        return retMe;
    }

    public static void sendRedirect(RESTResponse response, String redirectUrl) {
        response.setResponseHeader("Location", redirectUrl);
        response.setStatus(302);
    }

    public static String buildStopUrl(String batchRestUrlRoot, long executionId) {
        return StringUtils.trimSuffix(batchRestUrlRoot, "/") + "/jobexecutions/" + executionId + "?action=stop";
    }

    public static String buildStopUrl(JobExecution jobExecution, String localUrlRoot) {
        return jobExecution instanceof WSJobExecution ? BatchRequestUtil.buildStopUrl(StringUtils.trimSuffix(((WSJobExecution)jobExecution).getRestUrl(), "/") + "/" + BatchRequestUtil.getUrlVersion(localUrlRoot), jobExecution.getExecutionId()) : BatchRequestUtil.buildStopUrl(localUrlRoot, jobExecution.getExecutionId());
    }

    public static String buildJoblogsUrl(String batchRestUrlRoot, long executionId) {
        return StringUtils.trimSuffix(batchRestUrlRoot, "/") + "/jobexecutions/" + executionId + "/joblogs";
    }

    public static String buildJoblogsUrl(JobExecution jobExecution, String localUrlRoot) {
        return jobExecution instanceof WSJobExecution ? BatchRequestUtil.buildJoblogsUrl(StringUtils.trimSuffix(((WSJobExecution)jobExecution).getRestUrl(), "/") + "/" + BatchRequestUtil.getUrlVersion(localUrlRoot), jobExecution.getExecutionId()) : BatchRequestUtil.buildJoblogsUrl(localUrlRoot, jobExecution.getExecutionId());
    }

    public static String buildJoblogsUrl(JobExecution jobExecution, String localUrlRoot, String queryString) {
        return BatchRequestUtil.buildJoblogsUrl(jobExecution, localUrlRoot) + (StringUtils.isEmpty(queryString) ? "" : "?" + queryString);
    }

    public static String buildQueryString(Map<String, String[]> parameterMap) {
        if (parameterMap == null) {
            return "";
        }
        ArrayList<String> parms = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            for (String val : entry.getValue()) {
                parms.add(entry.getKey() + "=" + val);
            }
        }
        return parms.isEmpty() ? "" : "?" + StringUtils.join(parms, "&");
    }

    public static String buildJoblogsUrlForJobInstance(long jobInstanceId, String restUrl, String queryString) {
        return StringUtils.trimSuffix(restUrl, "/") + "/jobinstances/" + jobInstanceId + "/joblogs" + (StringUtils.isEmpty(queryString) ? "" : "?" + queryString);
    }

    public static String buildStopUrlForJobInstance(long jobInstanceId, String restUrl) {
        return StringUtils.trimSuffix(restUrl, "/") + "/jobinstances/" + jobInstanceId + "?action=stop";
    }

    public static String buildPurgeUrlForJobInstance(long jobInstanceId, String restUrl) {
        return StringUtils.trimSuffix(restUrl, "/") + "/jobinstances/" + jobInstanceId;
    }

    public static HttpsURLConnection getConnection(URL url) {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            JSSEHelper jsseHelper = JSSEHelper.getInstance();
            connection.setSSLSocketFactory(jsseHelper.getSSLSocketFactory(null, null, null));
            return connection;
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.jbatch.rest.internal.BatchRequestUtil", (String)"269", null, (Object[])new Object[]{url});
        }
        catch (SSLException sSLException) {
            FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.jbatch.rest.internal.BatchRequestUtil", (String)"270", null, (Object[])new Object[]{url});
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.rest.internal.BatchRequestUtil", (String)"271", null, (Object[])new Object[]{url});
        }
        return null;
    }

    public static void handleNonLocalRequest(String restUrl, String requestMethod, RESTRequest request, RESTResponse response) throws ProtocolException, MalformedURLException, IOException {
        if (isSSLAvailable && !"true".equalsIgnoreCase(request.getParameter("permitRedirect"))) {
            BatchRequestUtil.sendRESTRequest(restUrl, requestMethod, request, response);
        }
        if (!isSSLAvailable || "true".equalsIgnoreCase(request.getParameter("permitRedirect"))) {
            BatchRequestUtil.sendRedirect(response, restUrl);
        }
    }

    public static HttpsURLConnection sendRESTRequest(String restUrl, String requestMethod, RESTRequest request, RESTResponse response) throws ProtocolException, MalformedURLException, IOException {
        if (isSSLAvailable) {
            URL url = new URL(restUrl);
            HttpsURLConnection connection = BatchRequestUtil.getConnection(url);
            connection.setRequestMethod(requestMethod);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            if (request.getHeader("Authorization") != null) {
                connection.setRequestProperty("Authorization", request.getHeader("Authorization").trim());
            }
            if (request.getHeader("Content-Type") != null) {
                connection.setRequestProperty("Content-Type", request.getHeader("Content-Type").trim());
            }
            if (request.getHeader("Cookie") != null) {
                connection.setRequestProperty("Cookie", request.getHeader("Cookie").trim());
            }
            try {
                int rc = connection.getResponseCode();
                if (response != null) {
                    if (connection.getResponseCode() == 200) {
                        if ("zip".equals(request.getParameter("type"))) {
                            response.setContentType("application/zip");
                            response.setResponseHeader("Content-Disposition", connection.getHeaderField("Content-Disposition"));
                        } else if ("text".equals(request.getParameter("type"))) {
                            response.setContentType("text/plain; charset=UTF-8");
                        }
                        IOUtils.copy((InputStream)connection.getInputStream(), (OutputStream)response.getOutputStream());
                    } else {
                        String errorMsg = IOUtils.toString((InputStream)connection.getInputStream());
                        response.sendError(500, "An internal request to " + connection.getURL() + " failed. The response code was " + rc + " " + connection.getResponseMessage() + " and the error message was " + errorMsg);
                    }
                }
            }
            catch (SSLHandshakeException rc) {
                FFDCFilter.processException((Throwable)rc, (String)"com.ibm.ws.jbatch.rest.internal.BatchRequestUtil", (String)"348", null, (Object[])new Object[]{restUrl, requestMethod, request, response});
                Tr.info((TraceComponent)tc, (String)"ssl.connection.unavailable", (Object[])new Object[]{connection.getURL().getHost()});
                isSSLAvailable = false;
            }
            return connection;
        }
        Tr.debug((TraceComponent)tc, (String)("A request to " + restUrl + " could not be completed. An SSL connection to the endpoint was not available."), (Object[])new Object[0]);
        return null;
    }

    public static boolean getSSLAvailable() {
        return isSSLAvailable;
    }
}

