/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.utils.AuditUtils;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApiAuthnTerminateEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(ApiAuthnTerminateEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 1519686722747744764L;

    public ApiAuthnTerminateEvent() {
        this.set("eventName", "SECURITY_API_AUTHN_TERMINATE");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public ApiAuthnTerminateEvent(HttpServletRequest req, AuthenticationResult authResult, Integer statusCode) {
        block14: {
            this();
            try {
                String agent;
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                this.set("target.credential.type", authResult.getAuditCredType());
                if (authResult.getAuditCredValue() != null) {
                    this.set("target.credential.token", authResult.getAuditCredValue());
                } else if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                String sessionID = AuditUtils.getSessionID(req);
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                this.set("target.method", AuditUtils.getRequestMethod(req));
                this.set("target.realm", AuditUtils.getRealmName());
                if (authResult.getAuditAuthConfigProviderName() != null) {
                    this.set("target.jaspi.provider", authResult.getAuditAuthConfigProviderName());
                }
                if (authResult.getAuditAuthConfigProviderAuthType() != null) {
                    this.set("target.jaspi.authtype", authResult.getAuditAuthConfigProviderAuthType());
                }
                if (statusCode != null) {
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                    if (statusCode == 200) {
                        this.setOutcome("success");
                    } else {
                        this.setOutcome("failure");
                    }
                }
            }
            catch (Exception agent) {
                void e;
                FFDCFilter.processException((Throwable)agent, (String)"com.ibm.ws.security.audit.event.ApiAuthnTerminateEvent", (String)"93", (Object)((Object)this), (Object[])new Object[]{req, authResult, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating SessionLogoutEvent", (Object[])new Object[]{e});
            }
        }
    }
}

