/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.extension;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.config.internal.common.ConfigIntrospectionProvider;
import io.openliberty.microprofile.config.internal.extension.ConfigWrapper;
import io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ConfigProviderResolver.class, ApplicationStateListener.class, ConfigIntrospectionProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, immediate=true)
public class OLSmallRyeConfigProviderResolver
extends SmallRyeConfigProviderResolver
implements ApplicationStateListener,
ConfigIntrospectionProvider {
    private static final TraceComponent tc = Tr.register(OLSmallRyeConfigProviderResolver.class, (String)"APPCONFIG", null);
    private final Map<Config, ConfigWrapper> configCache = new HashMap<Config, ConfigWrapper>();
    static final long serialVersionUID = 2246776123888599223L;

    public void activate(ComponentContext cc) {
        ConfigProviderResolver.setInstance((ConfigProviderResolver)this);
    }

    public void deactivate(ComponentContext cc) throws IOException {
        ConfigProviderResolver.setInstance(null);
    }

    @Override
    public SmallRyeConfigBuilder getBuilder() {
        return new OLSmallRyeConfigBuilder().addDefaultInterceptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConfig(Config config, ClassLoader classLoader) {
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            super.registerConfig(config, classLoader);
            this.registerConfig(config, classLoader, OLSmallRyeConfigProviderResolver.getApplicationName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config getConfig(ClassLoader classLoader) {
        Config config = null;
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            config = super.getConfig(classLoader);
            this.registerConfig(config, classLoader, OLSmallRyeConfigProviderResolver.getApplicationName());
        }
        return config;
    }

    private void registerConfig(Config config, ClassLoader classLoader, String applicationName) {
        ConfigWrapper wrapper = this.configCache.computeIfAbsent(config, cfg -> new ConfigWrapper((Config)cfg));
        wrapper.addApplication(applicationName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.traceCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConfig(Config config) {
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            this.deregisterAndReleaseConfig(config);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.traceCache();
            }
        }
    }

    private void deregisterAndReleaseConfig(Config config) {
        super.releaseConfig(config);
        this.configCache.remove(config);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        ExtendedApplicationInfo extendedAppInfo = (ExtendedApplicationInfo)appInfo;
        String applicationName = extendedAppInfo.getMetaData().getJ2EEName().getApplication();
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            HashSet<Config> configsToRelease = new HashSet<Config>();
            for (ConfigWrapper wrapper : this.configCache.values()) {
                boolean empty = wrapper.removeApplication(applicationName);
                if (!empty) continue;
                configsToRelease.add(wrapper.getConfig());
            }
            for (Config config : configsToRelease) {
                this.deregisterAndReleaseConfig(config);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.traceCache();
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        this.applicationStopping(appInfo);
    }

    private static String getApplicationName() {
        ComponentMetaDataAccessorImpl cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        ComponentMetaData cmd = cmdai.getComponentMetaData();
        String applicationName = null;
        if (cmd != null) {
            J2EEName applicationJEEName = cmd.getModuleMetaData().getApplicationMetaData().getJ2EEName();
            applicationName = applicationJEEName.getApplication();
        }
        if (applicationName == null) {
            applicationName = "!GLOBAL_CONFIG_APPLICATION_NAME!";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to determine application name for Config. Using \"" + applicationName + "\"."), (Object[])new Object[0]);
                OLSmallRyeConfigProviderResolver.traceStack();
            }
        }
        return applicationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<Config>> getConfigsByApplication() {
        HashMap<String, Set<Config>> appInfos = new HashMap<String, Set<Config>>();
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            for (ConfigWrapper wrapper : this.configCache.values()) {
                for (String appName : wrapper.listApplications()) {
                    appInfos.computeIfAbsent(appName, x -> new HashSet()).add(wrapper.getConfig());
                }
            }
        }
        return appInfos;
    }

    @Trivial
    private static void traceStack() {
        Exception e = new Exception();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(os);){
            e.printStackTrace(pw);
        }
        Tr.debug((TraceComponent)tc, (String)("OLSmallRyeConfigProviderResolver call stack: " + ((Object)os).toString()), (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void traceCache() {
        StringBuilder builder = new StringBuilder("\n# OLSmallRyeConfigProviderResolver config cache #\n");
        Map<Config, ConfigWrapper> map = this.configCache;
        synchronized (map) {
            for (ConfigWrapper wrapper : this.configCache.values()) {
                builder.append("########################\n");
                builder.append("Config : ");
                builder.append(wrapper.getConfig());
                builder.append("\n");
                for (String appName : wrapper.listApplications()) {
                    builder.append("--> Application: ");
                    builder.append(appName);
                    builder.append("\n");
                }
            }
            builder.append("########################\n");
        }
        Tr.debug((TraceComponent)tc, (String)builder.toString(), (Object[])new Object[0]);
    }
}

