/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.twitter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.twitter.TwitterConstants;
import com.ibm.ws.security.social.twitter.Utils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TwitterEndpointServices {
    private static TraceComponent tc = Tr.register(TwitterEndpointServices.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private String consumerKey = null;
    @Sensitive
    private String consumerSecret = null;
    @Sensitive
    private String tokenSecret = null;
    private final String DEFAULT_SIGNATURE_ALGORITHM = "HMAC-SHA1";
    private final String DEFAULT_OAUTH_VERSION = "1.0";
    private String requestMethod = "POST";
    private OAuthClientHttpUtil httpUtil = OAuthClientHttpUtil.getInstance();
    static final long serialVersionUID = -3831568906130405804L;

    protected void setOAuthClientHttpUtil(OAuthClientHttpUtil util) {
        this.httpUtil = util;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String newKey) {
        if (newKey == null || newKey.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"TWITTER_MISSING_REQ_ATTR", (Object[])new Object[]{"consumerKey"});
        }
        this.consumerKey = newKey;
    }

    public void setConsumerSecret(@Sensitive String newConsumerSecret) {
        if (newConsumerSecret == null || newConsumerSecret.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"TWITTER_MISSING_REQ_ATTR", (Object[])new Object[]{"consumerSecret"});
        }
        this.consumerSecret = newConsumerSecret;
    }

    protected void setTokenSecret(@Sensitive String newSecret) {
        this.tokenSecret = newSecret;
    }

    public String computeSignature(String requestMethod, String targetUrl, Map<String, String> params) {
        return this.computeSignature(requestMethod, targetUrl, params, this.consumerSecret, this.tokenSecret);
    }

    /*
     * WARNING - void declaration
     */
    public String computeSignature(String requestMethod, String targetUrl, Map<String, String> params, @Sensitive String consumerSecret, @Sensitive String tokenSecret) {
        String signature;
        block5: {
            String signatureBaseString = this.createSignatureBaseString(requestMethod, targetUrl, params);
            signature = "";
            try {
                String secretToEncode = null;
                if (consumerSecret != null) {
                    secretToEncode = consumerSecret;
                }
                StringBuilder keyString = new StringBuilder(Utils.percentEncodeSensitive(secretToEncode)).append("&");
                if (tokenSecret != null) {
                    keyString.append(Utils.percentEncodeSensitive(tokenSecret));
                }
                signature = this.computeSha1Signature(signatureBaseString, keyString.toString());
            }
            catch (GeneralSecurityException secretToEncode) {
                void e;
                Object[] objectArray = new Object[5];
                objectArray[0] = requestMethod;
                objectArray[1] = targetUrl;
                objectArray[2] = params;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)secretToEncode, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"136", (Object)this, (Object[])objectArray);
                Tr.warning((TraceComponent)tc, (String)"TWITTER_ERROR_CREATING_SIGNATURE", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            catch (UnsupportedEncodingException e) {
                Object[] objectArray = new Object[5];
                objectArray[0] = requestMethod;
                objectArray[1] = targetUrl;
                objectArray[2] = params;
                objectArray[3] = "<sensitive java.lang.String>";
                objectArray[4] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"138", (Object)this, (Object[])objectArray);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Caught unexpected exception: " + e.getLocalizedMessage()), (Object[])new Object[]{e});
            }
        }
        return signature;
    }

    protected String computeSha1Signature(String baseString, @Sensitive String keyString) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] keyBytes = keyString.getBytes("UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        byte[] text = baseString.getBytes("UTF-8");
        return new String(Base64.encodeBase64((byte[])mac.doFinal(text)), "UTF-8").trim();
    }

    public String createParameterStringForSignature(Map<String, String> parameters) {
        if (parameters == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null parameters object provided; returning empty string", (Object[])new Object[0]);
            }
            return "";
        }
        HashMap<String, String> encodedParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String encodedKey = Utils.percentEncode(entry.getKey());
            String encodedValue = Utils.percentEncode(entry.getValue());
            encodedParams.put(encodedKey, encodedValue);
        }
        ArrayList encodedKeysList = new ArrayList();
        encodedKeysList.addAll(encodedParams.keySet());
        Collections.sort(encodedKeysList);
        StringBuilder paramString = new StringBuilder();
        for (int i = 0; i < encodedKeysList.size(); ++i) {
            String key = (String)encodedKeysList.get(i);
            String value = (String)encodedParams.get(key);
            paramString.append(key).append("=").append(value);
            if (i >= encodedKeysList.size() - 1) continue;
            paramString.append("&");
        }
        return paramString.toString();
    }

    public String createSignatureBaseString(String requestMethod, String baseUrl, Map<String, String> parameters) {
        if (requestMethod == null || !requestMethod.equalsIgnoreCase("GET") && !requestMethod.equalsIgnoreCase("POST")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request method was not an expected value (GET or POST) so defaulting to POST", (Object[])new Object[0]);
            }
            requestMethod = "POST";
        }
        String cleanedUrl = this.removeQueryAndFragment(baseUrl);
        String parameterString = this.createParameterStringForSignature(parameters);
        StringBuilder signatureBaseString = new StringBuilder();
        signatureBaseString.append(requestMethod.toUpperCase());
        signatureBaseString.append("&");
        signatureBaseString.append(Utils.percentEncode(cleanedUrl));
        signatureBaseString.append("&");
        signatureBaseString.append(Utils.percentEncode(parameterString));
        return signatureBaseString.toString();
    }

    protected String removeQueryAndFragment(String url) {
        if (url == null) {
            return url;
        }
        String cleanUrl = url;
        int queryIndex = url.indexOf("?");
        int fragmentIndex = url.indexOf("#");
        if (queryIndex > 0) {
            cleanUrl = fragmentIndex > 0 && fragmentIndex < queryIndex ? url.substring(0, fragmentIndex) : url.substring(0, queryIndex);
        } else if (fragmentIndex > 0) {
            cleanUrl = url.substring(0, fragmentIndex);
        }
        return cleanUrl;
    }

    public String createAuthorizationHeaderString(Map<String, String> parameters) {
        StringBuilder authzHeaderString = new StringBuilder();
        authzHeaderString.append("OAuth ");
        if (parameters == null) {
            return authzHeaderString.toString();
        }
        ArrayList<String> sortedKeys = new ArrayList<String>();
        sortedKeys.addAll(parameters.keySet());
        Collections.sort(sortedKeys);
        boolean isParamAlreadyPresent = false;
        for (String key : sortedKeys) {
            if (!TwitterConstants.AUTHZ_HEADER_PARAMS.contains(key)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Skipping unexpected parameter: " + key), (Object[])new Object[0]);
                continue;
            }
            if (isParamAlreadyPresent) {
                authzHeaderString.append(", ");
            }
            String value = parameters.get(key);
            String encodedKey = Utils.percentEncode(key);
            String encodedValue = Utils.percentEncode(value);
            authzHeaderString.append(encodedKey).append("=\"").append(encodedValue).append("\"");
            isParamAlreadyPresent = true;
        }
        return authzHeaderString.toString();
    }

    private Map<String, String> populateCommonAuthzHeaderParams() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_consumer_key", this.consumerKey);
        parameters.put("oauth_nonce", Utils.generateNonce());
        parameters.put("oauth_signature_method", "HMAC-SHA1");
        parameters.put("oauth_timestamp", Utils.getCurrentTimestamp());
        parameters.put("oauth_version", "1.0");
        return parameters;
    }

    private Map<String, String> populateRequestTokenEndpointAuthzHeaderParams(String callbackUrl) {
        Map<String, String> parameters = this.populateCommonAuthzHeaderParams();
        parameters.put("oauth_callback", callbackUrl);
        return parameters;
    }

    private Map<String, String> populateAuthorizedEndpointAuthzHeaderParams(String token) {
        Map<String, String> parameters = this.populateCommonAuthzHeaderParams();
        parameters.put("oauth_token", token);
        return parameters;
    }

    private Map<String, String> populateVerifyCredentialsEndpointAuthzHeaderParams(String token) {
        Map<String, String> parameters = this.populateCommonAuthzHeaderParams();
        parameters.put("oauth_token", token);
        parameters.put("include_email", "true");
        parameters.put("skip_status", "true");
        return parameters;
    }

    private String signAndCreateAuthzHeader(String endpointUrl, Map<String, String> parameters) {
        String signature = this.computeSignature(this.requestMethod, endpointUrl, parameters);
        parameters.put("oauth_signature", signature);
        String authzHeaderString = this.createAuthorizationHeaderString(parameters);
        return authzHeaderString;
    }

    public String createAuthzHeaderForRequestTokenEndpoint(String callbackUrl, String endpointUrl) {
        Map<String, String> parameters = this.populateRequestTokenEndpointAuthzHeaderParams(callbackUrl);
        return this.signAndCreateAuthzHeader(endpointUrl, parameters);
    }

    public String createAuthzHeaderForAuthorizedEndpoint(String endpointUrl, String token) {
        Map<String, String> parameters = this.populateAuthorizedEndpointAuthzHeaderParams(token);
        return this.signAndCreateAuthzHeader(endpointUrl, parameters);
    }

    public String createAuthzHeaderForVerifyCredentialsEndpoint(String endpointUrl, String token) {
        Map<String, String> parameters = this.populateVerifyCredentialsEndpointAuthzHeaderParams(token);
        return this.signAndCreateAuthzHeader(endpointUrl, parameters);
    }

    @Sensitive
    public Map<String, String> populateResponseValues(@Sensitive String responseBody) {
        HashMap<String, String> responseValues = new HashMap<String, String>();
        if (responseBody == null) {
            return responseValues;
        }
        StringTokenizer st = new StringTokenizer(responseBody, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String[] keyValue = token.split("=");
            String key = keyValue[0];
            String value = "";
            if (keyValue.length > 1) {
                value = keyValue[1];
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(key + ": [" + ("oauth_token_secret".equals(key) ? "****" : value) + "]"), (Object[])new Object[0]);
            }
            responseValues.put(key, value);
        }
        return responseValues;
    }

    public Map<String, Object> populateJsonResponse(String responseBody) throws JoseException {
        if (responseBody == null || responseBody.isEmpty()) {
            return null;
        }
        return JsonUtil.parseJson((String)responseBody);
    }

    protected Map<String, Object> createErrorResponse(String msgKey, Object[] args) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (msgKey == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null message key provided; result will include empty error message", (Object[])new Object[0]);
            }
            msgKey = "";
        }
        String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])args);
        response.put("response_status", "error");
        response.put("message", errorMsg);
        return response;
    }

    protected Map<String, Object> createErrorResponse(Exception exception) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("response_status", "error");
        response.put("message", exception.getLocalizedMessage());
        return response;
    }

    public <T> Map<String, Object> checkForEmptyResponse(String endpoint, @Sensitive String responseBody, @Sensitive Map<String, T> responseValues) {
        if (responseValues == null || responseValues.isEmpty()) {
            return this.createErrorResponse("TWITTER_RESPONSE_HAS_NO_PARAMS", new Object[]{endpoint, responseBody});
        }
        return null;
    }

    public <T> Map<String, Object> checkForRequiredParameters(String endpoint, @Sensitive Map<String, T> responseValues, String ... requiredParams) {
        if (responseValues == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The provided response values map is null, so all required parameters will be determined to be missing", (Object[])new Object[0]);
        }
        ArrayList<String> missingParams = new ArrayList<String>();
        for (String param : requiredParams) {
            if (responseValues != null && responseValues.containsKey(param)) continue;
            missingParams.add(param);
        }
        if (!missingParams.isEmpty()) {
            return this.createErrorResponse("TWITTER_RESPONSE_MISSING_PARAMETER", new Object[]{endpoint, Arrays.toString(missingParams.toArray(new String[0]))});
        }
        return null;
    }

    public Map<String, Object> evaluateRequestTokenResponse(String responseBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String endpoint = "/oauth/request_token";
        Map<String, String> responseValues = this.populateResponseValues(responseBody);
        Map<String, Object> result = this.checkForEmptyResponse(endpoint, responseBody, responseValues);
        if (result != null) {
            return result;
        }
        result = this.checkForRequiredParameters(endpoint, responseValues, "oauth_callback_confirmed", "oauth_token", "oauth_token_secret");
        if (result != null) {
            return result;
        }
        String callbackConfirmedVal = responseValues.get("oauth_callback_confirmed");
        if (!callbackConfirmedVal.equalsIgnoreCase("true")) {
            return this.createErrorResponse("TWITTER_RESPONSE_PARAM_WITH_WRONG_VALUE", new Object[]{"oauth_callback_confirmed", endpoint, "true", callbackConfirmedVal});
        }
        String requestToken = "";
        for (Map.Entry<String, String> entry : responseValues.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("oauth_token")) {
                requestToken = value;
                if (requestToken.isEmpty()) {
                    return this.createErrorResponse("TWITTER_RESPONSE_PARAMETER_EMPTY", new Object[]{"oauth_token", endpoint});
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("oauth_token=" + requestToken), (Object[])new Object[0]);
                continue;
            }
            if (key.equals("oauth_token_secret")) {
                this.tokenSecret = value;
                if (this.tokenSecret.isEmpty()) {
                    return this.createErrorResponse("TWITTER_RESPONSE_PARAMETER_EMPTY", new Object[]{"oauth_token_secret", endpoint});
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("oauth_token_secret=" + this.tokenSecret), (Object[])new Object[0]);
                continue;
            }
            if (key.equals("oauth_callback_confirmed") || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Found an unexpected parameter in the response: " + key + "=" + value), (Object[])new Object[0]);
        }
        response.put("response_status", "success");
        response.put("oauth_token", requestToken);
        response.put("oauth_token_secret", this.tokenSecret);
        return response;
    }

    @Sensitive
    public Map<String, Object> evaluateAccessTokenResponse(@Sensitive String responseBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String endpoint = "/oauth/access_token";
        Map<String, String> responseValues = this.populateResponseValues(responseBody);
        Map<String, Object> result = this.checkForEmptyResponse(endpoint, responseBody, responseValues);
        if (result != null) {
            return result;
        }
        result = this.checkForRequiredParameters(endpoint, responseValues, "oauth_token", "oauth_token_secret");
        if (result != null) {
            return result;
        }
        String accessToken = "";
        String userId = "";
        String screenName = "";
        for (Map.Entry<String, String> entry : responseValues.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("oauth_token")) {
                accessToken = value;
                if (accessToken.isEmpty()) {
                    return this.createErrorResponse("TWITTER_RESPONSE_PARAMETER_EMPTY", new Object[]{"oauth_token", endpoint});
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("oauth_token=" + accessToken), (Object[])new Object[0]);
                continue;
            }
            if (key.equals("oauth_token_secret")) {
                this.tokenSecret = value;
                if (this.tokenSecret.isEmpty()) {
                    return this.createErrorResponse("TWITTER_RESPONSE_PARAMETER_EMPTY", new Object[]{"oauth_token_secret", endpoint});
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"oauth_token_secret=****", (Object[])new Object[0]);
                continue;
            }
            if (key.equals("user_id")) {
                userId = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("user_id=" + userId), (Object[])new Object[0]);
                continue;
            }
            if (key.equals("screen_name")) {
                screenName = value;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("screen_name=" + screenName), (Object[])new Object[0]);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Found an unexpected parameter in the response: " + key + "=" + value), (Object[])new Object[0]);
        }
        response.put("response_status", "success");
        response.put("access_token", accessToken);
        response.put("access_token_secret", this.tokenSecret);
        response.put("id", userId);
        response.put("screen_name", screenName);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> evaluateVerifyCredentialsResponse(String responseBody) {
        String endpoint = "/1.1/account/verify_credentials.json";
        Map<String, Object> responseValues = null;
        try {
            responseValues = this.populateJsonResponse(responseBody);
        }
        catch (JoseException joseException) {
            void e;
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"755", (Object)this, (Object[])new Object[]{responseBody});
            return this.createErrorResponse("TWITTER_RESPONSE_NOT_JSON", new Object[]{endpoint, e.getLocalizedMessage(), responseBody});
        }
        Map<String, Object> result = this.checkForEmptyResponse(endpoint, responseBody, responseValues);
        if (result != null) {
            return result;
        }
        result = this.checkForRequiredParameters(endpoint, responseValues, "email");
        if (result != null) {
            return result;
        }
        responseValues.put("response_status", "success");
        return responseValues;
    }

    @Sensitive
    public Map<String, Object> evaluateRequestResponse(@Sensitive String responseBody, String endpointPath) {
        return this.evaluateRequestResponse(responseBody, 200, endpointPath);
    }

    @Sensitive
    public Map<String, Object> evaluateRequestResponse(@Sensitive String responseBody, int statusLine, String endpointPath) {
        Map<String, Object> response = null;
        if (responseBody == null) {
            return this.createErrorResponse("TWITTER_EMPTY_RESPONSE_BODY", new Object[]{endpointPath});
        }
        if (200 != statusLine) {
            return this.createErrorResponse("TWITTER_ENDPOINT_REQUEST_FAILED", new Object[]{endpointPath, statusLine, responseBody});
        }
        if (endpointPath == null) {
            endpointPath = "/oauth/request_token";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("A Twitter endpoint path was not found; defaulting to using " + endpointPath + " as the Twitter endpoint path."), (Object[])new Object[0]);
            }
        }
        if (endpointPath.equals("/oauth/request_token")) {
            response = this.evaluateRequestTokenResponse(responseBody);
        } else if (endpointPath.equals("/oauth/access_token")) {
            response = this.evaluateAccessTokenResponse(responseBody);
        } else if (endpointPath.equals("/1.1/account/verify_credentials.json")) {
            response = this.evaluateVerifyCredentialsResponse(responseBody);
        }
        return response;
    }

    @Sensitive
    @FFDCIgnore(value={SocialLoginException.class})
    public Map<String, Object> executeRequest(SocialLoginConfig config, String requestMethod, String authzHeaderString, String url, String endpointType, String verifierValue) {
        if (endpointType == null) {
            endpointType = "/oauth/request_token";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("A Twitter endpoint path was not found; defaulting to using " + endpointType + " as the Twitter endpoint path."), (Object[])new Object[0]);
            }
        }
        try {
            SocialUtil.validateEndpointWithQuery(url);
        }
        catch (SocialLoginException e) {
            return this.createErrorResponse(e);
        }
        StringBuilder uri = new StringBuilder(url);
        if (endpointType.equals("/1.1/account/verify_credentials.json")) {
            uri.append("?").append("include_email").append("=").append("true").append("&").append("skip_status").append("=").append("true");
        }
        try {
            Map<String, Object> result = this.getEndpointResponse(config, uri.toString(), requestMethod, authzHeaderString, endpointType, verifierValue);
            String responseContent = this.httpUtil.extractTokensFromResponse(result);
            return this.evaluateRequestResponse(responseContent, endpointType);
        }
        catch (SocialLoginException e) {
            return this.createErrorResponse("TWITTER_EXCEPTION_EXECUTING_REQUEST", new Object[]{url, e.getLocalizedMessage()});
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, Object> getEndpointResponse(SocialLoginConfig config, String uri, String requestMethod, String authzHeaderString, String endpointPath, String verifierValue) throws SocialLoginException {
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = config.getSSLSocketFactory();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"871", (Object)this, (Object[])new Object[]{config, uri, requestMethod, authzHeaderString, endpointPath, verifierValue});
            throw new SocialLoginException("FAILED_TO_GET_SSL_CONTEXT", (Exception)e, new Object[]{config.getUniqueId(), e.getLocalizedMessage()});
        }
        SocialUtil.validateEndpointWithQuery(uri);
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        headers.add((NameValuePair)new BasicNameValuePair("Content-Type", "application/x-www-form-urlencoded"));
        if (authzHeaderString != null) {
            headers.add((NameValuePair)new BasicNameValuePair("Authorization", authzHeaderString));
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (endpointPath != null && endpointPath.equals("/oauth/access_token")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding verifier value [" + verifierValue + "] to POST body"), (Object[])new Object[0]);
            }
            params.add((NameValuePair)new BasicNameValuePair("oauth_verifier", Utils.percentEncode(verifierValue)));
        }
        Map<String, Object> result = null;
        result = requestMethod != null && requestMethod.equalsIgnoreCase("POST") ? this.httpUtil.postToEndpoint(uri.toString(), params, null, null, null, sslSocketFactory, headers, false, null, config.getUseSystemPropertiesForHttpClientConnections()) : this.httpUtil.getToEndpoint(uri.toString(), params, null, null, null, sslSocketFactory, headers, false, null, config.getUseSystemPropertiesForHttpClientConnections());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> obtainRequestToken(SocialLoginConfig config, String callbackUrl) {
        String endpointUrl = config.getRequestTokenUrl();
        try {
            SocialUtil.validateEndpointWithQuery(endpointUrl);
        }
        catch (SocialLoginException socialLoginException) {
            void e;
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"919", (Object)this, (Object[])new Object[]{config, callbackUrl});
            return this.createErrorResponse("TWITTER_BAD_REQUEST_TOKEN_URL", new Object[]{endpointUrl, "requestTokenUrl", config.getUniqueId(), e.getLocalizedMessage()});
        }
        String authzHeaderString = this.createAuthzHeaderForRequestTokenEndpoint(callbackUrl, endpointUrl);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authz header string: " + authzHeaderString), (Object[])new Object[0]);
        }
        return this.executeRequest(config, this.requestMethod, authzHeaderString, endpointUrl, "/oauth/request_token", null);
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    public Map<String, Object> obtainAccessToken(SocialLoginConfig config, String requestToken, String verifierOrPinValue) {
        String endpointUrl = config.getTokenEndpoint();
        try {
            SocialUtil.validateEndpointWithQuery(endpointUrl);
        }
        catch (SocialLoginException socialLoginException) {
            void e;
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"951", (Object)this, (Object[])new Object[]{config, requestToken, verifierOrPinValue});
            return this.createErrorResponse("TWITTER_BAD_ACCESS_TOKEN_URL", new Object[]{endpointUrl, "accessTokenUrl", config.getUniqueId(), e.getLocalizedMessage()});
        }
        String authzHeaderString = this.createAuthzHeaderForAuthorizedEndpoint(endpointUrl, requestToken);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authz header string: " + authzHeaderString), (Object[])new Object[0]);
        }
        return this.executeRequest(config, this.requestMethod, authzHeaderString, endpointUrl, "/oauth/access_token", verifierOrPinValue);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> verifyCredentials(SocialLoginConfig config, String accessToken, @Sensitive String accessTokenSecret) {
        String endpointUrl = config.getUserApi();
        try {
            SocialUtil.validateEndpointWithQuery(endpointUrl);
        }
        catch (SocialLoginException socialLoginException) {
            void e;
            Object[] objectArray = new Object[3];
            objectArray[0] = config;
            objectArray[1] = accessToken;
            objectArray[2] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.twitter.TwitterEndpointServices", (String)"978", (Object)this, (Object[])objectArray);
            return this.createErrorResponse("TWITTER_BAD_USER_API_URL", new Object[]{endpointUrl, "userApi", config.getUniqueId(), e.getLocalizedMessage()});
        }
        this.tokenSecret = accessTokenSecret;
        this.requestMethod = "GET";
        String authzHeaderString = this.createAuthzHeaderForVerifyCredentialsEndpoint(endpointUrl, accessToken);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authz header string: " + authzHeaderString), (Object[])new Object[0]);
        }
        return this.executeRequest(config, this.requestMethod, authzHeaderString, endpointUrl, "/1.1/account/verify_credentials.json", null);
    }
}

