/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.internal.AcmeConfigService;
import com.ibm.ws.security.acme.internal.AcmeProviderImpl;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpConnector {
    private static final TraceComponent tc;
    private static final String USER_AGENT;
    static final long serialVersionUID = 119443865648977802L;

    public static String defaultUserAgent() {
        return USER_AGENT;
    }

    public HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
        this.configure(conn, url);
        return conn;
    }

    protected void configure(HttpURLConnection conn, URL url) throws IOException {
        int readTimeout;
        int connectTimeout;
        if (AcmeConfigService.getThreadLocalAcmeConfig() != null) {
            connectTimeout = AcmeConfigService.getThreadLocalAcmeConfig().getHTTPConnectTimeout();
            readTimeout = AcmeConfigService.getThreadLocalAcmeConfig().getHTTPReadTimeout();
        } else {
            connectTimeout = AcmeProviderImpl.getAcmeConfig().getHTTPConnectTimeout();
            readTimeout = AcmeProviderImpl.getAcmeConfig().getHTTPReadTimeout();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting http timeouts for ACME calls, connectTimeout: " + connectTimeout + " and readTimeout: " + readTimeout), (Object[])new Object[0]);
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", USER_AGENT);
        String scheme = url.getProtocol();
        String host = url.getHost();
        if (!(!(conn instanceof HttpsURLConnection) || "acme".equalsIgnoreCase(scheme) && "pebble".equalsIgnoreCase(host))) {
            HttpsURLConnection conns = (HttpsURLConnection)conn;
            conns.setSSLSocketFactory(this.createSocketFactory(url));
            conns.setHostnameVerifier((h, s) -> true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected synchronized SSLSocketFactory createSocketFactory(URL providerURL) throws IOException {
        String methodName = "createSocketFactory(URL)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSocketFactory(URL)", (Object[])new Object[]{providerURL});
        }
        HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        connectionInfo.put("com.ibm.ssl.remoteHost", providerURL.getHost());
        connectionInfo.put("com.ibm.ssl.remotePort", providerURL.getPort() == -1 ? "434" : Integer.toString(providerURL.getPort()));
        SSLConfig sslConfig = AcmeConfigService.getThreadLocalAcmeConfig() != null ? AcmeConfigService.getThreadLocalAcmeConfig().getSSLConfig() : AcmeProviderImpl.getSSLConfig();
        if (sslConfig.getProperty("com.ibm.ssl.trustStore") != null) {
            try {
                SSLContext ctx = JSSEHelper.getInstance().getSSLContext(connectionInfo, (Properties)sslConfig);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSocketFactory(URL)", ctx.getClass());
                }
                return ctx.getSocketFactory();
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"org.shredzone.acme4j.connector.HttpConnector", (String)"225", (Object)this, (Object[])new Object[]{providerURL});
                throw new IOException("Failed to generate SSLContext with custom TrustManager.", (Throwable)e);
            }
        }
        try {
            String protocol = sslConfig.getProperty("com.ibm.ssl.protocol");
            SSLContext sslContext = null;
            if (protocol != null) {
                sslContext = SSLContext.getInstance(protocol);
                sslContext.init(null, AbstractJSSEProvider.getDefaultTrustManager(), null);
            } else {
                sslContext = SSLContext.getDefault();
            }
            return sslContext.getSocketFactory();
        }
        catch (Exception protocol) {
            void e;
            FFDCFilter.processException((Throwable)protocol, (String)"org.shredzone.acme4j.connector.HttpConnector", (String)"251", (Object)this, (Object[])new Object[]{providerURL});
            throw new IOException("Failed to generate SSLSocketFactory with default TrustManager.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        StringBuilder agent;
        block9: {
            tc = Tr.register(HttpConnector.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
            agent = new StringBuilder("acme4j");
            try {
                InputStream in = HttpConnector.class.getResourceAsStream("/org/shredzone/acme4j/version.properties");
                try {
                    if (in == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Could not read /org/shredzone/acme4j/version.properties, ignore and skip library version.", (Object[])new Object[0]);
                        }
                    } else {
                        Properties prop = new Properties();
                        prop.load(in);
                        agent.append('/').append(prop.getProperty("version"));
                    }
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"org.shredzone.acme4j.connector.HttpConnector", (String)"63", null, (Object[])new Object[0]);
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"org.shredzone.acme4j.connector.HttpConnector", (String)"63", null, (Object[])new Object[0]);
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                in.close();
            }
            catch (Exception in) {
                void ex;
                FFDCFilter.processException((Throwable)in, (String)"org.shredzone.acme4j.connector.HttpConnector", (String)"74", null, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Could not read library version, ignore and skip adding it.", (Object[])new Object[]{ex});
            }
        }
        agent.append(" Java/").append(System.getProperty("java.version"));
        USER_AGENT = agent.toString();
    }
}

